/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyConfigConverter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final String OLD_JDBC_DRIVER_KEY = "jdbc.drivers";
    private static final String OLD_JDBC_DATASOURCES_KEY = "jdbc.datasources";
    private static final String OLD_JDBC_XA_DATASOURCES_KEY = "jdbc20.datasources";
    private static final String OLD_JDBC_DELIMITER = "|";
    private static final String KEY_DELIMITER = ".";
    private static final String OLD_XA_DATASOURCE_PREFIX = "xadatasource";
    private static final String OLD_XA_JNDI_NAME = "jndiname";
    private static final String OLD_XA_CLASSNAME = "classname";
    private static final String OLD_XA_DB_USER = "dbuser";
    private static final String OLD_XA_DB_PASSWORD = "dbpassword";
    private static final String OLD_PROP_INDICATOR = "prop";
    private static final boolean debug = false;
    private J2EEResourceFactory resourceFactory_;

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            LegacyConfigConverter legacyConfigConverter = new LegacyConfigConverter();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Reading old jdbc properties from " + string);
                _logger.log(Level.FINE, "Destination file is " + string2);
            }
            legacyConfigConverter.convert(string, string2);
        } else {
            System.out.println("Usage : <old_props_file> <new_props_file>");
            System.out.println("For example : /a/b/default.properties /a/b/resource.properties");
        }
    }

    public void convert(String string, String string2) {
        block5: {
            InputStream inputStream = null;
            try {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                inputStream = new BufferedInputStream(fileInputStream);
                Properties properties = new Properties();
                properties.load(inputStream);
                this.resourceFactory_ = ServerConfiguration.getJ2EEResourceFactory();
                J2EEResourceCollection j2EEResourceCollection = this.resourceFactory_.loadResourceCollection(string2);
                this.convertJdbcDrivers(properties, j2EEResourceCollection);
                this.convertJdbcResources(properties, j2EEResourceCollection);
                this.convertJdbcXAResources(properties, j2EEResourceCollection);
                this.resourceFactory_.storeResourceCollection(j2EEResourceCollection, string2);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Conversion complete.  " + string + " has not been changed.  Please remove any obsolete jdbc properties if it will be used as a default.properties file in j2ee");
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_legacyconfigconverter_convert", exception);
                if (inputStream == null) break block5;
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {}
            }
        }
    }

    private void convertJdbcDrivers(Properties properties, J2EEResourceCollection j2EEResourceCollection) throws Exception {
        String string = properties.getProperty(OLD_JDBC_DRIVER_KEY);
        if (string == null) {
            _logger.log(Level.FINE, "No Jdbc Drivers...");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, OLD_JDBC_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            J2EEResource j2EEResource = this.resourceFactory_.createResource(5, string2);
            j2EEResourceCollection.addResource(j2EEResource);
        }
    }

    private void convertJdbcResources(Properties properties, J2EEResourceCollection j2EEResourceCollection) throws Exception {
        String string = properties.getProperty(OLD_JDBC_DATASOURCES_KEY);
        if (string == null) {
            _logger.log(Level.FINE, "No Jdbc Resources...");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, OLD_JDBC_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            JdbcResource jdbcResource = (JdbcResource)this.resourceFactory_.createResource(3, string2);
            j2EEResourceCollection.addResource(jdbcResource);
        }
    }

    private void convertJdbcXAResources(Properties properties, J2EEResourceCollection j2EEResourceCollection) throws Exception {
        Object object;
        String string;
        String string2 = properties.getProperty(OLD_JDBC_XA_DATASOURCES_KEY);
        if (string2 == null) {
            _logger.log(Level.FINE, "No XA Jdbc Resources...");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, OLD_JDBC_DELIMITER);
        int n = 0;
        Hashtable<String, JdbcXAResource> hashtable = new Hashtable<String, JdbcXAResource>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            object = (JdbcXAResource)this.resourceFactory_.createResource(4, string3);
            hashtable.put(string, (JdbcXAResource)object);
            j2EEResourceCollection.addResource((J2EEResource)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < n) {
            string = "xadatasource." + n2 + KEY_DELIMITER;
            object = properties.getProperty(string + OLD_XA_JNDI_NAME);
            JdbcXAResource jdbcXAResource = (JdbcXAResource)hashtable.get(object);
            String string4 = properties.getProperty(string + OLD_XA_CLASSNAME);
            String string5 = properties.getProperty(string + OLD_XA_DB_USER);
            String string6 = properties.getProperty(string + OLD_XA_DB_PASSWORD);
            jdbcXAResource.setClassname(string4);
            this.setJdbcXAProps(properties, jdbcXAResource, n2);
            ++n2;
        }
    }

    private void setJdbcXAProps(Properties properties, JdbcXAResource jdbcXAResource, int n) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        String string = "xadatasource." + n + KEY_DELIMITER + OLD_PROP_INDICATOR + KEY_DELIMITER;
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!string2.startsWith(string)) continue;
            int n2 = string2.lastIndexOf(KEY_DELIMITER);
            String string4 = string2.substring(n2 + 1);
            ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(string4, string3);
            jdbcXAResource.addProperty(resourcePropertyImpl);
        }
    }
}

