/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class AuthMechType
extends ConnectorTest
implements ConnectorCheck {
    private static String[] allowedMechs = new String[]{ConnectorNode.DD_BASIC_PASSWORD, ConnectorNode.DD_KERBEROS};

    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        Set set = connectorDescriptor.getAuthMechanisms();
        if (set.isEmpty()) {
            result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.nonexist", "No authentication mechanism defined for this resource adapater", new Object[]{connectorDescriptor.getConnectionFactoryImpl()}));
            return result;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            String string = authMechanism.getAuthMechType();
            boolean bl2 = false;
            if (string != null) {
                int n = 0;
                while (n < allowedMechs.length) {
                    if (string.equals(allowedMechs[n])) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl2 && string != null) continue;
            bl = true;
            result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.failed", "Authentication mechanism type [ {0} ] is not allowed", new Object[]{string}));
        }
        if (!bl) {
            result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.passed", "All defined authentication mechanism types are allowed", new Object[]{connectorDescriptor.getConnectionFactoryImpl()}));
        }
        return result;
    }
}

