/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.iplanet.ias.security.Audit;
import com.iplanet.ias.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.LocalCredentialsImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import sun.security.x509.X500Name;

public class LoginContextDriver {
    private static Logger _logger;
    private static final boolean debug = false;
    public static String CERT_REALMNAME;
    public static String AUTHMETHOD;
    private static String CLIENT_JAAS_PASSWORD;
    private static String CLIENT_JAAS_CERTIFICATE;
    private static LocalStringManagerImpl localStrings;
    private static ServerLoginCallbackHandler dummyCallback;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$LoginContextDriver;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$LocalCredentialsImpl;

    public static void login(String string, String string2) {
        String string3 = Realm.getDefaultRealm();
        final Subject subject = new Subject();
        final PasswordCredential passwordCredential = new PasswordCredential(string, string2, string3);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPrivateCredentials().add(passwordCredential);
                return subject;
            }
        });
        LoginContextDriver.login(subject, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
    }

    public static void login(Subject subject, Class clazz) throws LoginException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Processing login with credentials of type: " + clazz.toString());
        }
        if (clazz.equals(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential)) {
            LoginContextDriver.doPasswordLogin(subject);
        } else if (clazz.equals(class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential)) {
            LoginContextDriver.doCertificateLogin(subject);
        } else if (clazz.equals(class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = LoginContextDriver.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential)) {
            LoginContextDriver.doAnonLogin(subject);
        } else if (clazz.equals(class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = LoginContextDriver.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName)) {
            LoginContextDriver.doGSSUPLogin(subject);
        } else if (clazz.equals(class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = LoginContextDriver.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name)) {
            LoginContextDriver.doX500Login(subject);
        } else {
            _logger.log(Level.INFO, "java_security.unknown_credential", clazz.toString());
            throw new LoginException("Unknown credential type, cannot login.");
        }
    }

    private static void doPasswordLogin(Subject subject) throws LoginException {
        Object object;
        final Subject subject2 = subject;
        Object object2 = LoginContextDriver.getPrivateCredentials(subject2, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
        if (!$assertionsDisabled && object2 == null) {
            throw new AssertionError();
        }
        PasswordCredential passwordCredential = (PasswordCredential)object2;
        String string = passwordCredential.getUser();
        String string2 = passwordCredential.getPassword();
        String string3 = passwordCredential.getRealm();
        String string4 = Realm.getInstance(string3).getJAASContext();
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string3 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string4 == null) {
            throw new AssertionError();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Logging in user [" + string + "] into realm: " + string3 + " using JAAS module: " + string4);
        }
        try {
            object = new LoginContext(string4, subject2, dummyCallback);
            ((LoginContext)object).login();
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "java_security.audit_auth_refused", string);
            }
            throw new LoginException("Login failed: " + exception.toString());
        }
        if (Audit.isActive() && _logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "java_security.audit_auth_accepted", string);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Password login succeeded for : " + string);
        }
        object = null;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Credentials credentials = null;
                Set set = subject2.getPublicCredentials(class$com$sun$enterprise$security$auth$LocalCredentialsImpl == null ? (class$com$sun$enterprise$security$auth$LocalCredentialsImpl = LoginContextDriver.class$("com.sun.enterprise.security.auth.LocalCredentialsImpl")) : class$com$sun$enterprise$security$auth$LocalCredentialsImpl);
                Iterator iterator = set.iterator();
                if (iterator.hasNext()) {
                    credentials = (Credentials)iterator.next();
                    subject2.getPublicCredentials().remove(credentials);
                    return credentials;
                }
                return credentials;
            }
        });
        object = (Credentials)t;
        LoginContextDriver.setSecurityContext(string, subject2, (Credentials)object);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Set security context as user: " + string);
        }
    }

    private static void doCertificateLogin(Subject subject) throws LoginException {
        _logger.log(Level.FINE, "Processing X509 certificate login.");
        Object object = LoginContextDriver.getPublicCredentials(subject, class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential);
        X509CertificateCredential x509CertificateCredential = (X509CertificateCredential)object;
        String string = x509CertificateCredential.getAlias();
        Credentials credentials = LoginContextDriver.generateDummyCredential(string, CERT_REALMNAME, AUTHMETHOD);
        _logger.log(Level.FINE, "Set security context as user: " + string);
        LoginContextDriver.setSecurityContext(string, subject, credentials);
    }

    private static void doAnonLogin(Subject subject) throws LoginException {
        SecurityContext.setUnauthenticatedContext();
        _logger.log(Level.FINE, "Set anonymous security context.");
    }

    private static void doGSSUPLogin(Subject subject) throws LoginException {
        _logger.fine("Processing GSSUP login.");
        Object object = LoginContextDriver.getPublicCredentials(subject, class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = LoginContextDriver.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName);
        Credentials credentials = null;
        String string = ((GSSUPName)object).getUser();
        String string2 = Realm.getDefaultRealm();
        credentials = LoginContextDriver.generateDummyCredential(string, string2, AUTHMETHOD);
        LoginContextDriver.setSecurityContext(string, subject, credentials);
        if (Audit.isActive()) {
            _logger.log(Level.INFO, "java_security.audit_auth_accepted", string);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSUP login succeeded for : " + string);
        }
    }

    private static void doX500Login(Subject subject) throws LoginException {
        _logger.fine("Processing X.500 name login.");
        X500Name x500Name = (X500Name)LoginContextDriver.getPublicCredentials(subject, class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = LoginContextDriver.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name);
        String string = x500Name.getName();
        Realm realm = Realm.getDefaultInstance();
        if (realm instanceof CertificateRealm) {
            CertificateRealm certificateRealm = (CertificateRealm)realm;
            certificateRealm.authenticate(subject, x500Name);
        } else {
            _logger.warning("certlogin.badrealm");
            String string2 = Realm.getDefaultRealm();
            Credentials credentials = LoginContextDriver.generateDummyCredential(string, string2, AUTHMETHOD);
            LoginContextDriver.setSecurityContext(string, subject, credentials);
        }
        if (Audit.isActive() && _logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "java_security.audit_auth_accepted", string);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("X.500 name login succeeded for : " + string);
        }
    }

    private static Object getPublicCredentials(Subject subject, Class clazz) throws LoginException {
        Set set = subject.getPublicCredentials(clazz);
        final Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            _logger.finer("Expected public credentials of type : " + clazz.toString() + " but none found.");
            throw new LoginException("Expected public credential of type: " + clazz.toString() + " but none found.");
        }
        Object var4_4 = null;
        try {
            var4_4 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iterator.next();
                }
            });
        }
        catch (Exception exception) {
            throw new LoginException("Failed to retrieve public credential: " + exception.toString());
        }
        return var4_4;
    }

    private static Object getPrivateCredentials(Subject subject, Class clazz) throws LoginException {
        final Subject subject2 = subject;
        final Class clazz2 = clazz;
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return subject2.getPrivateCredentials(clazz2);
            }
        });
        final Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            _logger.finer("Expected private credential of type: " + clazz.toString() + " but none found.");
            throw new LoginException("Expected private credential of type: " + clazz.toString() + " but none found.");
        }
        Object var6_6 = null;
        try {
            var6_6 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iterator.next();
                }
            });
        }
        catch (Exception exception) {
            throw new LoginException("Failed to retrieve private credential: " + exception.toString());
        }
        return var6_6;
    }

    public static Subject doClientLogin(int n, CallbackHandler callbackHandler) throws LoginException {
        final CallbackHandler callbackHandler2 = callbackHandler;
        final Subject subject = new Subject();
        if (n == 1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext loginContext = new LoginContext(CLIENT_JAAS_PASSWORD, subject, callbackHandler2);
                        loginContext.login();
                    }
                    catch (javax.security.auth.login.LoginException loginException) {
                        throw new LoginException(loginException.toString());
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            return subject;
        }
        if (n == 2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext loginContext = new LoginContext(CLIENT_JAAS_CERTIFICATE, subject, callbackHandler2);
                        loginContext.login();
                    }
                    catch (javax.security.auth.login.LoginException loginException) {
                        throw new LoginException(loginException.toString());
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential);
            return subject;
        }
        if (n == 3) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext loginContext = new LoginContext(CLIENT_JAAS_PASSWORD, subject, callbackHandler2);
                        LoginContext loginContext2 = new LoginContext(CLIENT_JAAS_CERTIFICATE, subject, callbackHandler2);
                        loginContext.login();
                        LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
                        loginContext2.login();
                        LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential);
                    }
                    catch (javax.security.auth.login.LoginException loginException) {
                        throw new LoginException(loginException.toString());
                    }
                    return null;
                }
            });
            return subject;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LoginContext loginContext = new LoginContext(CLIENT_JAAS_PASSWORD, subject, callbackHandler2);
                    loginContext.login();
                    LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
                }
                catch (javax.security.auth.login.LoginException loginException) {
                    throw new LoginException(loginException.toString());
                }
                return null;
            }
        });
        return subject;
    }

    private static void postClientAuth(Subject subject, Class clazz) {
        final Class clazz2 = clazz;
        final Subject subject2 = subject;
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return subject2.getPrivateCredentials(clazz2);
            }
        });
        final Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object var6_6 = null;
            try {
                var6_6 = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.accesscontroller_action_exception", exception);
            }
            if (var6_6 instanceof PasswordCredential) {
                PasswordCredential passwordCredential = var6_6;
                String string = passwordCredential.getUser();
                String string2 = passwordCredential.getRealm();
                Credentials credentials = LoginContextDriver.generateDummyCredential(string, string2, AUTHMETHOD);
                LoginContextDriver.setClientSecurityContext(string, subject2, credentials);
                return;
            }
            if (!(var6_6 instanceof X509CertificateCredential)) continue;
            X509CertificateCredential x509CertificateCredential = var6_6;
            String string = x509CertificateCredential.getAlias();
            String string3 = x509CertificateCredential.getRealm();
            Credentials credentials = LoginContextDriver.generateDummyCredential(string, string3, AUTHMETHOD);
            LoginContextDriver.setClientSecurityContext(string, subject2, credentials);
            return;
        }
    }

    public static Credentials generateDummyCredential(String string, String string2, String string3) {
        int n = 0;
        LocalCredentialsImpl localCredentialsImpl = new LocalCredentialsImpl();
        AuthenticationInfoImpl authenticationInfoImpl = new AuthenticationInfoImpl(string, string2, true);
        authenticationInfoImpl.setAttribute("Groups", new Privilege[0]);
        AuthenticationStatusImpl authenticationStatusImpl = new AuthenticationStatusImpl(string, AUTHMETHOD, string2, n);
        localCredentialsImpl.setAuthenticationStatus(authenticationStatusImpl);
        localCredentialsImpl.addAuthenticationInfo(authenticationInfoImpl);
        return localCredentialsImpl;
    }

    public static void loginPrincipal(String string) throws LoginException {
        String string2 = Realm.getDefaultRealm();
        final Subject subject = new Subject();
        final GSSUPName gSSUPName = new GSSUPName(string, string2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPublicCredentials().add(gSSUPName);
                return null;
            }
        });
        Credentials credentials = LoginContextDriver.generateDummyCredential(string, string2, AUTHMETHOD);
        LoginContextDriver.setSecurityContext(string, subject, credentials);
    }

    public static void logout() throws LoginException {
        LoginContextDriver.unsetSecurityContext();
    }

    private static void setClientSecurityContext(String string, Subject subject, Credentials credentials) {
        ClientSecurityContext clientSecurityContext = new ClientSecurityContext(string, credentials, subject);
        ClientSecurityContext.setCurrent(clientSecurityContext);
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }

    private static void setSecurityContext(String string, Subject subject, Credentials credentials) {
        SecurityContext securityContext = new SecurityContext(string, credentials, subject);
        SecurityContext.setCurrent(securityContext);
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$enterprise$security$auth$LoginContextDriver == null ? (class$com$sun$enterprise$security$auth$LoginContextDriver = LoginContextDriver.class$("com.sun.enterprise.security.auth.LoginContextDriver")) : class$com$sun$enterprise$security$auth$LoginContextDriver).desiredAssertionStatus();
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        CERT_REALMNAME = "certificate";
        AUTHMETHOD = "password";
        CLIENT_JAAS_PASSWORD = "default";
        CLIENT_JAAS_CERTIFICATE = "certificate";
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$LoginContextDriver == null ? (class$com$sun$enterprise$security$auth$LoginContextDriver = LoginContextDriver.class$("com.sun.enterprise.security.auth.LoginContextDriver")) : class$com$sun$enterprise$security$auth$LoginContextDriver);
        dummyCallback = new ServerLoginCallbackHandler();
    }
}

