/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KeyTool {
    private static Logger _logger = null;
    private static final String JSSE_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private boolean debug = false;
    private File inputFile = null;
    private File outputFile = null;
    private char[] jksKeyStorePass;
    private char[] pkcsKeyStorePass = null;
    private char[] jksKeyPass = null;
    private char[] pkcsKeyPass = null;
    private String provider = null;
    private KeyStore pkcs12KeyStore = null;
    private KeyStore jksKeyStore = null;
    private static String PKCS12;
    private static String INFILE;
    private static String OUTFILE;
    private static String PKCSKEYSTOREPASS;
    private static String PKCSKEYPASS;
    private static String JKSKEYSTOREPASS;
    private static String JKSKEYPASS;
    private static LocalStringManagerImpl localStrings;
    static /* synthetic */ Class class$com$sun$enterprise$security$KeyTool;

    public KeyTool(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        this.inputFile = new File(string);
        this.outputFile = new File(string2);
        this.pkcsKeyStorePass = string3.toCharArray();
        this.pkcsKeyPass = string4.toCharArray();
        this.jksKeyStorePass = string5.toCharArray();
        this.jksKeyPass = string6.toCharArray();
        this.provider = string7;
        try {
            if (this.outputFile.exists()) {
                throw new IOException("Output file already exists!");
            }
            this.pkcs12KeyStore = KeyStore.getInstance("PKCS12", string7);
            this.jksKeyStore = KeyStore.getInstance("JKS");
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.readKeyStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readKeyStores() throws IOException {
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(this.inputFile);
            fileInputStream2 = new FileInputStream(this.outputFile);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.pkcs12KeyStore.load(fileInputStream, this.pkcsKeyStorePass);
                this.jksKeyStore.load(fileInputStream2, null);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.KeyStore_load_exception", exception);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileInputStream2 != null) {
                fileInputStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJksKeyStore() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.outputFile);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.jksKeyStore.store(fileOutputStream, this.jksKeyStorePass);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.KeyStore_store_exception", exception);
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void replicatePkcs12ToJks() throws Exception {
        Enumeration<String> enumeration = this.pkcs12KeyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (this.pkcs12KeyStore.isKeyEntry(string)) {
                if (this.debug) {
                    _logger.log(Level.FINE, "Alias " + string + " is a key entry ");
                }
                Key key = this.pkcs12KeyStore.getKey(string, this.pkcsKeyPass);
                Certificate[] certificateArray = this.pkcs12KeyStore.getCertificateChain(string);
                this.jksKeyStore.setKeyEntry(string, key, this.jksKeyPass, certificateArray);
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(string)) continue;
            if (this.debug) {
                _logger.log(Level.FINE, " Alias " + string + " is a certificate entry");
            }
            this.jksKeyStore.setCertificateEntry(string, this.pkcs12KeyStore.getCertificate(string));
        }
    }

    public void info() throws Exception {
        _logger.log(Level.FINEST, " Keystore Information");
        _logger.log(Level.FINEST, " Type = " + this.pkcs12KeyStore.getType());
        _logger.log(Level.FINEST, " Provider = " + this.pkcs12KeyStore.getProvider());
        _logger.log(Level.FINEST, " KeyStore size = " + this.pkcs12KeyStore.size());
        Enumeration<String> enumeration = this.pkcs12KeyStore.aliases();
        _logger.log(Level.FINEST, " Kstore Aliases ");
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            _logger.log(Level.FINEST, " Alias = " + string);
            if (this.pkcs12KeyStore.isKeyEntry(string)) {
                _logger.log(Level.FINEST, "Alias is a key entry ");
                Key key = this.pkcs12KeyStore.getKey(string, this.pkcsKeyPass);
                _logger.log(Level.FINEST, " Format = " + key.getFormat());
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(string)) continue;
            _logger.log(Level.FINEST, " Alias is a certificate entry");
        }
        _logger.log(Level.FINEST, " End of Information");
    }

    public static void initProvider() {
        try {
            Provider provider = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.provider_exception", exception);
        }
    }

    public static String getProviderName() {
        try {
            Provider provider = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            return provider.getName();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.getName_exception", exception);
            return null;
        }
    }

    public static void help(boolean bl) {
        System.out.println(localStrings.getLocalString("enterprise.security.keytool", "keytool"));
        System.out.println(localStrings.getLocalString("enterprise.security.keytooloptions", "PKCS Options:"));
        System.out.println(" " + PKCS12 + " " + INFILE + " fileName" + " " + PKCSKEYSTOREPASS + " password" + " " + PKCSKEYPASS + " password" + " " + OUTFILE + " outputFileName" + " " + JKSKEYSTOREPASS + " password");
        if (bl) {
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        block11: {
            boolean bl = false;
            KeyTool.initProvider();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            try {
                if (stringArray.length == 0) {
                    KeyTool.help(false);
                    sun.security.tools.KeyTool.main((String[])stringArray);
                }
                if (stringArray[0].equalsIgnoreCase(PKCS12)) {
                    bl = true;
                    if (stringArray.length != 11) {
                        KeyTool.help(true);
                    }
                    if (!stringArray[1].equalsIgnoreCase(INFILE)) {
                        KeyTool.help(true);
                    }
                    string2 = stringArray[2];
                    if (!stringArray[3].equalsIgnoreCase(PKCSKEYSTOREPASS)) {
                        KeyTool.help(true);
                    }
                    string7 = stringArray[4];
                    if (!stringArray[5].equalsIgnoreCase(PKCSKEYPASS)) {
                        KeyTool.help(true);
                    }
                    string6 = stringArray[6];
                    if (!stringArray[7].equalsIgnoreCase(OUTFILE)) {
                        KeyTool.help(true);
                    }
                    string3 = stringArray[8];
                    if (!stringArray[9].equalsIgnoreCase(JKSKEYSTOREPASS)) {
                        KeyTool.help(true);
                    }
                    string4 = string5 = stringArray[10];
                }
                if (!bl) {
                    sun.security.tools.KeyTool.main((String[])stringArray);
                    break block11;
                }
                string = KeyTool.getProviderName();
                KeyTool keyTool = new KeyTool(string2, string3, string7, string6, string5, string4, string);
                keyTool.replicatePkcs12ToJks();
                keyTool.writeJksKeyStore();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.main_exception", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        PKCS12 = "-pkcs12";
        INFILE = "-pkcsFile";
        OUTFILE = "-jksFile";
        PKCSKEYSTOREPASS = "-pkcsKeyStorePass";
        PKCSKEYPASS = "-pkcsKeyPass";
        JKSKEYSTOREPASS = "-jksKeyStorePass";
        JKSKEYPASS = "-jksKeyPass";
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$KeyTool == null ? (class$com$sun$enterprise$security$KeyTool = KeyTool.class$("com.sun.enterprise.security.KeyTool")) : class$com$sun$enterprise$security$KeyTool);
    }
}

