/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.RepositoryNameParser;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

class RepositoryContext
implements Context {
    private static Logger _logger = null;
    public static final String REPOSITORY_NAME = "com.sun.enterprise.repository.name";
    public static final String REPOSITORY_DIR = "com.sun.enterprise.repository.dir";
    Hashtable myEnv;
    private Properties bindings;
    private static final boolean debug = false;
    static NameParser myParser;
    private static final String DEFAULT_NAMETABLE_DIR = "config/";
    private static final String DEFAULT_NAME = "default";
    private static final String FILE_EXT = ".properties";

    RepositoryContext(Hashtable hashtable) {
        this.myEnv = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.resurrectTable();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }

    public Object lookup(String string) throws NamingException {
        if (string.equals("")) {
            return new RepositoryContext(this.myEnv);
        }
        Object object = this.bindings.get(string);
        if (object == null) {
            throw new NameNotFoundException(string + " not found");
        }
        return object;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        if (string.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (this.bindings.get(string) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(string, object);
        this.store();
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        if (string.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.bindings.put(string, object);
        this.store();
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void unbind(String string) throws NamingException {
        if (string.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        this.bindings.remove(string);
        this.store();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (string.equals("") || string2.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.bindings.get(string2) != null) {
            throw new NameAlreadyBoundException(string2 + " is already bound");
        }
        Object object = this.bindings.remove(string);
        if (object == null) {
            throw new NameNotFoundException(string + " not bound");
        }
        this.bindings.put(string2, object);
        this.store();
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.equals("")) {
            return new RepNames(this.bindings.keys());
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.equals("")) {
            return new RepBindings(this.bindings.keys());
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.store();
        this.myEnv = null;
        this.bindings = null;
    }

    private void store() {
        try {
            if (this.bindings != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.getStoragePath());
                this.bindings.store(fileOutputStream, "Repository resource mapping");
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.store_exception", exception);
        }
    }

    static String getFilePath(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string3 = string2 + RepositoryContext.FILE_EXT;
                if (string3 != null) {
                    String string22 = FileUtil.getAbsolutePath(string + string3);
                    File file = new File(string22);
                    if (!file.exists()) {
                        string3 = "default.properties";
                    }
                } else {
                    string3 = "default.properties";
                }
                return FileUtil.getAbsolutePath(string + string3);
            }
        });
    }

    private String getStoragePath() {
        String string = (String)this.myEnv.get(REPOSITORY_DIR);
        if (string == null) {
            string = DEFAULT_NAMETABLE_DIR;
        }
        return RepositoryContext.getFilePath(string, (String)this.myEnv.get(REPOSITORY_NAME));
    }

    public static String getRepositoryName(String string) {
        String string2 = RepositoryContext.getFilePath(DEFAULT_NAMETABLE_DIR, string);
        int n = string2.lastIndexOf(File.separator);
        String string3 = null;
        string3 = n > 0 ? string2.substring(n + 1) : string2;
        int n2 = string3.lastIndexOf(FILE_EXT);
        String string4 = n2 > 0 ? string3.substring(0, n2) : string3;
        return string4;
    }

    private void resurrectTable() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                RepositoryContext.this.bindings = new Properties();
                try {
                    File file = new File(RepositoryContext.this.getStoragePath());
                    if (file.exists()) {
                        RepositoryContext.this.bindings.load(new FileInputStream(file));
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "enterprise.load_exception", exception);
                }
                return null;
            }
        });
    }

    private static void print(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        myParser = new RepositoryNameParser();
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;

        RepBindings(Enumeration enumeration) {
            this.names = enumeration;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                return new Binding(string, RepositoryContext.this.bindings.get(string));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Enumeration names;

        RepNames(Enumeration enumeration) {
            this.names = enumeration;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                String string2 = RepositoryContext.this.bindings.get(string).getClass().getName();
                return new NameClassPair(string, string2);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }
    }
}

