/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.PartitionImpl;
import com.sun.ejb.persistence.RelationshipManager;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public final class PMSet
extends AbstractSet {
    private static final boolean debug = false;
    private static final String invalidMsg = "Collection may have been accessed after transaction completion.";
    private HashSet joinObjects;
    private PartitionImpl partition;
    private PersistentState sourceObj;
    private RelationRoleDescriptor role;
    private JoinObjectDescriptor joinDesc;
    private RelationshipManager rm;
    private ArrayList liveIterators = new ArrayList();
    private boolean isComplete;
    private boolean isValid = true;

    PMSet(PartitionImpl partitionImpl, PersistentState persistentState, RelationRoleDescriptor relationRoleDescriptor, RelationshipManager relationshipManager, HashSet hashSet, boolean bl) {
        this.partition = partitionImpl;
        this.sourceObj = persistentState;
        this.role = relationRoleDescriptor;
        this.joinDesc = relationRoleDescriptor.getRelationshipDescriptor().getJoinDescriptor();
        this.rm = relationshipManager;
        this.joinObjects = hashSet;
        this.isComplete = bl;
    }

    public Iterator iterator() {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        PMIterator pMIterator = new PMIterator(this, this.joinObjects.iterator());
        this.liveIterators.add(pMIterator);
        return pMIterator;
    }

    public int size() {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        return this.joinObjects.size();
    }

    public boolean add(Object object) {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        if (object == null) {
            throw new IllegalArgumentException("Cannot add null to a relationship");
        }
        try {
            this.rm.checkCollectionSinkType(this.sourceObj, object, this.role.getPartner());
            PersistentState persistentState = this.partition.getOrCreateJoinObject(this.sourceObj, this.role, object, this.joinDesc, false);
            if (this.joinObjects.contains(persistentState)) {
                return false;
            }
            this.rm.collectionAdd(persistentState, this.joinDesc, this.sourceObj, object, this.role, this.partition);
            this.partition.addJoinObject(persistentState, this.joinDesc, this.role);
            boolean bl = this.joinObjects.add(persistentState);
            if (bl) {
                if (persistentState.__getStatus() == 0) {
                    persistentState.__setStatus(2);
                } else {
                    persistentState.__setStatus(4);
                }
                this.invalidateIterators();
            }
            return bl;
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
            return false;
        }
    }

    public boolean remove(Object object) {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        try {
            this.rm.checkCollectionSinkType(this.sourceObj, object, this.role.getPartner());
            PersistentState persistentState = this.partition.getOrCreateJoinObject(this.sourceObj, this.role, object, this.joinDesc, true);
            if (this.joinObjects.contains(persistentState)) {
                this.beforeRemove(persistentState);
                this.joinObjects.remove(persistentState);
                this.invalidateIterators();
                return true;
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
        }
        return false;
    }

    private void invalidateIterators() {
        int n = 0;
        while (n < this.liveIterators.size()) {
            PMIterator pMIterator = (PMIterator)this.liveIterators.get(n);
            pMIterator.collectionModified = true;
            ++n;
        }
        this.liveIterators.clear();
    }

    void invalidate() {
        this.isValid = false;
        this.invalidateIterators();
    }

    void addJoinObject(Object object) {
        this.joinObjects.add(object);
        this.invalidateIterators();
    }

    void removeJoinObject(Object object) {
        this.joinObjects.remove(object);
        this.invalidateIterators();
    }

    RelationRoleDescriptor getRole() {
        return this.role;
    }

    boolean getIsComplete() {
        return this.isComplete;
    }

    void complete(HashSet hashSet) {
        hashSet.addAll(this.joinObjects);
        this.joinObjects = hashSet;
        this.isComplete = true;
        this.invalidateIterators();
    }

    private Object getSink(Object object) throws Exception {
        Object object2 = this.partition.getJoinSink(object, this.joinDesc, this.role);
        return object2;
    }

    private void beforeRemove(PersistentState persistentState) throws Exception {
        if (persistentState.__getStatus() == 2) {
            persistentState.__setStatus(0);
        } else {
            persistentState.__setStatus(3);
        }
        this.rm.collectionRemove(persistentState, this.joinDesc, this.role, this.partition);
    }

    private final class PMIterator
    implements Iterator {
        private static final String errMsg = "Collection modified or transaction completed";
        private PMSet pmset;
        private Iterator itr;
        private Object lastElem;
        private boolean collectionModified = false;

        PMIterator(PMSet pMSet2, Iterator iterator) {
            this.pmset = pMSet2;
            this.itr = iterator;
        }

        public boolean hasNext() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            return this.itr.hasNext();
        }

        public Object next() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            try {
                this.lastElem = this.itr.next();
                return this.pmset.getSink(this.lastElem);
            }
            catch (Exception exception) {
                EJBUtils.throwEJBException(exception);
                return null;
            }
        }

        public void remove() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            try {
                this.pmset.beforeRemove((PersistentState)this.lastElem);
                this.itr.remove();
            }
            catch (Exception exception) {
                EJBUtils.throwEJBException(exception);
            }
        }
    }
}

