/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.iiop.BufferManagerRead;
import com.sun.corba.ee.internal.iiop.BufferManagerReadGrow;
import com.sun.corba.ee.internal.iiop.BufferManagerReadStream;
import com.sun.corba.ee.internal.iiop.BufferManagerWrite;
import com.sun.corba.ee.internal.iiop.BufferManagerWriteCollect;
import com.sun.corba.ee.internal.iiop.BufferManagerWriteGrow;
import com.sun.corba.ee.internal.iiop.BufferManagerWriteStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;

public class BufferManagerFactory {
    public static final int GROW = 0;
    public static final int COLLECT = 1;
    public static final int STREAM = 2;

    public static BufferManagerRead newBufferManagerRead(GIOPVersion gIOPVersion, ORB oRB) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                return new BufferManagerReadGrow();
            }
            case 257: 
            case 258: {
                return new BufferManagerReadStream();
            }
        }
        throw new INTERNAL();
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion gIOPVersion, ORB oRB, int n) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                return new BufferManagerWriteGrow(n);
            }
            case 257: {
                int n2 = oRB != null ? ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion) : 0;
                if (n2 == 0) {
                    return new BufferManagerWriteGrow(n);
                }
                return new BufferManagerWriteCollect(n);
            }
            case 258: {
                int n3 = oRB != null ? ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion) : 2;
                if (n3 == 0) {
                    return new BufferManagerWriteGrow(n);
                }
                if (n3 == 1) {
                    return new BufferManagerWriteCollect(n);
                }
                return new BufferManagerWriteStream(n);
            }
        }
        throw new INTERNAL();
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion gIOPVersion, ORB oRB) {
        switch (gIOPVersion.intValue()) {
            case 256: {
                int n = oRB != null ? ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBufferSize() : 1024;
                return new BufferManagerWriteGrow(n);
            }
            case 257: {
                int n;
                int n2;
                if (oRB != null) {
                    n2 = ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPFragmentSize();
                    n = ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion);
                } else {
                    n2 = 1024;
                    n = 0;
                }
                if (n == 0) {
                    return new BufferManagerWriteGrow(n2);
                }
                return new BufferManagerWriteCollect(n2);
            }
            case 258: {
                int n;
                int n3;
                if (oRB != null) {
                    n3 = ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPFragmentSize();
                    n = ((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBuffMgrStrategy(gIOPVersion);
                } else {
                    n3 = 1024;
                    n = 2;
                }
                if (n == 0) {
                    return new BufferManagerWriteGrow(n3);
                }
                if (n == 1) {
                    return new BufferManagerWriteCollect(n3);
                }
                return new BufferManagerWriteStream(n3);
            }
        }
        throw new INTERNAL();
    }

    public static BufferManagerWrite defaultBufferManagerWrite(ORB oRB) {
        if (oRB == null || !(oRB instanceof com.sun.corba.ee.internal.corba.ORB)) {
            return new BufferManagerWriteGrow(1024);
        }
        return new BufferManagerWriteGrow(((com.sun.corba.ee.internal.corba.ORB)oRB).getGIOPBufferSize());
    }

    public static BufferManagerRead defaultBufferManagerRead() {
        return new BufferManagerReadGrow();
    }
}

