/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.scheduler;

import com.iplanet.ias.util.collection.DListNode;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.iplanet.ias.util.scheduler.TaskData;

public class TimedTaskList {
    private DListNode first = new DListNode(null);
    private DListNode last;
    private int size = 0;

    protected TimedTaskList() {
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
    }

    protected int size() {
        return this.size;
    }

    protected TaskData getFirstTask() {
        DListNode dListNode = this.first;
        dListNode = dListNode.next;
        if (null != dListNode.next) {
            dListNode.delink();
            --this.size;
            return (TaskData)dListNode.object;
        }
        return null;
    }

    protected boolean addTask(PeriodicallyServicable periodicallyServicable, int n, long l) {
        TaskData taskData = new TaskData();
        taskData.obj = periodicallyServicable;
        taskData.abs_execute_time = l + (long)n - periodicallyServicable.getFrequency();
        return this.insertTask(taskData);
    }

    protected boolean insertTask(TaskData taskData) {
        taskData.abs_execute_time += taskData.obj.getFrequency();
        DListNode dListNode = new DListNode(taskData);
        DListNode dListNode2 = this.first;
        ++this.size;
        int n = 0;
        while (n < this.size - 1) {
            dListNode2 = dListNode2.next;
            long l = ((TaskData)dListNode2.object).abs_execute_time;
            if (l > taskData.abs_execute_time) {
                dListNode2.insertBefore(dListNode);
                return true;
            }
            ++n;
        }
        dListNode2.insertAfter(dListNode);
        return true;
    }

    protected boolean removeTask(PeriodicallyServicable periodicallyServicable) {
        DListNode dListNode = this.first;
        int n = 0;
        while (n < this.size) {
            dListNode = dListNode.next;
            PeriodicallyServicable periodicallyServicable2 = ((TaskData)dListNode.object).obj;
            if (periodicallyServicable2.equals(periodicallyServicable)) {
                dListNode.delink();
                --this.size;
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(" [TimedTaskList: ");
        stringBuffer.append(this.size + " elements: ");
        DListNode dListNode = this.first;
        while (null != dListNode.next && null != dListNode.next.object) {
            dListNode = dListNode.next;
            stringBuffer.append((int)(((TaskData)dListNode.object).abs_execute_time / 1000L));
            stringBuffer.append(",");
        }
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }
}

