/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class NetUtils {
    private static final String LOCALHOST_IP = "127.0.0.1";
    static /* synthetic */ Class class$com$iplanet$ias$util$net$NetUtils;

    private NetUtils() {
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InetAddress[] getHostAddresses() {
        try {
            String string = NetUtils.getHostName();
            if (string == null) {
                return null;
            }
            return InetAddress.getAllByName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getHostIPs() {
        try {
            InetAddress[] inetAddressArray = NetUtils.getHostAddresses();
            if (inetAddressArray == null) {
                return null;
            }
            String[] stringArray = new String[inetAddressArray.length];
            int n = 0;
            while (n < inetAddressArray.length) {
                String string;
                stringArray[n] = string = NetUtils.trimIP(inetAddressArray[n].toString());
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String trimIP(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(++n);
        }
        return string;
    }

    public static byte[] ip2bytes(String string) {
        try {
            string = NetUtils.trimIP(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            byte[] byArray = new byte[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2);
                byArray[n] = (byte)n2;
                ++n;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isLocalHost(String string) {
        if (string == null) {
            return false;
        }
        string = NetUtils.trimIP(string);
        return string.equals(LOCALHOST_IP);
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        if (NetUtils.isLocalHost(string = NetUtils.trimIP(string))) {
            return true;
        }
        String[] stringArray = NetUtils.getHostIPs();
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isRemote(String string) {
        return !NetUtils.isLocal(string);
    }

    public static boolean isPortFree(int n) {
        if (n <= 0 || n > 65535) {
            return false;
        }
        try {
            Socket socket = new Socket(NetUtils.getHostName(), n);
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            outputStream.close();
            outputStream = null;
            inputStream.close();
            inputStream = null;
            socket.close();
            socket = null;
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        int n = 0;
        boolean bl = false;
        ServerSocket serverSocket = null;
        Class clazz = class$com$iplanet$ias$util$net$NetUtils == null ? (class$com$iplanet$ias$util$net$NetUtils = NetUtils.class$("com.iplanet.ias.util.net.NetUtils")) : class$com$iplanet$ias$util$net$NetUtils;
        synchronized (clazz) {
            try {
                serverSocket = new ServerSocket(0);
                n = serverSocket.getLocalPort();
                bl = true;
                return bl ? 1 : 0;
            }
            catch (Exception exception) {}
            finally {
                if (!bl) {
                    n = 0;
                }
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                        if (!serverSocket.isClosed()) {
                            throw new Exception("local exception ...");
                        }
                    }
                }
                catch (Exception exception) {
                    n = 0;
                }
                return n;
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("80: " + NetUtils.isPortFree(80));
        System.out.println("777: " + NetUtils.isPortFree(777));
        System.out.println("8000: " + NetUtils.isPortFree(8000));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

