/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.io;

import com.iplanet.ias.util.io.FileUtils;
import java.io.File;

public class FileSource {
    private File fileSource = null;
    private boolean isDir = false;

    public FileSource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null File argument.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + FileUtils.safeGetCanonicalPath(file));
        }
        this.isDir = file.isDirectory();
        this.fileSource = file;
    }

    public boolean exists() {
        return this.fileSource != null && this.fileSource.exists();
    }

    public File getSource() {
        return this.fileSource;
    }

    public File getFile() {
        return this.fileSource;
    }

    public boolean isArchive() {
        return !this.isDir;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isDir() {
        return this.isDirectory();
    }

    public String toString() {
        if (this.fileSource == null) {
            return "null FileSource";
        }
        return FileUtils.safeGetCanonicalPath(this.fileSource);
    }
}

