/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.iplanet.ias.util.diagnostics.CallerInfo;
import com.iplanet.ias.util.diagnostics.CallerInfoException;

public class Assertion {
    private static boolean doCheck = true;
    private static Assertion staticInstance = null;

    public static void check(boolean bl, String string) {
        if (doCheck && !bl) {
            Assertion.toss(string);
        }
    }

    public static void check(boolean bl) {
        if (doCheck && !bl) {
            Assertion.toss();
        }
    }

    public static void check(Object object, String string) {
        if (doCheck && object == null) {
            Assertion.toss(string);
        }
    }

    public static void check(String string, String string2) {
        if (doCheck && (string == null || string.length() <= 0)) {
            Assertion.toss(string2);
        }
    }

    public static void check(String string) {
        if (doCheck && (string == null || string.length() <= 0)) {
            Assertion.toss();
        }
    }

    public static void check(Object object) {
        if (doCheck && object == null) {
            Assertion.toss();
        }
    }

    public static void check(double d, String string) {
        if (doCheck && d == 0.0) {
            Assertion.toss(string);
        }
    }

    public static void check(double d) {
        if (doCheck && d == 0.0) {
            Assertion.toss();
        }
    }

    public static void check(long l, String string) {
        if (doCheck && l == 0L) {
            Assertion.toss(string);
        }
    }

    public static void check(long l) {
        if (doCheck && l == 0L) {
            Assertion.toss();
        }
    }

    public static void setCheck(boolean bl) {
        doCheck = bl;
    }

    public static void main(String[] stringArray) {
        Assertion.check(stringArray);
        Assertion.check(stringArray.length, "No command line arguments");
    }

    private static void toss() {
        Assertion.toss(null);
    }

    private static void toss(String string) {
        String string2 = "\nAssertion failed";
        String string3 = Assertion.getCallerInfo();
        if (string3 != null) {
            string2 = string2 + " at " + string3;
        }
        if (string != null) {
            string2 = string2 + " --> " + string;
        }
        throw new Failure(string2);
    }

    private static String getCallerInfo() {
        try {
            CallerInfo callerInfo = new CallerInfo(new Object[]{staticInstance});
            return callerInfo.toString();
        }
        catch (CallerInfoException callerInfoException) {
            return null;
        }
    }

    static {
        staticInstance = new Assertion();
    }

    public static class Failure
    extends RuntimeException {
        public Failure(String string) {
            super(string);
        }
    }
}

