/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.license;

import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseManager;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.logging.IASLevel;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.logging.LogDomains;
import java.text.DateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LicenseLifecycle
extends ServerLifecycleImpl {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager sm = StringManager.getManager(class$com$iplanet$ias$license$LicenseLifecycle == null ? (class$com$iplanet$ias$license$LicenseLifecycle = LicenseLifecycle.class$("com.iplanet.ias.license.LicenseLifecycle")) : class$com$iplanet$ias$license$LicenseLifecycle);
    private static final String STARS = "******************************************************************\n";
    private static final String STARS2 = "*****  ";
    private static final String STARS3 = "  *****";
    private static final int BEFOREEXPIREDAYS = 14;
    static /* synthetic */ Class class$com$iplanet$ias$license$LicenseLifecycle;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        LicenseBase licenseBase = null;
        int n = 0;
        try {
            licenseBase = LicenseManager.getLicense();
        }
        catch (Exception exception) {
            _logger.log((Level)IASLevel.FATAL, "core.invalid_license_error");
            String string = sm.getString("license.e_no_valid_license");
            throw new ServerLifecycleException(string);
        }
        try {
            IASLicense.checkCurrent(true);
            n = licenseBase.checkValidity();
            if (n <= 14) {
                _logger.log(Level.WARNING, "core.license_expiring", String.valueOf(n));
            }
        }
        catch (Exception exception) {
            _logger.log((Level)IASLevel.FATAL, "core.license_expired");
            String string = sm.getString("license.e_license_expired");
            throw new ServerLifecycleException(string);
        }
    }

    public void onTermination() throws ServerLifecycleException {
    }

    public String displayText(LicenseBase licenseBase) {
        String string = null;
        String string2 = null;
        String string3 = licenseBase.getProperty("ias.license_type");
        if (string3.equals("Dev")) {
            string = "Developer";
            string2 = "development";
        }
        if (string3.equals("Eval")) {
            string = "Evaluation";
            string2 = "evaluation";
        }
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        String string4 = dateFormat.format(licenseBase.getExpirationDate());
        String string5 = string + " license enabled. This license will expire on";
        String string6 = string4 + "." + "This license is for " + string2 + " purposes ";
        String string7 = "only. You are in violation of the license agreement if ";
        String string8 = "you use this productin a production environment.";
        String string9 = "******************************************************************\n******************************************************************\n*****  " + string5 + "\n";
        string9 = string9 + STARS2 + string6 + "\n";
        string9 = string9 + STARS2 + string7 + "\n";
        string9 = string9 + STARS2 + string8 + "\n" + STARS + STARS;
        return string9;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

