/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InstanceDefinition {
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_JMS_PORT = 7676;
    public static final String DEFAULT_JMS_USER = "admin";
    public static final String DEFAULT_JMS_PW = "admin";
    public static final String SPACE = " ";
    public static final String WINDOWS_BIN_EXT = ".exe";
    public static final String BIN_DIR_NAME = "bin";
    public static final String LIB_DIR_NAME = "lib";
    private String mJavaHome = System.getProperty("java.home");
    private String mImqHome = null;
    private String mServerName = null;
    private int mHttpPort = 80;
    private String mIdentifier = null;
    private String mMailHost = null;
    private String mUser = null;
    private String mDocRoot = null;
    private String mPortString = null;
    private int mJMSPort = 7676;
    private String mJMSPortString = null;
    private String mJMSUser = null;
    private String mJMSPasswd = null;
    public static final String UNIX_START_COMMAND_NAME = "startserv";
    public static final String UNIX_STOP_COMMAND_NAME = "stopserv";
    public static final String UNIX_GETTOKENS_COMMAND_NAME = "gettokens";
    public static final String UNIX_RESTART_COMMAND_NAME = "restartserv";
    public static final String WIN_START_COMMAND_NAME = "startsec.exe";
    public static final String WIN_STOP_COMMAND_NAME = "stopserv.bat";
    public static final String WIN_GETTOKENS_COMMAND_NAME = "gettokens.exe";
    public final String JMS_NODE_PATH = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.JMS_SERVICE;

    public InstanceDefinition(String string, int n, String string2, String string3, String string4, String string5, int n2, String string6, String string7) {
        this.initialize(string, n, string2, string3, string4, string5, n2, string6, string7);
    }

    public InstanceDefinition(String string, int n) {
        if (string == null || n <= 0) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.ILLEGAL_PORT));
        }
        String string2 = this.createLocalHostName();
        String string3 = this.createLocalHostName();
        String string4 = System.getProperty("user.name");
        String string5 = ServerManager.INSTANCE_CFG_ROOT + "/" + string + "/" + "docroot";
        this.initialize(string2, n, string, string3, string4, string5, 7676, "admin", "admin");
    }

    private void initialize(String string, int n, String string2, String string3, String string4, String string5, int n2, String string6, String string7) {
        if (string == null || string2 == null || string3 == null || string4 == null || string4 == null || string5 == null || string6 == null || string7 == null) {
            throw new IllegalArgumentException();
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.mServerName = string;
        this.mHttpPort = n;
        this.mIdentifier = string2;
        this.mMailHost = string3;
        this.mUser = string4;
        this.mDocRoot = string5;
        this.mPortString = "" + this.mHttpPort;
        this.mJMSPort = n2;
        this.mJMSPortString = n2 + "";
        this.mJMSUser = string6;
        this.mJMSPasswd = string7;
    }

    public String getID() {
        return this.mIdentifier;
    }

    public int getPort() {
        return this.mHttpPort;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public String getAdminJavaHome() throws ConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment("admin-server");
        String string = instanceEnvironment.getBackupConfigFilePath();
        ConfigContext configContext = ConfigFactory.createConfigContext(string);
        ConfigBean configBean = ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        this.mJavaHome = configBean.getAttributeValue(ServerTags.JAVA_HOME);
        return this.mJavaHome;
    }

    public String getDocRoot() {
        return this.mDocRoot;
    }

    private String createLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public String[] getStartCommand() {
        String[] stringArray = null;
        stringArray = OS.isWindows() ? this.getCompleteWindowsStartCommand() : this.getCompleteNonWindowsStartCommand();
        return stringArray;
    }

    private String[] getCompleteWindowsStartCommand() {
        String[] stringArray = new String[]{System.getProperty("com.sun.aas.installRoot"), BIN_DIR_NAME, WIN_START_COMMAND_NAME};
        String string = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        return new String[]{string, this.mIdentifier, System.getProperty("com.sun.aas.instanceRoot")};
    }

    private String[] getCompleteNonWindowsStartCommand() {
        String[] stringArray = new String[]{System.getProperty("com.sun.aas.instanceRoot"), this.mIdentifier, BIN_DIR_NAME, UNIX_START_COMMAND_NAME};
        String string = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        return new String[]{string};
    }

    public String[] getGetSecurityTokensCommand() {
        String[] stringArray = null;
        String string = null;
        string = OS.isWindows() ? this.getWindowsSecTokensCommand() : this.getNonWindowsSecTokensCommand();
        stringArray = new String[]{string, this.mIdentifier, System.getProperty("com.sun.aas.instanceRoot")};
        return stringArray;
    }

    private String getWindowsSecTokensCommand() {
        String[] stringArray = new String[]{System.getProperty("com.sun.aas.installRoot"), BIN_DIR_NAME, WIN_GETTOKENS_COMMAND_NAME};
        return StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private String getNonWindowsSecTokensCommand() {
        String[] stringArray = new String[]{System.getProperty("com.sun.aas.installRoot"), LIB_DIR_NAME, UNIX_GETTOKENS_COMMAND_NAME};
        return StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String[] getStopCommand() {
        String[] stringArray = new String[1];
        String string = null;
        string = OS.isWindows() ? WIN_STOP_COMMAND_NAME : UNIX_STOP_COMMAND_NAME;
        String[] stringArray2 = new String[]{System.getProperty("com.sun.aas.instanceRoot"), this.mIdentifier, BIN_DIR_NAME, string};
        stringArray[0] = StringUtils.makeFilePath((String[])stringArray2, (boolean)false);
        return stringArray;
    }

    public String[] getRestartCommand() {
        if (OS.isWindows()) {
            throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.ILLEGAL_RESTART));
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[]{System.getProperty("com.sun.aas.instanceRoot"), this.mIdentifier, BIN_DIR_NAME, UNIX_RESTART_COMMAND_NAME};
        stringArray[0] = StringUtils.makeFilePath((String[])stringArray2, (boolean)false);
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mServerName);
        stringBuffer.append(SPACE + this.mPortString);
        stringBuffer.append(SPACE + this.mIdentifier);
        stringBuffer.append(SPACE + this.mMailHost);
        stringBuffer.append(SPACE + this.mUser);
        stringBuffer.append(SPACE + this.mDocRoot);
        return stringBuffer.toString();
    }

    public void setUser(String string) {
        if (string != null && string.length() > 0) {
            this.mUser = string;
        }
    }

    public String getUser() {
        return this.mUser;
    }
}

