/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationEnvironment {
    private String mAppName = null;
    private String mAppPath = null;
    private String mAppStubPath = null;
    private String mAppBackupPath = null;
    private String mAppJSPPath = null;
    private InstanceEnvironment mInstance = null;
    private static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$instance$ApplicationEnvironment;

    public ApplicationEnvironment(InstanceEnvironment instanceEnvironment, String string) {
        if (instanceEnvironment == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.mInstance = instanceEnvironment;
        this.mAppName = string;
        this.createAppPath();
        this.createAppStubPath();
        this.createAppBackupPath();
        this.createAppJSPPath();
    }

    private void createAppPath() {
        String string = this.mInstance.getApplicationRepositoryPath();
        String[] stringArray = new String[]{string, this.mAppName};
        this.mAppPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createAppBackupPath() {
        String string = this.mInstance.getApplicationBackupRepositoryPath();
        String[] stringArray = new String[]{string, this.mAppName};
        this.mAppBackupPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getAppPath() {
        return this.mAppPath;
    }

    public String getAppBackupPath() {
        return this.mAppBackupPath;
    }

    public void createAppStubPath() {
        String[] stringArray = new String[]{this.mInstance.getApplicationStubPath(), this.mAppName};
        this.mAppStubPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public void createAppJSPPath() {
        String[] stringArray = new String[]{this.mInstance.getApplicationCompileJspPath(), this.mAppName};
        this.mAppJSPPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getAppJSPPath() {
        if (!$assertionsDisabled && !StringUtils.ok((String)this.mAppJSPPath)) {
            throw new AssertionError();
        }
        return this.mAppJSPPath;
    }

    public String getAppStubPath() {
        return this.mAppStubPath;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public static void main(String[] stringArray) {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment("foo");
        ApplicationEnvironment applicationEnvironment = new ApplicationEnvironment(instanceEnvironment, "myapp");
        _logger.log(Level.INFO, "core.appenv_dump");
        _logger.log(Level.INFO, applicationEnvironment.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$instance$ApplicationEnvironment == null ? (class$com$iplanet$ias$instance$ApplicationEnvironment = ApplicationEnvironment.class$("com.iplanet.ias.instance.ApplicationEnvironment")) : class$com$iplanet$ias$instance$ApplicationEnvironment).desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

