/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.core;

import com.iplanet.ias.admin.common.domains.registry.ContactData;
import com.iplanet.ias.admin.common.domains.registry.ContactDataSet;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.installer.core.ServerConfig;
import com.iplanet.ias.installer.utilities.IORoutines;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class installConfig {
    public static final String CONFIG_STORE_FILE = "domains.bin";
    public static final String WIN_OS = "Windows";
    public static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    public static boolean invokedFromInstaller = false;
    private static boolean initialized = false;
    private static String sroot = null;

    public installConfig() {
        if (!initialized && !invokedFromInstaller) {
            System.loadLibrary("installCore");
            initialized = true;
        }
    }

    public String createServerInstance(ServerConfig serverConfig) {
        if (serverConfig.serverID == null || serverConfig.serverPort < 0 || serverConfig.serverName == null) {
            throw new IllegalArgumentException();
        }
        String string = serverConfig.mailHost != null ? serverConfig.mailHost : serverConfig.serverName;
        sroot = serverConfig.serverRoot;
        return this.CreateSvrInstance(serverConfig.defaultLocale, serverConfig.icuLib, serverConfig.webServicesLib, serverConfig.perlRoot, serverConfig.serverID, "" + serverConfig.serverPort, serverConfig.serverRoot, serverConfig.domainRoot, serverConfig.serverUser, serverConfig.serverName, serverConfig.domainName, string, serverConfig.docRoot, "" + serverConfig.jmsPort, serverConfig.jmsUser, serverConfig.jmsPasswd, serverConfig.imqBin, serverConfig.imqLib, serverConfig.javaHome, "" + serverConfig.orbListenerPort, serverConfig.configRoot);
    }

    public String createAdminInstance(ServerConfig serverConfig) {
        sroot = serverConfig.serverRoot;
        return this.CreateAdmInstance(serverConfig.defaultLocale, serverConfig.icuLib, serverConfig.webServicesLib, serverConfig.perlRoot, serverConfig.serverRoot, serverConfig.serverName, serverConfig.domainName, serverConfig.domainRoot, "" + serverConfig.serverPort, serverConfig.serverUser, serverConfig.adminName, serverConfig.adminPasswd, serverConfig.docRoot, serverConfig.ldapURL, serverConfig.ldapUser, serverConfig.ldapPasswd, serverConfig.ldapDN, serverConfig.jmsUser, serverConfig.jmsPasswd, "" + serverConfig.jmsPort, serverConfig.imqBin, serverConfig.imqLib, serverConfig.javaHome, "" + serverConfig.orbListenerPort, serverConfig.configRoot, serverConfig.install);
    }

    public String createDomain(ServerConfig serverConfig) throws DomainRegistryException {
        String string = null;
        File file = new File(serverConfig.configRoot + File.separator + CONFIG_STORE_FILE);
        System.setProperty("com.sun.aas.configRoot", serverConfig.configRoot);
        string = this.createDomainRegistry(file, serverConfig.serverRoot);
        if (string != null) {
            return string;
        }
        DomainRegistry domainRegistry = DomainRegistry.newInstance();
        boolean bl = false;
        ContactData contactData = new ContactData(serverConfig.serverName, "" + serverConfig.serverPort, bl);
        ContactDataSet contactDataSet = new ContactDataSet();
        contactDataSet.add((Object)contactData);
        DomainEntry domainEntry = new DomainEntry(serverConfig.domainName, new File(serverConfig.domainRoot), contactDataSet);
        domainRegistry.registerDomain(domainEntry);
        sroot = serverConfig.serverRoot;
        string = this.createAdminInstance(serverConfig);
        if (string != null) {
            domainRegistry.unregisterDomain(domainEntry);
        }
        return string;
    }

    public String createDomainRegistry(File file, String string) {
        String string2 = null;
        if (file.exists()) {
            return string2;
        }
        return this.CreateConfigStore(file.getParent(), string);
    }

    public void deleteServerInstance(String string, String string2) throws FileNotFoundException, DomainRegistryException, IOException {
        DomainRegistry domainRegistry = DomainRegistry.newInstance();
        File file = null;
        Iterator iterator = domainRegistry.iterator();
        block0: while (iterator.hasNext()) {
            File[] fileArray;
            DomainEntry domainEntry = (DomainEntry)iterator.next();
            if (!domainEntry.getName().equals(string2) || (fileArray = (file = domainEntry.getRoot()).listFiles()) == null) continue;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory() && fileArray[n].getPath().endsWith(string)) {
                    IORoutines.deleteDirectory((File)fileArray[n]);
                    continue block0;
                }
                ++n;
            }
        }
        if (this.isWindows()) {
            this.uninstallServerInstance(string, string2);
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").indexOf(WIN_OS) != -1;
    }

    public void deleteDomain(String string) throws FileNotFoundException, DomainRegistryException, IOException {
        File file = null;
        DomainRegistry domainRegistry = DomainRegistry.newInstance();
        Iterator iterator = domainRegistry.iterator();
        while (iterator.hasNext()) {
            DomainEntry domainEntry = (DomainEntry)iterator.next();
            if (!domainEntry.getName().equals(string)) continue;
            file = domainEntry.getRoot();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isDirectory()) {
                        if (this.isWindows()) {
                            this.uninstallServerInstance(fileArray[n].getName(), string);
                        }
                        IORoutines.deleteDirectory((File)fileArray[n]);
                    }
                    ++n;
                }
            }
            domainRegistry.unregisterDomain(string);
            IORoutines.deleteDirectory((File)file);
        }
    }

    public int deleteAllDomains(String string) throws FileNotFoundException, DomainRegistryException, IOException {
        File file = null;
        File file2 = new File(string);
        System.setProperty("com.sun.aas.configRoot", string);
        DomainRegistry domainRegistry = DomainRegistry.newInstance();
        Iterator iterator = domainRegistry.iterator();
        while (iterator.hasNext()) {
            DomainEntry domainEntry = (DomainEntry)iterator.next();
            file = domainEntry.getRoot();
            IORoutines.deleteDirectory((File)file);
            domainRegistry.unregisterDomain(domainEntry);
        }
        if (this.isWindows()) {
            return this.uninstallServers();
        }
        return 0;
    }

    public int uninstallServers() {
        int n = this.UninstallServers();
        return n;
    }

    public int uninstallServerInstance(String string, String string2) {
        int n = this.UninstallServerInstance(string, string2);
        return n;
    }

    public int installSNMP(String string) {
        int n = this.SNMPInstall(string);
        return n;
    }

    public int uninstallSNMP() {
        int n = this.SNMPUninstall();
        return n;
    }

    public String chownFile(String string, String string2) {
        if (sroot == null) {
            sroot = System.getProperty(INSTALL_ROOT);
        }
        return this.ChownFile(string, string2, sroot);
    }

    public String chownDir(String string, String string2) {
        if (sroot == null) {
            sroot = System.getProperty(INSTALL_ROOT);
        }
        return this.ChownDir(string, string2, sroot);
    }

    private native String ChownDir(String var1, String var2, String var3);

    private native String ChownFile(String var1, String var2, String var3);

    private native String CreateSvrInstance(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, String var17, String var18, String var19, String var20, String var21);

    private native String CreateAdmInstance(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, String var17, String var18, String var19, String var20, String var21, String var22, String var23, String var24, String var25, boolean var26);

    private native String CreateConfigStore(String var1, String var2);

    private native int UninstallServers();

    private native int UninstallServerInstance(String var1, String var2);

    private native int SNMPInstall(String var1);

    private native int SNMPUninstall();
}

