/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.JavaCompilerException;
import com.iplanet.ias.ejb.codegen.ProcessExecutor;
import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import com.iplanet.ias.instance.UniqueIdGenerator;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Compiler {
    protected File jdkDir = null;
    protected String installRoot = null;
    protected List options;
    protected List files;
    protected File fileOfFilenames = null;
    protected boolean useFileContainingFilenames = false;
    protected static final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    protected static final StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$ejb$codegen$JavaCompiler == null ? (class$com$iplanet$ias$ejb$codegen$JavaCompiler = Compiler.class$("com.iplanet.ias.ejb.codegen.JavaCompiler")) : class$com$iplanet$ias$ejb$codegen$JavaCompiler);
    protected static final String hostUniqueStr = Integer.toString(new Object().hashCode(), 16) + "_";
    static /* synthetic */ Class class$com$iplanet$ias$ejb$codegen$JavaCompiler;

    Compiler(List list, List list2) throws JavaCompilerException {
        if (list == null || list.size() <= 0) {
            throw new JavaCompilerException("java_compiler.badargs", "JavaCompiler given null or empty {0} list", new Object[]{"options"});
        }
        if (list2 == null || list2.size() <= 0) {
            throw new JavaCompilerException("java_compiler.badargs", "JavaCompiler given null or empty {0} list", new Object[]{"file"});
        }
        this.options = list;
        this.files = list2;
        this.init();
    }

    final void compile() throws JavaCompilerException {
        try {
            this.internal_compile();
        }
        catch (JavaCompilerException javaCompilerException) {
            throw javaCompilerException;
        }
        catch (Throwable throwable) {
            throw new JavaCompilerException(throwable);
        }
        finally {
            if (this.fileOfFilenames != null && !this.fileOfFilenames.delete()) {
                this.fileOfFilenames.deleteOnExit();
            }
        }
    }

    protected abstract void internal_compile() throws JavaCompilerException, ProcessExecutorException;

    protected abstract void internal_init();

    final void init() {
        this.installRoot = System.getProperty("com.sun.aas.installRoot");
        this.initJDKDir();
        logger.log(Level.FINE, "JDK Directory: " + (this.jdkDir == null ? "null" : this.jdkDir.getPath()));
        String string = System.getProperty("com.sun.aas.deployment.javac.file.enable");
        this.useFileContainingFilenames = string != null ? Boolean.valueOf(string) : OS.isWindows();
        this.internal_init();
    }

    final void initJDKDir() {
        String string = System.getProperty("JAVA_HOME");
        if (StringUtils.ok((String)string)) {
            this.jdkDir = new File(string);
            if (FileUtils.safeIsDirectory(this.jdkDir)) {
                this.jdkDir = FileUtils.safeGetCanonicalFile(this.jdkDir);
                return;
            }
        }
        this.jdkDir = null;
        if (this.installRoot != null) {
            this.jdkDir = new File(this.installRoot + "/jdk");
            if (FileUtils.safeIsDirectory(this.jdkDir)) {
                this.jdkDir = FileUtils.safeGetCanonicalFile(this.jdkDir);
                return;
            }
        }
        this.jdkDir = null;
    }

    protected void runProcess(String[] stringArray, long l) throws ProcessExecutorException {
        ProcessExecutor processExecutor = new ProcessExecutor(stringArray, l);
        processExecutor.execute();
    }

    protected void logCompilerName(String string) {
        logger.log(Level.FINE, "[EJBC] Successfully compiled with " + string);
    }

    protected static String getSystemPropertyIgnoreCase(String string) {
        Properties properties = System.getProperties();
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (string.compareToIgnoreCase(string2) != 0) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    protected void addJavaFiles(List list) {
        if (!this.useFileContainingFilenames) {
            list.addAll(this.files);
            return;
        }
        this.writeFileOfFilenames();
        if (this.fileOfFilenames == null) {
            list.addAll(this.files);
            return;
        }
        list.add("@" + FileUtils.safeGetCanonicalPath(this.fileOfFilenames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeFileOfFilenames() {
        block12: {
            this.fileOfFilenames = null;
            BufferedWriter bufferedWriter = null;
            this.fileOfFilenames = File.createTempFile(hostUniqueStr + Long.toString(UniqueIdGenerator.getInstance().getNextUniqueId(), 16) + "_", ".s1a");
            bufferedWriter = new BufferedWriter(new FileWriter(this.fileOfFilenames));
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                bufferedWriter.newLine();
            }
            Object var4_4 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    this.fileOfFilenames = null;
                    Object var4_5 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected static int getTimeout(String string, int n, int n2, int n3) {
        int n4 = n;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n4 = n;
            }
        }
        if (n4 < n2 || n4 > n3) {
            n4 = n;
        }
        return n4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

