/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.tcp;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ServerChannel;
import com.iplanet.ias.cis.channel.tcp.NoPendingConnectionsException;
import com.iplanet.ias.cis.channel.tcp.TCPNativeException;
import com.iplanet.ias.cis.channel.tcp.TCPNonBlockingChannel;
import com.iplanet.ias.cis.connection.EndPoint;

public class TCPNonBlockingServerChannel
implements ServerChannel {
    private int fd;
    protected EndPoint local = null;
    private int sPort;

    public TCPNonBlockingServerChannel(EndPoint endPoint, int n) throws ChannelException {
        this.local = endPoint;
        this.createTCPChannel(n);
    }

    public TCPNonBlockingServerChannel(EndPoint endPoint) throws ChannelException {
        this(endPoint, 50);
    }

    public Channel accept(long l) throws ChannelException {
        try {
            TCPNonBlockingChannel tCPNonBlockingChannel = new TCPNonBlockingChannel();
            this.doAccept(tCPNonBlockingChannel, l);
            return tCPNonBlockingChannel;
        }
        catch (NoPendingConnectionsException noPendingConnectionsException) {
            return null;
        }
        catch (ChannelException channelException) {
            return null;
        }
    }

    public Channel accept() throws ChannelException {
        try {
            TCPNonBlockingChannel tCPNonBlockingChannel = new TCPNonBlockingChannel();
            this.doAccept(tCPNonBlockingChannel, -1L);
            return tCPNonBlockingChannel;
        }
        catch (NoPendingConnectionsException noPendingConnectionsException) {
            return null;
        }
        catch (ChannelException channelException) {
            return null;
        }
    }

    public EndPoint getEndPoint() throws ChannelException {
        if (this.local == null) {
            throw new ChannelException("EndPoint in the server channel is null");
        }
        return this.local;
    }

    public void close() throws ChannelException {
        this.doClose();
        this.fd = 0;
    }

    private void doAccept(TCPNonBlockingChannel tCPNonBlockingChannel, long l) throws ChannelException {
        this.acceptNative(tCPNonBlockingChannel, l);
    }

    private void doClose() throws ChannelException {
        this.closeNative();
    }

    private void createTCPChannel(int n) throws ChannelException {
        String string = this.local.getHostIP();
        int n2 = this.local.getPort();
        boolean bl = this.local.isIPv6();
        this.createTCPChannelNative(string, n2, bl, n);
        if (n2 == 0) {
            this.local.updatePort(this.sPort);
        }
    }

    private native void createTCPChannelNative(String var1, int var2, boolean var3, int var4) throws TCPNativeException;

    private native void acceptNative(TCPNonBlockingChannel var1, long var2) throws TCPNativeException;

    private native void closeNative() throws TCPNativeException;

    private static native void initNative();

    static {
        System.loadLibrary("cis");
        TCPNonBlockingServerChannel.initNative();
    }
}

