/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.MailResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailResourceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Resources resources = server.getResources();
            MailResource[] mailResourceArray = resources.getMailResource();
            int n = 0;
            while (n < mailResourceArray.length) {
                String string = mailResourceArray[n].getHost();
                if (string != null && string.equals("")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullResource", "Mail Resource Host Cannot be null String"));
                }
                try {
                    InetAddress.getByName(string).getHostName();
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "Valid IIOP Listener IP " + string, new Object[]{string}));
                }
                catch (UnknownHostException unknownHostException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHost", "Host name not resolvable - " + string, new Object[]{string}));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            return this.testSave(string2, (String)object);
        }
        MailResource mailResource = (MailResource)object;
        String string3 = mailResource.getHost();
        String string4 = mailResource.getJndiName();
        if (!StaticTest.checkObjectName(string4, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidName", "Mail Resource Jndi-Name Invalid"));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        try {
            InetAddress.getByName(string3).getHostName();
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIP", "Valid Mail Resource IP"));
        }
        catch (UnknownHostException unknownHostException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHost", "Host name not resolvable - " + string3, new Object[]{string3}));
            return result;
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result;
        block2: {
            result = new Result();
            result.passed("Passed **");
            if (!string.equals(ServerTags.HOST)) break block2;
            try {
                InetAddress.getByName(string2).getHostName();
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIP", "Valid Mail Resource IP"));
            }
            catch (UnknownHostException unknownHostException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHost", "Host name not resolvable - " + string2, new Object[]{string2}));
            }
        }
        return result;
    }
}

