/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.meta;

import com.iplanet.ias.admin.server.core.jmx.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfoBuilder {
    public static final String kSetterPrefix = "set";
    public static final String kGetterPrefix = "get";
    private Class mClass = null;
    private MBeanOperationInfo[] mOperations = null;
    private MBeanAttributeInfo[] mAttributes = null;
    private MBeanConstructorInfo[] mConstructors = null;
    private MBeanNotificationInfo[] mNotifications = null;
    private MBeanInfo mMBeanInfo = null;

    public MBeanInfoBuilder(Class clazz) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.mClass = clazz;
        this.createOperations();
        this.createConstructors();
        this.createAttributes();
        this.createMBeanInfo();
        this.createNotifications();
    }

    public MBeanInfoBuilder(String string) {
    }

    public MBeanInfoBuilder(String string, ClassLoader classLoader) {
    }

    public MBeanOperationInfo[] getMBeanOperations() {
        return this.mOperations;
    }

    public MBeanConstructorInfo[] getMBeanConstructors() {
        return this.mConstructors;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    public MBeanAttributeInfo[] getMBeanAttributes() {
        return this.mAttributes;
    }

    private void createOperations() {
        Vector<String> vector = new Vector<String>();
        vector.add("java.lang.Object");
        vector.add("com.iplanet.ias.admin.server.core.mbean.config.AdminBase");
        Introspector introspector = new Introspector(this.mClass);
        Method[] methodArray = introspector.getCallableInstanceMethods(vector);
        Vector<MBeanOperationInfo> vector2 = new Vector<MBeanOperationInfo>();
        int n = 0;
        while (n < methodArray.length) {
            String string = methodArray[n].getName();
            boolean bl = string.startsWith(kGetterPrefix);
            boolean bl2 = string.startsWith(kSetterPrefix);
            if (!bl && !bl2) {
                vector2.add(new MBeanOperationInfo(string, methodArray[n]));
            }
            ++n;
        }
        this.mOperations = new MBeanOperationInfo[vector2.size()];
        vector2.toArray(this.mOperations);
    }

    private void createConstructors() {
        Constructor<?>[] constructorArray = this.mClass.getConstructors();
        this.mConstructors = new MBeanConstructorInfo[constructorArray.length];
        int n = 0;
        while (n < constructorArray.length) {
            MBeanConstructorInfo mBeanConstructorInfo;
            String string = constructorArray[n].getName();
            this.mConstructors[n] = mBeanConstructorInfo = new MBeanConstructorInfo(string, constructorArray[n]);
            ++n;
        }
    }

    private void createNotifications() {
    }

    private void createMBeanInfo() {
        this.mMBeanInfo = new MBeanInfo(this.mClass.getName(), this.mClass.getName(), this.mAttributes, this.mConstructors, this.mOperations, this.mNotifications);
    }

    private void createAttributes() throws IntrospectionException {
        Vector<MBeanAttributeInfo> vector = new Vector<MBeanAttributeInfo>();
        Method[] methodArray = new Introspector(this.mClass).getDeclaredConcretePublicMethods();
        Method[] methodArray2 = this.getGetters(methodArray);
        Method[] methodArray3 = this.getSetters(methodArray);
        int n = 0;
        while (n < methodArray2.length) {
            MBeanAttributeInfo mBeanAttributeInfo = null;
            String string = methodArray2[n].getName();
            String string2 = this.getAttributeNameFromGetter(string);
            Method method = this.findAttrIn(string2, methodArray2);
            Method method2 = this.findAttrIn(string2, methodArray3);
            boolean bl = method != null;
            boolean bl2 = method2 != null;
            boolean bl3 = false;
            mBeanAttributeInfo = new MBeanAttributeInfo(string2, null, string2, bl, bl2, bl3);
            vector.add(mBeanAttributeInfo);
            ++n;
        }
        this.mAttributes = new MBeanAttributeInfo[vector.size()];
        vector.toArray(this.mAttributes);
    }

    private Method[] getGetters(Method[] methodArray) {
        Object object;
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            object = methodArray[n].getName();
            if (((String)object).startsWith(kGetterPrefix)) {
                vector.add(methodArray[n]);
            }
            ++n;
        }
        object = new Method[vector.size()];
        return vector.toArray((T[])object);
    }

    private Method[] getSetters(Method[] methodArray) {
        Object object;
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            object = methodArray[n].getName();
            if (((String)object).startsWith(kSetterPrefix)) {
                vector.add(methodArray[n]);
            }
            ++n;
        }
        object = new Method[vector.size()];
        return vector.toArray((T[])object);
    }

    private String getAttributeNameFromGetter(String string) {
        int n = string.indexOf(kGetterPrefix);
        int n2 = n + kGetterPrefix.length();
        return string.substring(n2);
    }

    private Method findAttrIn(String string, Method[] methodArray) {
        Method method = null;
        boolean bl = false;
        int n = 0;
        while (n < methodArray.length) {
            String string2 = methodArray[n].getName();
            if (string2.endsWith(string)) {
                method = methodArray[n];
                break;
            }
            ++n;
        }
        return method;
    }
}

