/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.InitConfFileBean;
import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.SslBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.config.serverbeans.Ssl;
import com.iplanet.ias.util.i18n.StringManager;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;

public class ManagedHTTPListener
extends ConfigMBeanBase
implements ConfigAttributeName.HTTPListener {
    private static final String[][] MAPLIST = new String[][]{{"enabled", "@" + ServerTags.ENABLED}, {"id", "@" + ServerTags.ID}, {"address", "@" + ServerTags.ADDRESS}, {"port", "@" + ServerTags.PORT}, {"family", "@" + ServerTags.FAMILY}, {"acceptorThreads", "@" + ServerTags.ACCEPTOR_THREADS}, {"blockingEnabled", "@" + ServerTags.BLOCKING_ENABLED}, {"securityEnabled", "@" + ServerTags.SECURITY_ENABLED}, {"defaultVirtualServer", "@" + ServerTags.DEFAULT_VIRTUAL_SERVER}, {"serverName", "@" + ServerTags.SERVER_NAME}};
    private static final String[] ATTRIBUTES = new String[]{"enabled, boolean,      RW", "id, String,       R", "address, String,       RW", "port, int,          RW", "family, String,       RW", "acceptorThreads, int,          RW", "blockingEnabled, boolean,      RW", "securityEnabled, boolean,      RW", "defaultVirtualServer, String,       RW", "serverName, String,       RW"};
    private static final String[] OPERATIONS = new String[]{"createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled,  Boolean tlsRollbackEnabled, Boolean clientAuthEnabled), ACTION", "deleteSsl(), ACTION", "isSslCreated(), INFO"};
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator = ManagedHTTPListener.class$("com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator")) : class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$GenericConfigurator;

    public ManagedHTTPListener() throws MBeanConfigException {
        Object[] objectArray = ConfigMBeanBase.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, SslBase.MAPLIST, SslBase.ATTRIBUTES, ServerTags.SSL, null);
        this.setDescriptions((String[][])objectArray[0], (String[])objectArray[1], OPERATIONS);
    }

    public ManagedHTTPListener(String string, String string2) throws MBeanConfigException {
        this();
        this.initialize("httplistener", new String[]{string, string2});
    }

    public void setAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException {
        Object object;
        if ("enabled".equals(attribute.getName()) && ((String)(object = this.getServerInstanceName())).equals("admin-server")) {
            Boolean bl = null;
            Object object2 = attribute.getValue();
            if (object2 instanceof String) {
                bl = new Boolean((String)object2);
            } else if (object2 instanceof Boolean) {
                bl = (Boolean)object2;
            }
            if (!bl.booleanValue()) {
                throw new MBeanException(new InvalidAttributeValueException("Cannot set enabled to false for admin instance"));
            }
        }
        if (!"securityEnabled".equals(attribute.getName())) {
            super.setAttribute(attribute);
            return;
        }
        object = (HttpListener)this.getBaseConfigBean();
        boolean bl = false;
        try {
            bl = ((HttpListener)object).isSecurityEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.setAttribute(attribute);
        boolean bl2 = false;
        try {
            bl2 = ((HttpListener)object).isSecurityEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl != bl2) {
            try {
                this.setProperSecurityFlag();
            }
            catch (Exception exception) {
                throw new MBeanException((Exception)((Object)new MBeanConfigException("Failed to change security flag in init config file" + exception.getMessage())));
            }
        }
    }

    private void setProperSecurityFlag() throws Exception {
        HttpService httpService = (HttpService)this.getConfigBeanByXPath(ServerXPathHelper.getHTTPServiceXpath());
        HttpListener[] httpListenerArray = httpService.getHttpListener();
        boolean bl = false;
        int n = 0;
        while (n < httpListenerArray.length) {
            if (httpListenerArray[n].isSecurityEnabled()) {
                bl = true;
                break;
            }
            ++n;
        }
        String string = this.getServerInstanceName();
        boolean bl2 = string.equals("admin-server");
        InitConfFileBean initConfFileBean = new InitConfFileBean();
        initConfFileBean.initialise(string, !bl2);
        String string2 = initConfFileBean.get_mag_var("Security");
        boolean bl3 = string2.equalsIgnoreCase("on");
        if (bl != bl3) {
            if (bl) {
                initConfFileBean.set_mag_var("Security", "on");
            } else {
                initConfFileBean.set_mag_var("Security", "off");
            }
            initConfFileBean.dump();
        }
    }

    public boolean isSslCreated() throws ConfigException {
        HttpListener httpListener = (HttpListener)this.getConfigBeanByXPath(this.getBasePath());
        return httpListener.getSsl() != null;
    }

    public void deleteSsl() throws ConfigException {
        HttpListener httpListener = (HttpListener)this.getConfigBeanByXPath(this.getBasePath());
        httpListener.setSsl(null);
        this.getConfigContext().flush();
    }

    public void createSsl(String string, Boolean bl, String string2, Boolean bl2, String string3, Boolean bl3, Boolean bl4, Boolean bl5) throws ConfigException {
        HttpListener httpListener;
        block11: {
            httpListener = (HttpListener)this.getConfigBeanByXPath(this.getBasePath());
            try {
                if (httpListener.getSsl() != null) {
                    httpListener = null;
                    String string4 = localStrings.getString("admin.server.core.mbean.config.managedhttplistener.httplistener_has_ssl_created");
                    throw new ConfigException(string4);
                }
            }
            catch (ConfigException configException) {
                if (httpListener != null) break block11;
                throw configException;
            }
        }
        Ssl ssl = new Ssl();
        if (string != null) {
            ssl.setCertNickname(string);
        }
        if (string2 != null) {
            ssl.setSsl2Ciphers(string2);
        }
        if (string3 != null) {
            ssl.setSsl3TlsCiphers(string3);
        }
        if (bl != null) {
            ssl.setSsl2Enabled(bl);
        }
        if (bl2 != null) {
            ssl.setSsl3Enabled(bl2);
        }
        if (bl3 != null) {
            ssl.setTlsEnabled(bl3);
        }
        if (bl4 != null) {
            ssl.setTlsRollbackEnabled(bl4);
        }
        if (bl5 != null) {
            ssl.setClientAuthEnabled(bl5);
        }
        httpListener.setSsl(ssl);
        this.getConfigContext().flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

