/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.JMSDestinationInfo;
import com.iplanet.ias.admin.common.JMSObjectInfo;
import com.iplanet.ias.admin.common.JMSStatus;
import com.iplanet.ias.admin.common.constant.JMSAdminConstants;
import com.iplanet.ias.admin.common.exception.JMSAdminException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.jms.IASJmsUtil;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.JMSAdminFactory;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class JMSAdminHandler
extends ConfigMBeanBase {
    private static final String[][] MAPLIST = new String[][]{{"port", "@" + ServerTags.PORT}, {"adminUserName", "@" + ServerTags.ADMIN_USER_NAME}, {"adminPassword", "@" + ServerTags.ADMIN_PASSWORD}, {"initTimeoutInSeconds", "@" + ServerTags.INIT_TIMEOUT_IN_SECONDS}, {"startArgs", "@" + ServerTags.START_ARGS}, {"logLevel", "@" + ServerTags.LOG_LEVEL}, {"enabled", "@" + ServerTags.ENABLED}};
    private static final String[] ATTRIBUTES = new String[]{"port,int,     RW", "adminUserName,String,  RW", "adminPassword,String,  RW", "initTimeoutInSeconds,int,     RW", "startArgs,String,  RW", "logLevel,String,  RW", "enabled,boolean, RW"};
    private static final String[] OPERATIONS = null;
    private static final String RES_TYPE_TOPIC = "javax.jms.Topic";
    private static final String RES_TYPE_QUEUE = "javax.jms.Queue";
    private static final String RES_TYPE_QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String RES_TYPE_TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String FACTORY_CLASSNAME = "";

    public JMSAdminHandler() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public JMSAdminHandler(String string) throws MBeanConfigException {
        this();
        this.initialize("jms-service", new String[]{string});
    }

    public JMSStatus JMSPing() throws JMSAdminException {
        JMSAdmin jMSAdmin;
        try {
            this.JMSServiceEnabledCheck();
            jMSAdmin = this.getJMSAdmin();
            jMSAdmin.pingProvider();
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "JMSPing", exception);
            this.handleException(exception);
        }
        jMSAdmin = new JMSStatus();
        return jMSAdmin;
    }

    public JMSStatus JMSPing(String string, String string2, int n) throws JMSAdminException {
        JMSAdmin jMSAdmin;
        try {
            this.JMSServiceEnabledCheck();
            jMSAdmin = this.getJMSAdmin();
            jMSAdmin.pingProvider(string, string2, n);
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "JMSPing", exception);
            this.handleException(exception);
        }
        jMSAdmin = new JMSStatus();
        return jMSAdmin;
    }

    public void createJMSObject(String string, String string2, Properties properties) throws JMSAdminException {
        String string3 = FACTORY_CLASSNAME;
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "createJMSObject", new Object[]{string, string2, properties});
        if (!JMSAdminConstants.isValidJMSObjType((String)string2)) {
            throw new JMSAdminException("Invalid object type specified: " + string2);
        }
        if (string2.equals("topic")) {
            string3 = RES_TYPE_TOPIC;
        } else if (string2.equals("queue")) {
            string3 = RES_TYPE_QUEUE;
        } else if (string2.equals("tconfactory")) {
            string3 = RES_TYPE_TOPIC_CF;
        } else if (string2.equals("qconfactory")) {
            string3 = RES_TYPE_QUEUE_CF;
        }
        try {
            this.createJMSResource(string, string3, properties);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void deleteJMSObject(String string) throws JMSAdminException {
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "deleteJMSObject", string);
        try {
            this.deleteJMSResource(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public JMSObjectInfo[] listJMSObjects(String string) throws JMSAdminException {
        JMSObjectInfo[] jMSObjectInfoArray = null;
        Object var3_3 = null;
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "listJMSObjects", string);
        try {
            jMSObjectInfoArray = this.listJMSResources(string);
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "listJMSObjects", exception);
            this.handleException(exception);
        }
        return jMSObjectInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createJMSDestination(String string, String string2, Properties properties) throws JMSAdminException {
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "createJMSDestination", new Object[]{string, string2, properties});
        int n = 0;
        JMSAdmin jMSAdmin = null;
        boolean bl = false;
        this.JMSServiceEnabledCheck();
        jMSAdmin = this.getJMSAdmin();
        jMSAdmin.connectToProvider();
        bl = true;
        if (string2.equals("topic")) {
            n = 1;
        } else if (string2.equals("queue")) {
            n = 0;
        }
        jMSAdmin.createProviderDestination(string, n, (Map)properties);
        Object var9_7 = null;
        if (!bl) return;
        try {
            jMSAdmin.disconnectFromProvider();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return;
        {
            catch (Exception exception) {
                this.handleException(exception);
                Object var9_8 = null;
                if (!bl) return;
                try {
                    jMSAdmin.disconnectFromProvider();
                    return;
                }
                catch (Exception exception2) {
                    this.handleException(exception2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) throw throwable;
            try {
                jMSAdmin.disconnectFromProvider();
                throw throwable;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteJMSDestination(String string, String string2) throws JMSAdminException {
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "deleteJMSDestination", new Object[]{string, string2});
        int n = 0;
        JMSAdmin jMSAdmin = null;
        boolean bl = false;
        this.JMSServiceEnabledCheck();
        jMSAdmin = this.getJMSAdmin();
        jMSAdmin.connectToProvider();
        bl = true;
        if (string2.equals("topic")) {
            n = 1;
        } else if (string2.equals("queue")) {
            n = 0;
        }
        jMSAdmin.deleteProviderDestination(string, n);
        Object var8_6 = null;
        if (!bl) return;
        try {
            jMSAdmin.disconnectFromProvider();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return;
        {
            catch (Exception exception) {
                ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "deleteJMSDestination", exception);
                this.handleException(exception);
                Object var8_7 = null;
                if (!bl) return;
                try {
                    jMSAdmin.disconnectFromProvider();
                    return;
                }
                catch (Exception exception2) {
                    this.handleException(exception2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bl) throw throwable;
            try {
                jMSAdmin.disconnectFromProvider();
                throw throwable;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JMSDestinationInfo[] listJMSDestinations(String string) throws JMSAdminException {
        boolean bl;
        JMSAdmin jMSAdmin;
        JMSDestinationInfo[] jMSDestinationInfoArray;
        block10: {
            jMSDestinationInfoArray = null;
            jMSAdmin = null;
            bl = false;
            ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "listJMSDestinations", string);
            String[][] stringArray = new String[][]{null, null};
            this.JMSServiceEnabledCheck();
            jMSAdmin = this.getJMSAdmin();
            jMSAdmin.connectToProvider();
            bl = true;
            stringArray = jMSAdmin.getProviderDestinations();
            if (string == null) {
                jMSDestinationInfoArray = this.listAllDestinations(stringArray);
                break block10;
            }
            if (string.equals("topic") || string.equals("queue")) {
                jMSDestinationInfoArray = this.listDestinationsByType(string, stringArray);
                break block10;
            }
            jMSDestinationInfoArray = this.listAllDestinations(stringArray);
        }
        Object var8_6 = null;
        if (!bl) return jMSDestinationInfoArray;
        try {
            jMSAdmin.disconnectFromProvider();
            return jMSDestinationInfoArray;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return jMSDestinationInfoArray;
        {
            catch (Exception exception) {
                this.handleException(exception);
                Object var8_7 = null;
                if (!bl) return jMSDestinationInfoArray;
                try {
                    jMSAdmin.disconnectFromProvider();
                    return jMSDestinationInfoArray;
                }
                catch (Exception exception2) {
                    this.handleException(exception2);
                }
                return jMSDestinationInfoArray;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bl) throw throwable;
            try {
                jMSAdmin.disconnectFromProvider();
                throw throwable;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            throw throwable;
        }
    }

    public HostAndPort getJMSHostAndPort() throws JMSAdminException {
        HostAndPort hostAndPort = null;
        try {
            String string = this.getJMSProviderHostName();
            int n = this.getJMSProviderPort();
            hostAndPort = new HostAndPort(string, n);
        }
        catch (Exception exception) {
            throw new JMSAdminException(exception.getLocalizedMessage());
        }
        return hostAndPort;
    }

    private String getJMSProviderHostName() throws Exception {
        return "localhost";
    }

    private int getJMSProviderPort() throws Exception {
        int n = -1;
        Object object = super.getAttribute("port");
        n = (Integer)object;
        return n;
    }

    private String getJMSProviderAdminUserName() throws Exception {
        Object var1_1 = null;
        Object object = super.getAttribute("adminUserName");
        return (String)object;
    }

    private String getJMSProviderAdminPassword() throws Exception {
        Object object = super.getAttribute("adminPassword");
        return (String)object;
    }

    private void JMSServiceEnabledCheck() throws JMSAdminException {
        boolean bl;
        try {
            Object object = super.getAttribute("enabled");
            bl = (Boolean)object;
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.info("JMSAdminHandler.JMSServiceEnabledCheck: Exception caught: " + exception);
            bl = false;
        }
        if (!bl) {
            throw new JMSAdminException("Command failed - JMS Service is not enabled.");
        }
    }

    private synchronized JMSAdmin getJMSAdmin() throws Exception {
        JMSAdmin jMSAdmin = null;
        String string = this.getServerInstanceName();
        ConfigContext configContext = this.getRealConfigContext(string);
        JMSAdminFactory jMSAdminFactory = IASJmsUtil.getJMSAdminFactory();
        JmsService jmsService = (JmsService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JMS_SERVICE);
        String string2 = InetAddress.getLocalHost().getHostName();
        String string3 = jmsService.getPort();
        String string4 = jmsService.getAdminUserName();
        String string5 = jmsService.getAdminPassword();
        String string6 = string2 + (string3 == null ? FACTORY_CLASSNAME : ":" + string3);
        jMSAdmin = jMSAdminFactory.getJMSAdmin(string6, string4, string5);
        return jMSAdmin;
    }

    private JMSDestinationInfo[] listAllDestinations(String[][] stringArray) {
        Vector<JMSDestinationInfo> vector = new Vector<JMSDestinationInfo>();
        int n = 0;
        while (n < stringArray[1].length) {
            String string = stringArray[0][n];
            String string2 = stringArray[1][n].equals(new Integer(0).toString()) ? "queue" : (stringArray[1][n].equals(new Integer(1).toString()) ? "topic" : FACTORY_CLASSNAME);
            JMSDestinationInfo jMSDestinationInfo = new JMSDestinationInfo(string, string2);
            vector.addElement(jMSDestinationInfo);
            ++n;
        }
        if (vector.size() > 0) {
            Object[] objectArray = vector.toArray();
            int n2 = vector.size();
            JMSDestinationInfo[] jMSDestinationInfoArray = new JMSDestinationInfo[n2];
            int n3 = 0;
            while (n3 < n2) {
                jMSDestinationInfoArray[n3] = (JMSDestinationInfo)objectArray[n3];
                ++n3;
            }
            return jMSDestinationInfoArray;
        }
        return null;
    }

    private JMSDestinationInfo[] listDestinationsByType(String string, String[][] stringArray) {
        Vector<JMSDestinationInfo> vector = new Vector<JMSDestinationInfo>();
        String string2 = null;
        string2 = string.equals("topic") ? new Integer(1).toString() : new Integer(0).toString();
        boolean bl = false;
        int n = 0;
        while (n < stringArray[1].length) {
            if (stringArray[1][n].equals(string2)) {
                String string3 = stringArray[0][n];
                String string4 = stringArray[1][n].equals(new Integer(0).toString()) ? "queue" : (stringArray[1][n].equals(new Integer(1).toString()) ? "topic" : FACTORY_CLASSNAME);
                JMSDestinationInfo jMSDestinationInfo = new JMSDestinationInfo(string3, string4);
                vector.addElement(jMSDestinationInfo);
            }
            ++n;
        }
        if (vector.size() > 0) {
            Object[] objectArray = vector.toArray();
            int n2 = vector.size();
            JMSDestinationInfo[] jMSDestinationInfoArray = new JMSDestinationInfo[n2];
            int n3 = 0;
            while (n3 < n2) {
                jMSDestinationInfoArray[n3] = (JMSDestinationInfo)objectArray[n3];
                ++n3;
            }
            return jMSDestinationInfoArray;
        }
        return null;
    }

    private JMSObjectInfo getObjInfo(JmsResource jmsResource) throws Exception {
        Properties properties = new Properties();
        String string = jmsResource.getResType();
        String string2 = jmsResource.getJndiName();
        ElementProperty[] elementPropertyArray = jmsResource.getElementProperty();
        if (elementPropertyArray != null) {
            int n = 0;
            while (n < elementPropertyArray.length) {
                properties.setProperty(elementPropertyArray[n].getName(), elementPropertyArray[n].getValue());
                ++n;
            }
        }
        JMSObjectInfo jMSObjectInfo = new JMSObjectInfo(string2, string, properties);
        return jMSObjectInfo;
    }

    private void handleException(Exception exception) throws JMSAdminException {
        if (exception instanceof JMSAdminException) {
            throw (JMSAdminException)exception;
        }
        String string = exception.getMessage();
        JMSAdminException jMSAdminException = string == null ? new JMSAdminException() : new JMSAdminException(string);
        throw jMSAdminException;
    }

    private void createJMSResource(String string, String string2, Properties properties) throws JMSAdminException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"resourceType", (Validator)StringValidator.getInstance());
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "createJMSResource", new Object[]{string, string2, properties});
        try {
            String string3 = this.getServerInstanceName();
            ConfigContext configContext = this.getConfigContext(string3);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource jmsResource = new JmsResource();
            jmsResource.setJndiName(string);
            jmsResource.setResType(string2);
            jmsResource.setEnabled(true);
            if (properties != null && properties.size() > 0) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string4;
                    String string5 = (String)enumeration.nextElement();
                    if (string5 == null || string5.equals(FACTORY_CLASSNAME) || (string4 = properties.getProperty(string5, FACTORY_CLASSNAME)) == null) continue;
                    ElementProperty elementProperty = new ElementProperty();
                    elementProperty.setName(string5);
                    elementProperty.setValue(string4);
                    jmsResource.addElementProperty(elementProperty);
                }
            }
            resources.addJmsResource(jmsResource);
            configContext.flush();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void deleteJMSResource(String string) throws JMSAdminException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "deleteJMSResource", string);
        try {
            String string2 = this.getServerInstanceName();
            ConfigContext configContext = this.getConfigContext(string2);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource jmsResource = resources.getJmsResourceByJndiName(string);
            if (jmsResource == null) {
                throw new JMSAdminException("Delete failed - no JMS resource exists with jndi-name: " + string);
            }
            resources.removeJmsResource(jmsResource);
            configContext.flush();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void printJMSResources() {
        ConfigMBeanBase.sLogger.info("\n###START JMSAdminHandler.printJMSResources. LISTING JMS RESOURCES.");
        try {
            String string = this.getServerInstanceName();
            ConfigContext configContext = this.getConfigContext(string);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource[] jmsResourceArray = resources.getJmsResource();
            if (jmsResourceArray != null) {
                int n = 0;
                while (n < jmsResourceArray.length) {
                    ConfigMBeanBase.sLogger.info("\t###JMSAdminHandler.printJMSResources: found resource:" + jmsResourceArray[n].getJndiName());
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.info("JMSAdminHandler.printJMSResources: Caught exception: " + exception);
        }
        ConfigMBeanBase.sLogger.info("###END JMSAdminHandler.printJMSResources. LISTING JMS RESOURCES.\n");
    }

    private JMSObjectInfo[] listJMSResources(String string) {
        JMSObjectInfo[] jMSObjectInfoArray;
        Object[] objectArray;
        ConfigMBeanBase.sLogger.entering(this.getClass().getName(), "listJMSResources", string);
        Vector<JMSObjectInfo> vector = new Vector<JMSObjectInfo>();
        try {
            objectArray = this.getServerInstanceName();
            jMSObjectInfoArray = this.getConfigContext((String)objectArray);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath((ConfigContext)jMSObjectInfoArray, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource[] jmsResourceArray = resources.getJmsResource();
            if (jmsResourceArray != null) {
                String string2 = string == null || string.equals(FACTORY_CLASSNAME) ? null : (string.equals("topic") ? RES_TYPE_TOPIC : (string.equals("queue") ? RES_TYPE_QUEUE : (string.equals("tconfactory") ? RES_TYPE_TOPIC_CF : (string.equals("qconfactory") ? RES_TYPE_QUEUE_CF : null))));
                int n = 0;
                while (n < jmsResourceArray.length) {
                    JmsResource jmsResource = jmsResourceArray[n];
                    String string3 = jmsResource.getJndiName();
                    String string4 = jmsResource.getResType();
                    if (string2 == null || string2.equals(string4)) {
                        JMSObjectInfo jMSObjectInfo = this.getObjInfo(jmsResource);
                        vector.addElement(jMSObjectInfo);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "listJMSResources", exception);
        }
        if (vector.size() > 0) {
            objectArray = vector.toArray();
            int n = vector.size();
            jMSObjectInfoArray = new JMSObjectInfo[n];
            int n2 = 0;
            while (n2 < n) {
                jMSObjectInfoArray[n2] = (JMSObjectInfo)objectArray[n2];
                ++n2;
            }
            return jMSObjectInfoArray;
        }
        return null;
    }

    private ConfigContext getConfigContext(String string) throws ConfigException {
        ConfigContext configContext = super.getConfigContext();
        return configContext;
    }

    private ConfigContext getRealConfigContext(String string) throws ConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
        String string2 = instanceEnvironment.getConfigFilePath();
        ConfigContext configContext = ConfigFactory.createConfigContext(string2, false, false, false);
        return configContext;
    }
}

