/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx.storage;

import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator;
import com.iplanet.ias.admin.server.core.mbean.config.ManagedAdminServerInstance;
import com.iplanet.ias.admin.server.core.mbean.config.ManagedServerInstance;
import com.iplanet.ias.admin.server.core.mbean.config.ServerController;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class MBeanManufacturer {
    private ObjectName mObjectName = null;
    private Object mConfigBean = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$jmx$storage$MBeanManufacturer == null ? (class$com$iplanet$ias$admin$server$core$jmx$storage$MBeanManufacturer = MBeanManufacturer.class$("com.iplanet.ias.admin.server.core.jmx.storage.MBeanManufacturer")) : class$com$iplanet$ias$admin$server$core$jmx$storage$MBeanManufacturer);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$jmx$storage$MBeanManufacturer;

    public MBeanManufacturer(ObjectName objectName, Object object) {
        if (objectName == null || object == null) {
            String string = localStrings.getString("admin.server.core.jmx.storage.null_object_name_or_config_bean");
            throw new IllegalArgumentException(string);
        }
        this.mObjectName = objectName;
        this.mConfigBean = object;
    }

    public Object createMBeanInstance() {
        Object object;
        block5: {
            object = null;
            String string = ObjectNameHelper.getType((ObjectName)this.mObjectName);
            String string2 = ObjectNameHelper.getServerInstanceName((ObjectName)this.mObjectName);
            Level level = Level.SEVERE;
            try {
                if (string.equals("controller")) {
                    object = new ServerController();
                    break block5;
                }
                if (string.equals("configurator")) {
                    object = new GenericConfigurator();
                    break block5;
                }
                if (string.equals("server-instance")) {
                    object = string2.equals("admin-server") ? this.createAdminServerInstance() : this.createServerInstanceMBean(string2);
                    break block5;
                }
                level = Level.FINE;
                object = this.createGenericConfigMBean(this.mObjectName);
            }
            catch (Exception exception) {
                _logger.log(level, "mbean.config.admin.create_mbean_instance_failed", exception);
            }
        }
        return object;
    }

    private ManagedServerInstance createServerInstanceMBean(String string) throws Exception {
        Server server = (Server)this.mConfigBean;
        HttpService httpService = server.getHttpService();
        HttpListener[] httpListenerArray = httpService.getHttpListener();
        HttpListener httpListener = httpListenerArray[0];
        int n = 0;
        while (n < httpListenerArray.length) {
            if (httpListenerArray[n].isEnabled()) {
                httpListener = httpListenerArray[n];
                break;
            }
            ++n;
        }
        String string2 = httpListener.getPort();
        int n2 = Integer.parseInt(string2);
        HostAndPort hostAndPort = new HostAndPort("localhost", n2);
        return new ManagedServerInstance(string, hostAndPort, false);
    }

    private ManagedAdminServerInstance createAdminServerInstance() throws Exception {
        return new ManagedAdminServerInstance();
    }

    private Object createGenericConfigMBean(ObjectName objectName) throws MBeanConfigException {
        ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(objectName);
        return configMBeanNamingInfo.constructConfigMBean();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

