/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.event;

import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.admin.event.ApplicationDeployEvent;
import com.iplanet.ias.admin.event.BaseDeployEvent;
import com.iplanet.ias.admin.event.ConfigChangeEvent;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.event.MonitoringEvent;
import com.iplanet.ias.admin.event.ResourceDeployEvent;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.config.ConfigAdd;
import com.iplanet.ias.config.ConfigChange;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigDelete;
import com.iplanet.ias.config.ConfigSet;
import com.iplanet.ias.config.ConfigUpdate;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdminEventCache {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final transient HashMap instanceCacheMap = new HashMap();
    private String instanceName;
    private ArrayList cache;
    private boolean restartNeeded = false;
    private long tsRestartNeededSince;
    private HashMap changeEventMap;
    public static final String EJB_MON = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.EJB_CONTAINER;
    public static final String MDB_MON = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.MDB_CONTAINER;
    public static final String WEB_MON = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.WEB_CONTAINER;
    public static final String JTS_MON = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.TRANSACTION_SERVICE;
    public static final String ORB_MON = ServerXPathHelper.XPATH_ORB;
    public static final String MONITORING_ENABLED = ServerTags.MONITORING_ENABLED;
    private static final String RES_PFX = ServerXPathHelper.XPATH_RESOURCES;
    private static final String APP_PFX = ServerXPathHelper.XPATH_J2EE_APPLICATION;
    private static final String WEB_PFX = ServerXPathHelper.XPATH_WEB_MODULE;
    private static final String EJB_PFX = ServerXPathHelper.XPATH_EJB_MODULE;
    private static final String RAR_PFX = ServerXPathHelper.XPATH_CONNECTOR_MODULE;
    private static final String HTTP_SERVICE = ServerXPathHelper.XPATH_HTTP_SERVICE;
    private static final String WEB_CONTAINER = ServerXPathHelper.XPATH_SERVER + "/" + ServerTags.WEB_CONTAINER;
    private static final String PROPERTY_REGEX = "/{1,}" + ServerTags.SERVER + ".*" + "/" + "{1,}" + ServerTags.ELEMENT_PROPERTY + ".*";
    private static final String PROCESS_CHANGE = "event.process_change";
    private static final String CHANGE_NULL = "event.change_null";
    private static final String EXTRACT_CHANGE = "event.extract_change";
    private static final String CONFIG_CHANGE_XPATH = "event.config_change_xpath";
    private static final String PURGE_NOOP = "event.purge_noop";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$event$AdminEventCache == null ? (class$com$iplanet$ias$admin$event$AdminEventCache = AdminEventCache.class$("com.iplanet.ias.admin.event.AdminEventCache")) : class$com$iplanet$ias$admin$event$AdminEventCache);
    static /* synthetic */ Class class$com$iplanet$ias$admin$event$AdminEventCache;

    AdminEventCache(String string) {
        this.instanceName = string;
        this.cache = new ArrayList();
        this.changeEventMap = new HashMap();
        RMIClient rMIClient = AdminChannel.getRMIClient(string);
        if (rMIClient.isRestartNeeded()) {
            this.setRestartNeededTrue(false);
        }
    }

    public static synchronized AdminEventCache getInstance(String string) {
        AdminEventCache adminEventCache = (AdminEventCache)instanceCacheMap.get(string);
        if (adminEventCache == null) {
            adminEventCache = new AdminEventCache(string);
            instanceCacheMap.put(string, adminEventCache);
        }
        return adminEventCache;
    }

    ArrayList getCachedEvents() {
        return this.cache;
    }

    public synchronized ArrayList getAndResetCachedEvents() {
        ArrayList arrayList = this.cache;
        this.cache = new ArrayList();
        this.changeEventMap = new HashMap();
        return arrayList;
    }

    public void addEvent(AdminEvent adminEvent) {
        this.cache.add(adminEvent);
    }

    public void addEvents(ArrayList arrayList) {
        this.cache.addAll(arrayList);
    }

    public void removeEvent(AdminEvent adminEvent) {
        this.cache.remove(adminEvent);
    }

    synchronized void addChangeEventMap(ConfigChange configChange, AdminEvent adminEvent) {
        this.changeEventMap.put(configChange, adminEvent);
    }

    synchronized void removeChangeEventMap(ConfigChange configChange) {
        this.changeEventMap.remove(configChange);
    }

    public synchronized void processConfigChangeList(ArrayList arrayList, boolean bl, boolean bl2) {
        Object object;
        ConfigChangeEvent configChangeEvent = null;
        boolean bl3 = false;
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ConfigChangeEvent)) continue;
            configChangeEvent = (ConfigChangeEvent)object;
            bl3 = true;
            break;
        }
        if (configChangeEvent == null) {
            configChangeEvent = new ConfigChangeEvent(this.instanceName, null);
        }
        if (bl || bl2) {
            configChangeEvent.setWebCoreReconfigNeeded(true);
        }
        if (bl) {
            configChangeEvent.setInitOrObjConfChanged(true);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (ConfigChange)iterator.next();
                if (object == null) continue;
                this.doChangeBucketing((ConfigChange)object, configChangeEvent);
            }
        }
        if (!bl3) {
            this.cache.add(configChangeEvent);
        }
        this.purgeNopEvents();
    }

    private void doChangeBucketing(ConfigChange configChange, ConfigChangeEvent configChangeEvent) {
        logger.log(Level.FINEST, PROCESS_CHANGE, configChange);
        if (configChange == null || configChange.getXPath() == null) {
            logger.log(Level.FINE, CHANGE_NULL, configChange);
            return;
        }
        boolean bl = false;
        bl = this.processMonitoringEvent(configChange);
        if (!bl) {
            bl = this.processResourceChangeEvent(configChange);
        }
        if (!bl) {
            bl = this.processOtherDeployEvent(configChange);
        }
        if (!bl) {
            configChangeEvent.addConfigChange(configChange);
            if (!configChangeEvent.isWebCoreReconfigNeeded()) {
                this.setWebCoreReconfig(configChange, configChangeEvent);
            }
        }
    }

    private boolean processMonitoringEvent(ConfigChange configChange) {
        ConfigUpdate configUpdate = null;
        if (!(configChange instanceof ConfigUpdate)) {
            return false;
        }
        configUpdate = (ConfigUpdate)configChange;
        if (configUpdate.getNewValue(MONITORING_ENABLED) == null) {
            return false;
        }
        String string = AdminEventCache.cleanXPath(configUpdate.getXPath());
        boolean bl = true;
        String string2 = null;
        if (string.equalsIgnoreCase(EJB_MON) || string.equalsIgnoreCase(MDB_MON) || string.equalsIgnoreCase(WEB_MON) || string.equalsIgnoreCase(JTS_MON) || string.equalsIgnoreCase(ORB_MON)) {
            string2 = this.getMonitoringComponentName(string);
        } else {
            bl = false;
        }
        if (bl) {
            String string3 = null;
            string3 = AdminEventCache.getServerXmlBooleanValue(configUpdate.getNewValue(MONITORING_ENABLED)) ? "start_monitoring" : "stop_monitoring";
            MonitoringEvent monitoringEvent = new MonitoringEvent(this.instanceName, string2, string3);
            this.cache.add(monitoringEvent);
            if (configUpdate.getAttributeSet().size() > 1) {
                bl = false;
                ConfigUpdate configUpdate2 = new ConfigUpdate(configUpdate.getXPath(), MONITORING_ENABLED, configUpdate.getOldValue(MONITORING_ENABLED), configUpdate.getNewValue(MONITORING_ENABLED));
                monitoringEvent.addConfigChange(configUpdate2);
                configUpdate.removeAttribute(MONITORING_ENABLED);
            } else {
                monitoringEvent.addConfigChange(configChange);
            }
        }
        return bl;
    }

    private boolean processResourceChangeEvent(ConfigChange configChange) {
        String string = AdminEventCache.cleanXPath(configChange.getXPath());
        boolean bl = false;
        if (this.isResourceXPath(string)) {
            String string2;
            Object object;
            String string3 = null;
            if (configChange instanceof ConfigUpdate) {
                object = (ConfigUpdate)configChange;
                string2 = ((ConfigUpdate)object).getNewValue(ServerTags.ENABLED);
                string3 = string2 != null ? (AdminEventCache.getServerXmlBooleanValue(string2) ? "enable" : "disable") : "redeploy";
            } else if (configChange instanceof ConfigAdd) {
                string3 = this.isPropertyXPath(string) ? "redeploy" : "deploy";
            } else if (configChange instanceof ConfigDelete) {
                string3 = this.isPropertyXPath(string) ? "redeploy" : "undeploy";
            } else if (configChange instanceof ConfigSet) {
                string3 = "redeploy";
            } else {
                String string4 = localStrings.getString("admin.event.unknown_configchange_for_resources");
                throw new IllegalStateException(string4);
            }
            object = this.getResourceType(string);
            string2 = this.getResourceName(string);
            ResourceDeployEvent resourceDeployEvent = this.findResourceDeployEvent((String)object, string2);
            if (resourceDeployEvent == null) {
                resourceDeployEvent = new ResourceDeployEvent(this.instanceName, string2, (String)object, string3);
                this.cache.add(resourceDeployEvent);
            } else if (this.isActionValidForCache(string3)) {
                resourceDeployEvent.setNewAction(string3);
            }
            resourceDeployEvent.addConfigChange(configChange);
            bl = true;
        }
        return bl;
    }

    private boolean isResourceXPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl = false;
        String string2 = null;
        if (stringTokenizer.hasMoreTokens() && ServerTags.SERVER.equals(string2 = stringTokenizer.nextToken().toLowerCase())) {
            String string3 = null;
            if (stringTokenizer.hasMoreTokens() && ServerTags.RESOURCES.equals(string3 = stringTokenizer.nextToken().toLowerCase())) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isPropertyXPath(String string) {
        return AdminEventCache.matchRegex(PROPERTY_REGEX, string);
    }

    private String getResourceType(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = "unknown";
        String string3 = "";
        int n = 0;
        while (n < 3) {
            string3 = stringTokenizer.nextToken().toLowerCase();
            ++n;
        }
        if (string3.startsWith(ServerTags.CUSTOM_RESOURCE)) {
            string2 = "custom";
        } else if (string3.startsWith(ServerTags.EXTERNAL_JNDI_RESOURCE)) {
            string2 = "external-jndi";
        } else if (string3.startsWith(ServerTags.JDBC_CONNECTION_POOL)) {
            string2 = "jcp";
        } else if (string3.startsWith(ServerTags.JDBC_RESOURCE)) {
            string2 = "jdbc";
        } else if (string3.startsWith(ServerTags.JMS_RESOURCE)) {
            string2 = "jms";
        } else if (string3.startsWith(ServerTags.MAIL_RESOURCE)) {
            string2 = "mail";
        } else if (string3.startsWith(ServerTags.PERSISTENCE_MANAGER_FACTORY_RESOURCE)) {
            string2 = "pmf";
        }
        return string2;
    }

    private String getResourceName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
        String string2 = stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processOtherDeployEvent(ConfigChange configChange) {
        String string = AdminEventCache.cleanXPath(configChange.getXPath());
        String string2 = string.toLowerCase();
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        if (string2.startsWith(APP_PFX)) {
            string3 = "application";
        } else if (string2.startsWith(EJB_PFX)) {
            string3 = "module";
            string4 = "ejb";
        } else if (string2.startsWith(WEB_PFX)) {
            string3 = "module";
            string4 = "web";
        } else {
            if (!string2.startsWith(RAR_PFX)) {
                return false;
            }
            string3 = "module";
            string4 = "connector";
        }
        String string5 = this.getResourceName(string);
        BaseDeployEvent baseDeployEvent = null;
        baseDeployEvent = "application".equals(string3) ? this.findApplicationDeployEvent(string5) : this.findModuleDeployEvent(string4, string5);
        if (baseDeployEvent == null) {
            if (!(configChange instanceof ConfigUpdate)) {
                String string6 = localStrings.getString("admin.event.handle_add_delete_set_configchange");
                throw new IllegalStateException(string6);
            }
            ConfigUpdate configUpdate = (ConfigUpdate)configChange;
            String string7 = configUpdate.getNewValue(ServerTags.ENABLED);
            String string8 = null;
            string8 = string7 != null ? (AdminEventCache.getServerXmlBooleanValue(string7) ? "enable" : "disable") : "redeploy";
            baseDeployEvent = "application".equals(string3) ? new ApplicationDeployEvent(this.instanceName, string5, string8) : new ModuleDeployEvent(this.instanceName, string5, string4, string8);
            this.cache.add(baseDeployEvent);
            bl = true;
        } else {
            bl = true;
        }
        baseDeployEvent.addConfigChange(configChange);
        return bl;
    }

    private void setWebCoreReconfig(ConfigChange configChange, ConfigChangeEvent configChangeEvent) {
        String string = AdminEventCache.cleanXPath(configChange.getXPath());
        if (this.isWebCoreXPath(string)) {
            configChangeEvent.setWebCoreReconfigNeeded(true);
        }
    }

    private boolean isWebCoreXPath(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if ((string = string.toLowerCase()).startsWith(HTTP_SERVICE) || string.startsWith(WEB_CONTAINER)) {
            bl = true;
        }
        return bl;
    }

    public static boolean getServerXmlBooleanValue(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
            bl = true;
        }
        return bl;
    }

    private String getMonitoringComponentName(String string) {
        String string2 = null;
        string2 = string.equalsIgnoreCase(EJB_MON) ? ServerTags.EJB_CONTAINER : (string.equalsIgnoreCase(MDB_MON) ? ServerTags.MDB_CONTAINER : (string.equalsIgnoreCase(WEB_MON) ? ServerTags.WEB_CONTAINER : (string.equalsIgnoreCase(JTS_MON) ? ServerTags.TRANSACTION_SERVICE : (string.equalsIgnoreCase(ORB_MON) ? ServerTags.ORB : "unknown"))));
        return string2;
    }

    public void cacheResourceChange(String string, String string2, String string3) {
        if (!this.isActionValidForCache(string3)) {
            String string4 = localStrings.getString("admin.event.invalid_action", string3);
            throw new IllegalArgumentException(string4);
        }
        ResourceDeployEvent resourceDeployEvent = this.findResourceDeployEvent(string, string2);
        if (resourceDeployEvent == null) {
            resourceDeployEvent = new ResourceDeployEvent(this.instanceName, string2, string, string3);
            this.cache.add(resourceDeployEvent);
        } else {
            resourceDeployEvent.setNewAction(string3);
        }
    }

    private boolean isActionValidForCache(String string) {
        boolean bl = false;
        if (string != null && (string.equals("deploy") || string.equals("undeploy") || string.equals("redeploy"))) {
            bl = true;
        }
        return bl;
    }

    public static void populateConfigChange(ConfigContext configContext, AdminEvent adminEvent) {
        if (adminEvent instanceof ApplicationDeployEvent) {
            AdminEventCache.populateApplicationConfigChange(configContext, (ApplicationDeployEvent)adminEvent);
        } else if (adminEvent instanceof ModuleDeployEvent) {
            AdminEventCache.populateModuleConfigChange(configContext, (ModuleDeployEvent)adminEvent);
        } else {
            String string = localStrings.getString("admin.event.unsupported_populateconfigchange", adminEvent.getClass().getName());
            throw new UnsupportedOperationException(string);
        }
    }

    private static void populateApplicationConfigChange(ConfigContext configContext, ApplicationDeployEvent applicationDeployEvent) {
        String string = ServerXPathHelper.getAppIdXpathExpression(applicationDeployEvent.getApplicationName());
        string = AdminEventCache.cleanXPath(string);
        applicationDeployEvent.addConfigChange(AdminEventCache.extractConfigChanges(configContext, string));
    }

    private static void populateModuleConfigChange(ConfigContext configContext, ModuleDeployEvent moduleDeployEvent) {
        String string = moduleDeployEvent.getModuleType();
        String string2 = moduleDeployEvent.getModuleName();
        String string3 = null;
        if ("web".equals(string)) {
            string3 = ServerXPathHelper.getWebModuleIdXpathExpression(string2);
        } else if ("ejb".equals(string)) {
            string3 = ServerXPathHelper.getEjbModuleIdXpathExpression(string2);
        } else if ("connector".equals(string)) {
            string3 = ServerXPathHelper.getConnectorModuleIdXpathExpression(string2);
        } else {
            String string4 = localStrings.getString("admin.event.invalid_module_type", string);
            throw new IllegalArgumentException(string4);
        }
        string3 = AdminEventCache.cleanXPath(string3);
        moduleDeployEvent.addConfigChange(AdminEventCache.extractConfigChanges(configContext, string3));
    }

    private static ArrayList extractConfigChanges(ConfigContext configContext, String string) {
        if (configContext == null) {
            String string2 = localStrings.getString("admin.event.null_config_context");
            throw new IllegalArgumentException(string2);
        }
        ArrayList<ConfigChange> arrayList = new ArrayList<ConfigChange>();
        ArrayList arrayList2 = configContext.getConfigChangeList();
        if (arrayList2 == null) {
            String string3 = localStrings.getString("admin.event.null_config_changes_in_configcontext");
            throw new IllegalStateException(string3);
        }
        logger.log(Level.FINEST, EXTRACT_CHANGE, string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ConfigChange configChange = (ConfigChange)iterator.next();
            logger.log(Level.FINEST, PROCESS_CHANGE, configChange);
            String string4 = null;
            if (configChange != null) {
                string4 = AdminEventCache.cleanXPath(configChange.getXPath());
                logger.log(Level.FINEST, CONFIG_CHANGE_XPATH, string4);
            }
            if (configChange == null || string4 == null) {
                logger.log(Level.FINE, CHANGE_NULL, configChange);
                continue;
            }
            if (!string4.equals(string)) continue;
            arrayList.add(configChange);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            configContext.removeConfigChange((ConfigChange)iterator.next());
        }
        return arrayList;
    }

    private static String cleanXPath(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("/{2,}", "/");
    }

    private static boolean matchRegex(String string, String string2) {
        Pattern pattern = Pattern.compile(string, 2);
        Matcher matcher = pattern.matcher(string2);
        return matcher.matches();
    }

    private ResourceDeployEvent findResourceDeployEvent(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = localStrings.getString("admin.event.null_resource_type_or_name", string, string2);
            throw new IllegalArgumentException(string3);
        }
        ResourceDeployEvent resourceDeployEvent = null;
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            AdminEvent adminEvent = (AdminEvent)iterator.next();
            if (!(adminEvent instanceof ResourceDeployEvent)) continue;
            resourceDeployEvent = (ResourceDeployEvent)adminEvent;
            if (string.equals(resourceDeployEvent.getResourceType()) && string2.equals(resourceDeployEvent.getResourceName())) break;
            resourceDeployEvent = null;
        }
        return resourceDeployEvent;
    }

    private ApplicationDeployEvent findApplicationDeployEvent(String string) {
        if (string == null) {
            String string2 = localStrings.getString("admin.event.null_application_name");
            throw new IllegalArgumentException(string2);
        }
        ApplicationDeployEvent applicationDeployEvent = null;
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            AdminEvent adminEvent = (AdminEvent)iterator.next();
            if (!(adminEvent instanceof ApplicationDeployEvent)) continue;
            applicationDeployEvent = (ApplicationDeployEvent)adminEvent;
            if (string.equals(applicationDeployEvent.getApplicationName())) break;
            applicationDeployEvent = null;
        }
        return applicationDeployEvent;
    }

    private ModuleDeployEvent findModuleDeployEvent(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = localStrings.getString("admin.event.null_module_type_or_name", string, string2);
            throw new IllegalArgumentException(string3);
        }
        ModuleDeployEvent moduleDeployEvent = null;
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            AdminEvent adminEvent = (AdminEvent)iterator.next();
            if (!(adminEvent instanceof ModuleDeployEvent)) continue;
            moduleDeployEvent = (ModuleDeployEvent)adminEvent;
            if (moduleDeployEvent.getModuleType().equals(string) && moduleDeployEvent.getModuleName().equals(string2)) break;
            moduleDeployEvent = null;
        }
        return moduleDeployEvent;
    }

    private void purgeNopEvents() {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            AdminEvent adminEvent = (AdminEvent)iterator.next();
            if (!adminEvent.isNoOp()) continue;
            logger.log(Level.FINE, PURGE_NOOP, adminEvent);
            iterator.remove();
        }
    }

    public void setRestartNeeded(boolean bl) {
        if (bl) {
            if (!this.restartNeeded) {
                this.setRestartNeededTrue(true);
            }
        } else {
            this.restartNeeded = false;
        }
    }

    private void setRestartNeededTrue(boolean bl) {
        this.restartNeeded = true;
        this.tsRestartNeededSince = System.currentTimeMillis();
        if (bl) {
            RMIClient rMIClient = AdminChannel.getRMIClient(this.instanceName);
            rMIClient.setRestartNeeded(true);
        }
    }

    public boolean isInstanceRestartNeeded() {
        RMIClient rMIClient;
        boolean bl;
        if (this.restartNeeded && (bl = (rMIClient = AdminChannel.getRMIClient(this.instanceName)).hasRestartedSince(this.tsRestartNeededSince))) {
            this.restartNeeded = false;
        }
        return this.restartNeeded;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

