/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.Serializable;
import java.lang.reflect.Method;

public class SerializableMethod
implements Serializable {
    private Class cls;
    private String methodSignature;

    SerializableMethod(Method method) {
        if (method != null) {
            this.cls = method.getDeclaringClass();
            this.methodSignature = this.getSignature(method);
        }
    }

    Method getMethod() throws NoSuchMethodException {
        if (this.cls == null) {
            return null;
        }
        Method[] methods = this.cls.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (this.getSignature(methods[i]).equals(this.methodSignature)) {
                return methods[i];
            }
            ++i;
        }
        throw new NoSuchMethodException(this.cls.getName() + "(" + this.methodSignature + ")");
    }

    private String getSignature(Method method) {
        String rv = method.getName();
        rv = rv + "(";
        Class<?>[] paramTypes = method.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            rv = rv + paramTypes[i].getName();
            if (i < paramTypes.length - 1) {
                rv = rv + ",";
            }
            ++i;
        }
        rv = rv + ")";
        return rv;
    }
}

