/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.datasource;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.tools.common.deploy.NameValuePair;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.datasource.DSBean;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.swing.JOptionPane;
import org.openide.TopManager;

public class DataSourceUtil {
    static final ResourceBundle bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.datasource.Bundle");
    public static int PROPERTY_NAME_PREFIX_LENGTH = "property.".length();

    public static DSBean getResourceBean(ServerComponent regres) {
        try {
            DSBean bn = new DSBean();
            Reporter.info(regres.getDisplayName());
            String value = null;
            value = (String)regres.getAttribute("name");
            Reporter.info(value);
            if (value == null) {
                Reporter.error("JNDI name returns null");
                bn.setJndiName(null);
            } else {
                bn.setJndiName(value);
            }
            value = (String)regres.getAttribute("pool");
            Reporter.info(value);
            if (value == null) {
                bn.setPoolName(null);
            } else {
                bn.setPoolName(value);
            }
            value = regres.getAttribute("enabled").toString();
            Reporter.info(value);
            if (value == null) {
                bn.setEnabled(null);
            } else {
                bn.setEnabled(value);
            }
            value = (String)regres.getAttribute("description");
            Reporter.info(value);
            if (value == null) {
                bn.setDescription("");
            } else {
                bn.setDescription(value);
            }
            AttributeList props = regres.getAttributes(new String[]{"property."});
            if (props.size() > 0) {
                Object[] pairs = new NameValuePair[props.size()];
                int i = 0;
                while (i < props.size()) {
                    Attribute prop = (Attribute)props.get(i);
                    NameValuePair pair = new NameValuePair();
                    pair.setParamName(prop.getName().substring(PROPERTY_NAME_PREFIX_LENGTH));
                    pair.setParamValue((String)prop.getValue());
                    pairs[i] = pair;
                    ++i;
                }
                bn.setExtParams(pairs);
            }
            return bn;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
        }
        catch (AFException ex) {
            Reporter.error("Got AFException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_Access") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (Throwable ex) {
            Reporter.critical(new StackTrace(ex));
        }
        return null;
    }

    public static boolean setAttribute(ServerComponent regres, String name, Object value) {
        Reporter.info("------------------ name = " + name + ", value = " + value);
        try {
            if (name.equals("JndiName")) {
                regres.setAttribute("name", (String)value);
            } else if (name.equals("PoolName")) {
                String pool = (String)value;
                int offset = pool.indexOf("(");
                if (offset != -1) {
                    pool = pool.substring(0, offset);
                }
                Reporter.info("pool name: " + pool);
                regres.setAttribute("pool", pool);
            } else if (name.equals("Enabled")) {
                regres.setAttribute("enabled", new Boolean((String)value));
            } else if (name.equals("Description")) {
                regres.setAttribute("description", (String)value);
            }
            return true;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
            return false;
        }
        catch (InvalidAttributeValueException ex) {
            Reporter.error("Got InvalidAttributeValueException: " + ex.getMessage());
            return false;
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFException ex) {
            Reporter.error("Got AFException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_Access") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFRuntimeStoreException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Reporter.critical(new StackTrace(ex));
            return false;
        }
    }

    public static boolean isEQUAL(NameValuePair[] val1, NameValuePair[] val2) {
        Reporter.info("");
        if (val1.length != val2.length) {
            return false;
        }
        int i = 0;
        while (i < val1.length) {
            NameValuePair pair = val1[i];
            boolean found = false;
            int j = 0;
            while (j < val2.length) {
                if (pair.getParamName().equals(val2[j].getParamName())) {
                    found = true;
                    if (!pair.getParamValue().equals(val2[j].getParamValue())) {
                        return false;
                    }
                }
                if (found) break;
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] findDeleted(NameValuePair[] newPairs, NameValuePair[] oldPairs) {
        Vector<String> deleted = new Vector<String>();
        int i = 0;
        while (i < oldPairs.length) {
            String paramName = oldPairs[i].getParamName();
            boolean found = false;
            int j = 0;
            while (j < newPairs.length) {
                Reporter.info("new property: " + newPairs[j].getParamName());
                if (paramName.equals(newPairs[j].getParamName())) {
                    Reporter.info("found property " + paramName);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                deleted.add(paramName);
            }
            ++i;
        }
        Object[] delProps = new String[deleted.size()];
        deleted.copyInto(delProps);
        return delProps;
    }

    public static boolean setProperties(ServerComponent regres, NameValuePair[] oldPairs, NameValuePair[] newPairs) {
        try {
            Reporter.info("enter");
            try {
                Reporter.info(" ---------- update properties -------  regres = " + regres.getAttribute("name"));
            }
            catch (Throwable ex) {
                // empty catch block
            }
            AttributeList props = new AttributeList();
            String[] deletedProps = DataSourceUtil.findDeleted(newPairs, oldPairs);
            if (newPairs.length > 0 || deletedProps.length > 0) {
                int i = 0;
                while (i < newPairs.length) {
                    Reporter.info("property name = " + newPairs[i].getParamName() + ", property value = " + newPairs[i].getParamValue());
                    Attribute prop = new Attribute("property." + newPairs[i].getParamName(), newPairs[i].getParamValue());
                    props.add(prop);
                    ++i;
                }
                int i2 = 0;
                while (i2 < deletedProps.length) {
                    Reporter.info("Deleted Properties: " + deletedProps[i2]);
                    Attribute prop = new Attribute("property." + deletedProps[i2], null);
                    props.add(prop);
                    ++i2;
                }
                regres.setAttributes(props);
            }
            return true;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
            return false;
        }
        catch (InvalidAttributeValueException ex) {
            Reporter.error("Got InvalidAttributeValueException: " + ex.getMessage());
            return false;
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFException ex) {
            Reporter.error("Got AFException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_Access") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
    }
}

