/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandFactory;
import com.iplanet.ias.tools.cli.framework.CommandNotFoundException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.CommandValidator;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import com.iplanet.ias.tools.cli.framework.ValidOptionsList;
import java.util.Vector;

public class CommandLineParser
implements CommandValidator {
    public static final String LONG_OPTION_PREFIX = "--";
    public static final String SHORT_OPTION_PREFIX = "-";
    public static final String END_OF_OPTIONS_PREFIX = "--";
    public static final String NO_LONG_OPTION_PREFIX = "--no-";
    public static final String OPTION_VALUE_DELIMETER = "=";
    private static final String sEnvPrefix = "AS_ADMIN_";
    protected String[] arguments = null;
    protected int commandind = 0;
    private ValidCommand commandMatched = null;
    private Command command = null;
    protected Vector options;
    protected Vector operands;

    public CommandLineParser(String[] stringArray) throws CommandException, CommandValidationException, CommandNotFoundException {
        this.initialize();
        this.arguments = stringArray;
        this.parseArguments();
        this.createCommand();
    }

    public void initialize() {
        this.options = new Vector();
        this.operands = new Vector();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public int parseArguments() throws CommandException, CommandValidationException, CommandNotFoundException {
        if (this.arguments == null) {
            return -1;
        }
        if (this.arguments.length <= 0) {
            return -1;
        }
        int n = this.checkCommand(this.arguments[0]);
        ++this.commandind;
        if (n == -1) throw new CommandNotFoundException(this.arguments[0] + " : " + GlobalsManager.getLocalizedString("CommandNotFound"));
        while (this.commandind < this.arguments.length) {
            int n2;
            block11: {
                block13: {
                    block12: {
                        n2 = -1;
                        if (this.arguments[this.commandind].equals("")) {
                            ++this.commandind;
                        }
                        if (this.commandMatched.getLongOptionsCount() <= 0) break block12;
                        if (!this.arguments[this.commandind].startsWith("--")) break block12;
                        if (this.arguments[this.commandind].length() > 2) {
                            n2 = this.checkLongOption();
                            if (n2 == -1) {
                                return -1;
                            }
                            break block11;
                        } else {
                            this.readOperands();
                        }
                        break block11;
                    }
                    if (this.commandMatched.getShortOptionCount() <= 0) break block13;
                    if (!this.arguments[this.commandind].startsWith(SHORT_OPTION_PREFIX)) break block13;
                    int n3 = this.arguments[this.commandind].length();
                    if (this.arguments[this.commandind].length() > 1) {
                        int n4 = this.arguments[this.commandind].indexOf(OPTION_VALUE_DELIMETER);
                        if (n4 == -1) {
                            n4 = this.arguments[this.commandind].length();
                        }
                        n2 = n4 == 2 ? this.checkShortOption() : this.checkShortOptionGroup();
                        break block11;
                    } else if (this.arguments[this.commandind].length() == 1) {
                        this.readOperand();
                        n2 = 1;
                    }
                    break block11;
                }
                this.readOperand();
                n2 = 1;
            }
            if (n2 != -1) continue;
            return -1;
        }
        return 1;
    }

    private void createCommand() throws CommandNotFoundException {
        this.command = CommandFactory.createCommand(this.commandMatched, this.options, this.operands);
    }

    public Command getCommand() {
        return this.command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkLongOption() throws CommandException, CommandValidationException {
        Object object;
        int n = this.arguments[this.commandind].indexOf(OPTION_VALUE_DELIMETER);
        if (n == -1) {
            n = this.arguments[this.commandind].length();
        }
        boolean bl = false;
        int n2 = -1;
        if (this.arguments[this.commandind].startsWith(NO_LONG_OPTION_PREFIX)) {
            bl = true;
        }
        int n3 = 0;
        n3 = bl ? 5 : 2;
        String string = this.arguments[this.commandind].substring(n3, n);
        int n4 = -1;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector vector = this.commandMatched.getOptions();
        int n5 = 0;
        while (n5 < vector.size()) {
            object = (ValidOption)vector.get(n5);
            if (((ValidOption)object).getName().startsWith(string)) {
                if (((ValidOption)object).getName().equals(string)) {
                    n4 = n5;
                    bl2 = true;
                    break;
                }
                if (n4 == -1) {
                    n4 = n5;
                } else {
                    bl3 = true;
                }
            }
            ++n5;
        }
        if (bl3 && !bl2) {
            object = string + " : " + GlobalsManager.getLocalizedString("OptionAmbiguos");
            throw new CommandException((String)object + "\n" + this.commandMatched.getUsageText());
        }
        if (!bl2) {
            object = "";
            if (n4 != -1) {
                object = ", " + GlobalsManager.getLocalizedString("ClosestMatchIs") + " '" + ((ValidOption)vector.get(n4)).getName() + "'";
            }
            String string3 = "--" + string + " : " + GlobalsManager.getLocalizedString("NoExactOptionMatch") + (String)object + "\n" + this.commandMatched.getUsageText();
            throw new CommandException(string3);
        }
        object = null;
        ValidOption validOption = (ValidOption)vector.get(n4);
        object = this.createOption(validOption);
        if (bl && !validOption.getType().equalsIgnoreCase("boolean")) {
            throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("NotBooleanOption"));
        }
        if (n4 != -1) {
            if (n != this.arguments[this.commandind].length()) {
                if (bl) {
                    throw new CommandException(validOption.getName() + " " + GlobalsManager.getLocalizedString("DoesNotTakeArgument"));
                }
                if (validOption.isValueRequired() != 3) {
                    string2 = this.arguments[this.commandind].substring(n).length() > 1 ? this.arguments[this.commandind].substring(n + 1) : "";
                    ((Option)object).setValue(string2);
                    ++this.commandind;
                }
            } else if (validOption.isValueRequired() == 1) {
                ++this.commandind;
                if (bl) {
                    boolean bl4 = new Boolean(validOption.getDefaultValue()) == false;
                    string2 = String.valueOf(bl4);
                    ((Option)object).setValue(string2);
                } else {
                    if (this.commandind >= this.arguments.length) throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("OptionNotSpecified"));
                    boolean bl5 = this.CheckArgumentForNonOption(this.arguments[this.commandind]);
                    if (!bl5) {
                        throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("OptionNotSpecified"));
                    }
                    string2 = this.arguments[this.commandind];
                    ((Option)object).setValue(string2);
                    ++this.commandind;
                }
            } else {
                if (validOption.isValueRequired() == 2) {
                    if (bl) {
                        ((Option)object).setValue("false");
                    } else {
                        ((Option)object).setValue("true");
                    }
                }
                ++this.commandind;
            }
        }
        this.addOption((Option)object);
        return 1;
    }

    public int checkShortOptionGroup() throws CommandException, CommandValidationException {
        String string = this.arguments[this.commandind].substring(1, this.arguments[this.commandind].length());
        Vector vector = this.commandMatched.getShortOptions();
        int n = 0;
        while (n < string.length()) {
            String string2;
            int n2 = this.findShortOptionIndex(string.charAt(n));
            if (n2 == -1) {
                throw new CommandException(string.charAt(n) + " : " + GlobalsManager.getLocalizedString("InvalidShortOption"));
            }
            ValidOption validOption = (ValidOption)vector.get(n2);
            Option option = this.createOption(validOption);
            if (validOption.isValueRequired() == 1) {
                throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("OptionTakesAnArgument"));
            }
            if (validOption.isValueRequired() == 2 && (string2 = validOption.getDefaultValue()) != null) {
                if (validOption.getType().equalsIgnoreCase("boolean")) {
                    boolean bl = new Boolean(string2) == false;
                    option.setValue(String.valueOf(bl));
                } else {
                    option.setValue(string2);
                }
            }
            this.addOption(option);
            ++n;
        }
        ++this.commandind;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkShortOption() throws CommandException, CommandValidationException {
        int n;
        int n2 = this.arguments[this.commandind].indexOf(OPTION_VALUE_DELIMETER);
        if (n2 == -1) {
            n2 = this.arguments[this.commandind].length();
        }
        if ((n = this.findShortOptionIndex(this.arguments[this.commandind].charAt(1))) == -1) {
            String string = SHORT_OPTION_PREFIX + this.arguments[this.commandind].charAt(1) + " : " + GlobalsManager.getLocalizedString("InvalidShortOption") + "\n" + this.commandMatched.getUsageText();
            throw new CommandException(string);
        }
        Vector vector = this.commandMatched.getShortOptions();
        ValidOption validOption = (ValidOption)vector.get(n);
        Option option = this.createOption(validOption);
        String string = null;
        if (n2 != this.arguments[this.commandind].length()) {
            if (validOption.isValueRequired() == 3) throw new CommandException(validOption.getName() + " " + GlobalsManager.getLocalizedString("DoesNotTakeArgument"));
            string = this.arguments[this.commandind].substring(n2).length() > 1 ? this.arguments[this.commandind].substring(n2 + 1) : "";
            option.setValue(string);
            ++this.commandind;
        } else if (validOption.isValueRequired() == 1) {
            ++this.commandind;
            if (this.commandind >= this.arguments.length) throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("ShortOptionTakesAnArgument"));
            boolean bl = this.CheckArgumentForNonOption(this.arguments[this.commandind]);
            if (!bl) throw new CommandException(validOption.getName() + " : " + GlobalsManager.getLocalizedString("ShortOptionTakesAnArgument"));
            string = this.arguments[this.commandind];
            option.setValue(string);
            ++this.commandind;
        } else if (validOption.isValueRequired() == 2) {
            String string2 = validOption.getDefaultValue();
            if (string2 != null) {
                if (validOption.getType().equalsIgnoreCase("boolean")) {
                    boolean bl = new Boolean(string2);
                    String string3 = String.valueOf(!bl);
                    option.setValue(string3);
                } else {
                    option.setValue(string2);
                }
            }
            ++this.commandind;
        } else {
            ++this.commandind;
        }
        this.addOption(option);
        return 1;
    }

    protected int findShortOptionIndex(char c) {
        int n = -1;
        Vector vector = this.commandMatched.getShortOptions();
        int n2 = 0;
        while (n2 < vector.size()) {
            ValidOption validOption = (ValidOption)vector.get(n2);
            String string = validOption.getShortName();
            if (string != null && string.equals(String.valueOf(c))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int checkInputOption() {
        return 1;
    }

    public int checkCommand(String string) throws CommandNotFoundException, CommandValidationException {
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        this.commandMatched = CommandFactory.getCommandsList().getValidCommand(string);
        if (this.commandMatched == null) {
            return -1;
        }
        return 1;
    }

    protected Option createOption(ValidOption validOption) {
        Option option = new Option(validOption.getName());
        return option;
    }

    private int readOperand() {
        Operand operand = new Operand(this.arguments[this.commandind], null);
        this.addOperand(operand);
        ++this.commandind;
        return 1;
    }

    private int readOperands() {
        ++this.commandind;
        int n = this.commandind;
        while (n < this.arguments.length) {
            this.readOperand();
            ++n;
        }
        return 1;
    }

    private boolean CheckArgumentForNonOption(String string) {
        boolean bl;
        block3: {
            block2: {
                bl = true;
                if (string.startsWith("--")) break block2;
                if (string.startsWith(SHORT_OPTION_PREFIX)) break block2;
                if (string.startsWith("--")) break block2;
                if (!string.startsWith(NO_LONG_OPTION_PREFIX)) break block3;
            }
            bl = false;
        }
        return bl;
    }

    public Vector getOptions() {
        return this.options;
    }

    void setOptions(Vector vector) {
        this.options = vector;
    }

    public Vector getOperands() {
        return this.operands;
    }

    void setOperands(Vector vector) {
        this.operands = vector;
    }

    public int addOperand(Operand operand) {
        this.operands.add(operand);
        return 1;
    }

    public int removeOperand(Operand operand) {
        int n = 0;
        while (n < this.operands.size()) {
            Operand operand2 = (Operand)this.operands.get(n);
            if (operand2.getName().equals(operand.getName())) {
                this.operands.remove(operand2);
                return 1;
            }
            ++n;
        }
        return -1;
    }

    private boolean hasOperand(Operand operand) {
        int n = 0;
        while (n < this.operands.size()) {
            if (((Operand)this.operands.get(n)).getName().equals(operand.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int addOption(Option option) throws CommandValidationException {
        if (this.hasOption(option)) {
            GlobalsManager.getInstance();
            InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
            inputsAndOutputs.getUserOutput().println(GlobalsManager.getLocalizedString("OptionSpecifiedMoreThanOnce", new Object[]{option.getName(), option.getValue()}));
            this.removeOption(option);
        }
        this.options.add(option);
        return 1;
    }

    private int removeOption(Option option) {
        int n = 0;
        while (n < this.options.size()) {
            Option option2 = (Option)this.options.get(n);
            if (option2.getName().equals(option.getName())) {
                this.options.remove(option2);
                return 1;
            }
            ++n;
        }
        return -1;
    }

    private boolean hasOption(Option option) {
        boolean bl = false;
        int n = 0;
        while (n < this.options.size()) {
            if (((Option)this.options.get(n)).getName().equals(option.getName())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean isSetEnvOperands() throws CommandNotFoundException, CommandValidationException {
        int n;
        char c = '=';
        Vector<Operand> vector = new Vector<Operand>();
        ValidOptionsList validOptionsList = CommandFactory.getOptionsList();
        int n2 = 0;
        while (n2 < this.arguments.length) {
            String string;
            n = this.arguments[n2].indexOf(String.valueOf(c));
            if (n == -1 || n == this.arguments[n2].length()) {
                string = GlobalsManager.getLocalizedString("InvalidSyntax");
                if (n2 == 0) {
                    string = GlobalsManager.getLocalizedString("CommandNotFound");
                }
                throw new CommandNotFoundException(this.arguments[n2] + " : " + string);
            }
            string = this.arguments[n2].substring(0, n);
            if (string.regionMatches(true, 0, sEnvPrefix, 0, sEnvPrefix.length())) {
                String string2 = string.substring(sEnvPrefix.length());
                string = string2.toLowerCase();
                Debug.println("optionName = " + string);
                if (validOptionsList.getValidOption(string) != null) {
                    Operand operand = new Operand();
                    operand.setName(string);
                    operand.setValue(this.arguments[n2].substring(n + 1));
                    vector.add(operand);
                } else {
                    Debug.println("Not a valid option : " + string);
                }
            }
            ++n2;
        }
        n = 0;
        while (n < vector.size()) {
            this.operands.add(vector.get(n));
            ++n;
        }
        return true;
    }
}

