/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class ListVirtualServersCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = this.getInstanceOperand(0);
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(string);
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            VirtualServerClass virtualServerClass = httpServiceComponentBean.getVirtualServerClass("defaultclass");
            ServerModelIterator serverModelIterator = virtualServerClass.getVirtualServers();
            if (serverModelIterator.hasNext()) {
                while (serverModelIterator.hasNext()) {
                    VirtualServer virtualServer = (VirtualServer)serverModelIterator.next();
                    this.printMessage(virtualServer);
                }
            } else {
                this.printMessage(this.getLocalizedString("NoVirtualServers"));
            }
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListVirtualServers"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

