/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasAdminMain;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class CommandLineTester
extends JPanel
implements ActionListener {
    static final int DATA_BUFFER_MAX = 5000;
    static final String RUN_BUTTON_LABEL = "Run";
    static final String CLEAR_BUTTON_LABEL = "Clear";
    static final String COMMAND_LINE_LABEL = "Command Line : ";
    static final String MULTIMODE_STR = "multimode";
    static final String seperator = "\n------------------------------------------------------------\n";
    static final String NOT_SUPPORTED_COMMAND = "Not a supported command";
    private JPanel commandLinePanel;
    private JPanel textFieldPanel;
    private JPanel textAreaPanel;
    private JLabel label;
    private JTextField commandLineTextField;
    private JButton runButton;
    private JButton clearButton;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl = new GridBagLayout();
    protected Border etched;

    public CommandLineTester() {
        this.gbc = new GridBagConstraints();
        this.etched = BorderFactory.createEtchedBorder();
        this.commandLinePanel = new JPanel();
        this.commandLinePanel.setLayout(this.gbl);
        this.textFieldPanel = new JPanel();
        this.textFieldPanel.setLayout(this.gbl);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.etched, "");
        this.textFieldPanel.setBorder(titledBorder);
        this.label = new JLabel(COMMAND_LINE_LABEL);
        this.add(this.textFieldPanel, this.label, this.gbc, 0, 0, 1, 1, 0, 0, 0, 16, 0, 0);
        this.commandLineTextField = new JTextField(57);
        this.add(this.textFieldPanel, this.commandLineTextField, this.gbc, 1, 0, 1, 1, 0, 0, 0, 16, 0, 0);
        this.runButton = new JButton(RUN_BUTTON_LABEL);
        this.add(this.textFieldPanel, this.runButton, this.gbc, 2, 0, 1, 1, 0, 0, 0, 14, 0, 0);
        this.textAreaPanel = new JPanel();
        this.textAreaPanel.setLayout(this.gbl);
        this.textArea = new JTextArea(40, 65);
        this.scrollPane = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        this.add(this.textAreaPanel, this.scrollPane, this.gbc, 0, 1, 1, 1, 0, 0, 0, 16, 0, 0);
        this.clearButton = new JButton(CLEAR_BUTTON_LABEL);
        this.add(this.textAreaPanel, this.clearButton, this.gbc, 2, 1, 1, 1, 0, 0, 0, 16, 0, 0);
        this.add(this.commandLinePanel, this.textFieldPanel, this.gbc, 0, 0, 1, 1, 0, 0, 0, 16, 0, 0);
        this.add(this.commandLinePanel, this.textAreaPanel, this.gbc, 0, 1, 1, 1, 0, 0, 0, 16, 0, 0);
        this.add(this.commandLinePanel);
        this.runButton.addActionListener(this);
        this.clearButton.addActionListener(this);
    }

    public void add(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.ipadx = n9;
        gridBagConstraints.ipady = n10;
        gridBagConstraints.anchor = n8;
        jPanel.add(component, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(RUN_BUTTON_LABEL)) {
            String string = this.commandLineTextField.getText();
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(5000);
                InputsAndOutputs inputsAndOutputs = new InputsAndOutputs();
                inputsAndOutputs.setUserOutput(byteArrayOutputStream);
                if (string.startsWith(MULTIMODE_STR)) {
                    this.readAndDisplayOutput(byteArrayOutputStream, NOT_SUPPORTED_COMMAND);
                    return;
                }
                IasAdminMain.invokeCLI(string, inputsAndOutputs);
                this.readAndDisplayOutput(byteArrayOutputStream);
            }
            catch (CommandValidationException commandValidationException) {
                Command command = IasAdminMain.getCommand();
                String string2 = null;
                if (command != null) {
                    string2 = command.getUsage();
                }
                this.readAndDisplayOutput(byteArrayOutputStream, string2 + "\n" + commandValidationException.getMessage());
            }
            catch (Exception exception) {
                this.readAndDisplayOutput(byteArrayOutputStream, exception.getMessage());
                Debug.printStackTrace(exception);
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(CLEAR_BUTTON_LABEL)) {
            this.textArea.setText("");
        }
    }

    private void readAndDisplayOutput(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        this.readAndDisplayOutput(byteArrayOutputStream, null);
    }

    private void readAndDisplayOutput(ByteArrayOutputStream byteArrayOutputStream, String string) {
        try {
            string = string == null ? byteArrayOutputStream.toString() + seperator : string + seperator;
            Document document = this.textArea.getDocument();
            boolean bl = this.textArea.getCaretPosition() == document.getLength();
            this.textArea.append(string);
            if (bl) {
                this.textArea.setCaretPosition(document.getLength());
            }
        }
        catch (Exception exception) {
            this.textArea.append(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        MainFrame mainFrame = new MainFrame();
        mainFrame.setSize(800, 800);
        mainFrame.show();
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public static class MainFrame
    extends JFrame {
        public MainFrame() {
            CommandLineTester commandLineTester = new CommandLineTester();
            this.getContentPane().add(commandLineTester);
        }
    }
}

