/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthDb;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class VirtualServerController
implements Controller {
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String CREATE_AUTH_DB = "createAuthDb";
    private static final String DELETE_AUTH_DB = "deleteAuthDb";
    private static final String LIST_AUTH_DBS = "listAuthDbs";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private VirtualServer component;

    public VirtualServerController(VirtualServer virtualServer) {
        this.component = virtualServer;
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean bl = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(bl != null, "null value returned");
        return bl;
    }

    public void createHttpQos() throws AFException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, objectArray, stringArray);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    public void createAuthDb(String string, String string2) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "database", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2, null, null};
        this.invoke(CREATE_AUTH_DB, objectArray, stringArray);
    }

    public void removeAuthDb(String string) throws AFException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_AUTH_DB, objectArray, stringArray);
    }

    public ServerModelIterator getAuthDbs() throws AFException {
        String[] stringArray = (String[])this.invoke(LIST_AUTH_DBS, null, null);
        Vector<AuthDb> vector = new Vector<AuthDb>();
        if (stringArray != null && stringArray.length > 0) {
            String string = this.component.getInstanceName();
            String string2 = this.component.getVirtualServerClassId();
            String string3 = this.component.getVirtualServerId();
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getVirtualServerAuthDBObjectName(string, string2, string3, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("VirtualServerController.getAuthDbs: mbeanName = " + objectName);
                AuthDb authDb = new AuthDb(objectName.toString(), stringArray[n]);
                authDb.setContextHolder(this.component.getContextHolder());
                vector.add(authDb);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.component.getContextHolder();
            ObjectName objectName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

