/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SecurityServiceComponentController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class SecurityServiceComponentBean
extends ServerComponent
implements Serializable {
    private transient SecurityServiceComponentController controller = new SecurityServiceComponentController(this);

    public SecurityServiceComponentBean(String string) {
        super(string);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createAuthRealm(String string, String string2) throws AFException {
        this.controller.createAuthRealm(string, string2);
    }

    public void deleteAuthRealm(String string) throws AFException {
        this.controller.deleteAuthRealm(string);
    }

    public ServerModelIterator getAuthRealms() throws AFException {
        return this.controller.getAuthRealms();
    }

    public AuthRealm getAuthRealm(String string) {
        ArgChecker.checkValid(string, "realmName", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        ObjectName objectName = ObjectNames.getAuthRealmObjectName(string2, string);
        Assert.assertit(objectName != null, "null value returned");
        AuthRealm authRealm = new AuthRealm(objectName.toString(), string);
        authRealm.setContextHolder(this.getContextHolder());
        return authRealm;
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }
}

