/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.ACL;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.Mime;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.HttpServiceComponentController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class HttpServiceComponentBean
extends ServerComponent
implements Serializable {
    private transient HttpServiceComponentController controller = new HttpServiceComponentController(this);

    public HttpServiceComponentBean(String string) {
        super(string);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createHttpListener(String string, String string2, int n, String string3, String string4) throws AFException {
        this.controller.createHttpListener(string, string2, n, string3, string4);
    }

    public void deleteHttpListener(String string) throws AFException {
        this.controller.deleteHttpListener(string);
    }

    public HttpListener getHttpListener(String string) {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        Assert.assertit(string2 != null, "null value returned");
        ObjectName objectName = ObjectNames.getHttpListenerObjectName(string2, string);
        Assert.assertit(objectName != null, "null value returned");
        HttpListener httpListener = new HttpListener(objectName.toString(), string);
        httpListener.setContextHolder(this.getContextHolder());
        return httpListener;
    }

    public ServerModelIterator getHttpListeners() throws AFException {
        return this.controller.getHttpListeners();
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public void createMime(String string, String string2) throws AFException {
        this.controller.createMime(string, string2);
    }

    public void removeMime(String string) throws AFException {
        this.controller.removeMime(string);
    }

    public ServerModelIterator getMimes() throws AFException {
        return this.controller.getMimes();
    }

    public Mime getMime(String string) {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        ObjectName objectName = ObjectNames.getMimeObjectName(string2, string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getMime: mbean = " + objectName);
        Mime mime = new Mime(objectName.toString(), string);
        mime.setContextHolder(this.getContextHolder());
        return mime;
    }

    public void createAcl(String string, String string2) throws AFException {
        this.controller.createAcl(string, string2);
    }

    public void removeAcl(String string) throws AFException {
        this.controller.removeAcl(string);
    }

    public ServerModelIterator getAcls() throws AFException {
        return this.controller.getAcls();
    }

    public ACL getAcl(String string) {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        ObjectName objectName = ObjectNames.getAclObjectName(string2, string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getAcl: mbean = " + objectName);
        ACL aCL = new ACL(objectName.toString(), string);
        aCL.setContextHolder(this.getContextHolder());
        return aCL;
    }

    public VirtualServerClass getVirtualServerClass(String string) {
        ArgChecker.checkValid(string, "classId", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        Assert.assertit(string2 != null, "null value returned");
        ObjectName objectName = ObjectNames.getVirtualServerClassObjectName(string2, string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("HttpServiceComponentBean.getVirtualServerClass: mbean = " + objectName);
        VirtualServerClass virtualServerClass = new VirtualServerClass(objectName.toString(), string);
        virtualServerClass.setContextHolder(this.getContextHolder());
        return virtualServerClass;
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }
}

