/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.AuthenticationInfo;
import com.iplanet.ias.admin.comm.GenericHttpConnectorAddress;
import com.iplanet.ias.admin.util.HostAndPort;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import sun.misc.BASE64Encoder;

public final class HttpConnectorAddress
implements GenericHttpConnectorAddress {
    private static final String HTTP_CONNECTOR = "http";
    private static final String HTTPS_CONNECTOR = "https";
    private static final String AUTHORIZATION_KEY = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Basic ";
    private String host;
    private int port;
    private AuthenticationInfo authInfo;
    private boolean secure;

    public HttpConnectorAddress() {
    }

    public HttpConnectorAddress(HostAndPort hostAndPort) {
        this(hostAndPort.getHost(), hostAndPort.getPort(), hostAndPort.isSecure());
    }

    public HttpConnectorAddress(String string, int n) {
        this(string, n, false);
    }

    public HttpConnectorAddress(String string, int n, boolean bl) {
        this.host = string;
        this.port = n;
        this.secure = bl;
    }

    public URLConnection openConnection(String string) throws IOException {
        return this.openConnection(this.toURL(string));
    }

    public String getConnectorType() {
        return this.isSecure() ? HTTPS_CONNECTOR : HTTP_CONNECTOR;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authInfo = authenticationInfo;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean isSecure() {
        return this.secure;
    }

    private final String getUser() {
        return this.authInfo != null ? this.authInfo.getUser() : "";
    }

    private final String getPassword() {
        return this.authInfo != null ? this.authInfo.getPassword() : "";
    }

    private final String asURLSpec(String string) {
        return this.getConnectorType() + "://" + this.getAuthority() + (string != null ? string : "");
    }

    private final String getAuthority() {
        return this.getHost() + ":" + this.getPort();
    }

    private final URL toURL(String string) throws MalformedURLException {
        return new URL(this.asURLSpec(string));
    }

    private final URLConnection openConnection(URL uRL) throws IOException {
        return this.setOptions(this.makeConnection(uRL));
    }

    private final URLConnection makeConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpsURLConnection) {
            this.setHostnameVerifier((HttpsURLConnection)uRLConnection);
        }
        return uRLConnection;
    }

    private final URLConnection setHostnameVerifier(HttpsURLConnection httpsURLConnection) {
        httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){
            private final String expected;
            {
                this.expected = HttpConnectorAddress.this.host;
            }

            public boolean verify(String string, SSLSession sSLSession) {
                return this.expected.equals(string);
            }
        });
        return httpsURLConnection;
    }

    private final URLConnection setOptions(URLConnection uRLConnection) {
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
        return this.setAuthentication(uRLConnection);
    }

    private final URLConnection setAuthentication(URLConnection uRLConnection) {
        if (this.authInfo != null) {
            uRLConnection.setRequestProperty(AUTHORIZATION_KEY, this.getBasicAuthString());
        }
        return uRLConnection;
    }

    private final String getBasicAuthString() {
        return AUTHORIZATION_TYPE + HttpConnectorAddress.getBase64Encoded(this.getUser() + ":" + this.getPassword());
    }

    private static final String getBase64Encoded(String string) {
        return new BASE64Encoder().encode(string.getBytes());
    }
}

