/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseVersionCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import com.sun.appserv.server.util.Version;

public class VersionCommand
extends BaseVersionCommand {
    private static String sCLIVersion = "1";

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("user") == null) {
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"user"}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.isLocal()) {
            String string = null;
            string = this.isVerbose() ? Version.getFullVersion() : Version.getVersion();
            this.printMessage(string);
        } else {
            try {
                ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
                String string = null;
                string = this.isVerbose() ? serverInstanceManager.getFullVersion() : serverInstanceManager.getVersion();
                this.printMessage(string);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotGetVersion"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private boolean isVerbose() throws CommandValidationException {
        Option option = this.findOption("verbose");
        if (option == null) {
            return false;
        }
        String string = option.getValue();
        Debug.println("isVerboseStr = " + string);
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }
}

