/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class StartAppServCommand
extends BaseLifeCycleCommand {
    public StartAppServCommand() {
    }

    public StartAppServCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            this.unsetLicenseLogger();
            IASLicense.checkCurrent((boolean)false);
        }
        catch (Exception exception) {
            Debug.println(exception);
            throw new CommandException(exception.getMessage());
        }
        String[] stringArray = this.getAllDomains();
        boolean bl = true;
        if (stringArray.length == 0) {
            throw new CommandException("NoDomainToStart");
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                boolean bl2 = this.startDomain(stringArray[n]);
                if (bl2) {
                    this.printMessage(this.getLocalizedString("DomainStarted", new Object[]{stringArray[n]}));
                } else {
                    bl = false;
                    this.printMessage(this.getLocalizedString("CouldNotStartDomainInstances", new Object[]{stringArray[n]}));
                }
            }
            catch (Exception exception) {
                bl = false;
                Debug.println(exception);
                Debug.printStackTrace(exception);
                this.printMessage(this.getLocalizedString("CannotStartDomainName", new Object[]{stringArray[n]}));
                this.printError(exception.getLocalizedMessage());
            }
            ++n;
        }
        if (!bl) {
            throw new CommandException(this.getLocalizedString("CannotStartOneOrMoreDomains"));
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

