/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedConnectorComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedModuleComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseDeploymentCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class ListComponentsCommand
extends BaseDeploymentCommand {
    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        String string = null;
        if (this.findOption("type") != null) {
            string = this.findOption("type").getValue();
        }
        if (!(string == null || string.equalsIgnoreCase("all") || string.equalsIgnoreCase("application") || string.equalsIgnoreCase("web") || string.equalsIgnoreCase("ejb") || string.equalsIgnoreCase("connector"))) {
            throw new CommandValidationException(this.getLocalizedString("InvalidType", new Object[]{string}));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            String string = null;
            if (this.findOption("type") != null) {
                string = this.findOption("type").getValue();
            }
            if (string.equalsIgnoreCase("all")) {
                this.listApps(appServerInstance);
                this.listWebModules(appServerInstance);
                this.listEJBModules(appServerInstance);
                this.listConnectorModules(appServerInstance);
            } else if (string.equalsIgnoreCase("application")) {
                this.listApps(appServerInstance);
            } else if (string.equalsIgnoreCase("web")) {
                this.listWebModules(appServerInstance);
            } else if (string.equalsIgnoreCase("ejb")) {
                this.listEJBModules(appServerInstance);
            } else if (string.equalsIgnoreCase("connector")) {
                this.listConnectorModules(appServerInstance);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListComponents"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private void listApps(AppServerInstance appServerInstance) throws AFException {
        ServerModelIterator serverModelIterator = appServerInstance.getDeployedApplications();
        if (serverModelIterator.hasNext()) {
            while (serverModelIterator.hasNext()) {
                DeployedApplicationComponentBean deployedApplicationComponentBean = (DeployedApplicationComponentBean)serverModelIterator.next();
                this.printMessage(deployedApplicationComponentBean + " <" + this.getLocalizedString("Application") + ">");
            }
        } else {
            this.printMessage(this.getLocalizedString("NoDeployedApplications"));
        }
    }

    private void listWebModules(AppServerInstance appServerInstance) throws AFException {
        ServerModelIterator serverModelIterator = appServerInstance.getDeployedWebModules();
        if (serverModelIterator.hasNext()) {
            while (serverModelIterator.hasNext()) {
                DeployedModuleComponentBean deployedModuleComponentBean = (DeployedModuleComponentBean)serverModelIterator.next();
                this.printMessage(deployedModuleComponentBean + " <" + this.getLocalizedString("Web") + ">");
            }
        } else {
            this.printMessage(this.getLocalizedString("NoWEBModules"));
        }
    }

    private void listEJBModules(AppServerInstance appServerInstance) throws AFException {
        ServerModelIterator serverModelIterator = appServerInstance.getDeployedEJBModules();
        if (serverModelIterator.hasNext()) {
            while (serverModelIterator.hasNext()) {
                DeployedModuleComponentBean deployedModuleComponentBean = (DeployedModuleComponentBean)serverModelIterator.next();
                this.printMessage(deployedModuleComponentBean + " <" + this.getLocalizedString("Ejb") + ">");
            }
        } else {
            this.printMessage(this.getLocalizedString("NoEJBModules"));
        }
    }

    private void listConnectorModules(AppServerInstance appServerInstance) throws AFException {
        ServerModelIterator serverModelIterator = appServerInstance.getDeployedConnectors();
        if (serverModelIterator.hasNext()) {
            while (serverModelIterator.hasNext()) {
                DeployedConnectorComponentBean deployedConnectorComponentBean = (DeployedConnectorComponentBean)serverModelIterator.next();
                this.printMessage(deployedConnectorComponentBean + " <" + this.getLocalizedString("Connector") + ">");
            }
        } else {
            this.printMessage(this.getLocalizedString("NoConnectorModules"));
        }
    }
}

