/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateAuthRealmCommand
extends BaseOtherCommand {
    private static final String CLASS_NAME = "classname";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Controllable controllable;
        AttributeList attributeList = null;
        SecurityServiceComponentBean securityServiceComponentBean = null;
        String string = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            string = ((Operand)this.getOperands().get(0)).getName();
            object = this.getClassNameOption();
            attributeList = this.getAttributeList();
            AppServerInstance appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            securityServiceComponentBean = appServerInstance.getSecurityService();
            securityServiceComponentBean.createAuthRealm(string, (String)object);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateAuthRealm"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedAuthRealm", new Object[]{string}));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = securityServiceComponentBean.getAuthRealm(string);
                object = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getClassNameOption() {
        Option option = this.findOption(CLASS_NAME);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        AttributeList attributeList = new AttributeList();
        Properties properties = this.getProperties();
        if (!properties.isEmpty()) {
            String string = "property.";
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)properties.get(string2);
                Attribute attribute = new Attribute(string + string2, string3);
                attributeList.add(attribute);
                Debug.println("Property(name,value) = " + string2 + " , " + string3);
            }
        }
        return attributeList;
    }
}

