/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.JVMComponentController;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class JVMComponentBean
extends ServerComponent
implements Serializable {
    private static final String JVM = "Java Virtual Machine";
    private transient JVMComponentController controller = new JVMComponentController(this);

    public JVMComponentBean(String string) {
        super(string, JVM);
    }

    public Controller getController() {
        return this.controller;
    }

    public String[] getJvmOptions() throws AFException {
        return this.controller.getJvmOptions();
    }

    public void setJvmOptions(String[] stringArray) throws AFException {
        this.controller.setJvmOptions(stringArray);
    }

    public void createProfiler(String string) throws AFException {
        this.controller.createProfiler(string);
    }

    public boolean isProfilerExists() throws AFException {
        return this.controller.isProfilerExists();
    }

    public Profiler getProfiler() throws AFException {
        return this.controller.getProfiler();
    }

    public Profiler getProfiler(String string) {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getProfilerObjectName(this.getInstanceName());
        Assert.assertit(objectName != null, "null value returned");
        Profiler profiler = new Profiler(objectName.toString(), string);
        profiler.setContextHolder(this.getContextHolder());
        return profiler;
    }

    public void deleteProfiler() throws AFException {
        this.controller.deleteProfiler();
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }
}

