/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.util.ArgChecker;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXExceptionTranslator {
    private static final String NULL_ARGUMENT = "null-arg";

    public static AFException translate(Exception exception) {
        ArgChecker.check(exception != null, (Object)NULL_ARGUMENT);
        AFException aFException = new AFException(exception.getMessage());
        if (exception instanceof MBeanException) {
            Exception exception2 = ((MBeanException)exception).getTargetException();
            if (exception2 instanceof AFException) {
                aFException = (AFException)exception2;
            } else {
                if (exception2 instanceof AFRuntimeException) {
                    throw (AFRuntimeException)exception2;
                }
                if (exception2 instanceof MBeanException) {
                    Exception exception3 = ((MBeanException)exception2).getTargetException();
                    if (exception3 != null && exception3 instanceof javax.management.InvalidAttributeValueException) {
                        aFException = new InvalidAttributeValueException(exception3.getLocalizedMessage());
                    }
                } else {
                    aFException = new AFOtherException(exception2);
                }
            }
        } else if (exception instanceof InstanceNotFoundException) {
            String string = JMXExceptionTranslator.convertInstanceNotFoundExceptionMessage(exception);
            aFException = new AFTargetNotFoundException(string);
        } else if (exception instanceof ReflectionException) {
            aFException = new AFOtherException(exception);
        } else if (exception instanceof javax.management.AttributeNotFoundException) {
            aFException = new AttributeNotFoundException(exception.getLocalizedMessage());
        } else if (exception instanceof javax.management.InvalidAttributeValueException) {
            aFException = new InvalidAttributeValueException(exception.getLocalizedMessage());
        } else if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return aFException;
    }

    private static String convertInstanceNotFoundExceptionMessage(Exception exception) {
        Object object;
        String string = null;
        String string2 = null;
        try {
            object = new ObjectName(exception.getMessage());
            string = ObjectNameHelper.getType((ObjectName)object);
            string2 = ObjectNameHelper.getName((ObjectName)object);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        object = string != null ? (string2 != null ? string + " '" + string2 + "' is not found." : string + " is not found.") : exception.getLocalizedMessage();
        return object;
    }
}

