/*
 * Decompiled with CFR 0.152.
 */
package samples.xml.xslt;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TransformationApp03 {
    static Document document;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java TransformationApp filename");
            System.exit(1);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            File file = new File(stringArray[0]);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("slide");
            Node node = nodeList.item(0);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("   " + transformerConfigurationException.getMessage());
            Throwable throwable = transformerConfigurationException;
            if (transformerConfigurationException.getException() != null) {
                throwable = transformerConfigurationException.getException();
            }
            ((Throwable)throwable).printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + transformerException.getMessage());
            Throwable throwable = transformerException;
            if (transformerException.getException() != null) {
                throwable = transformerException.getException();
            }
            ((Throwable)throwable).printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

