/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.deploy;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyRunningException;
import com.iplanet.ias.admin.common.exception.InstanceNotRunningException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.common.LoginFailureException;
import com.iplanet.ias.tools.common.deploy.IServerInstanceBean;
import com.iplanet.ias.tools.common.deploy.ServerInstance;
import com.iplanet.ias.tools.common.ui.UIMessenger;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;

public class ServerInstance
implements Serializable {
    private String host;
    private String ad_host;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String name;
    private String dispName;
    private String password;
    private int port;
    private int ad_port;
    private String userName;
    public static String pw_editor;
    transient boolean checkAlreadyDone = false;
    transient boolean IAS_Running;
    transient boolean checkDone = false;
    transient boolean KJS_Running;
    transient boolean instRunning;
    transient boolean isEnabled;
    private transient ServerInstanceManager manager;
    private transient AppServerInstance instance;
    String depName = null;
    static final ResourceBundle bundle;
    private int debugPort;

    public ServerInstance(String SOM_name, String serv_name, int serv_port, String username, String passwd) {
        this.userName = username;
        this.password = passwd;
        this.dispName = SOM_name;
        this.name = serv_name;
        this.port = serv_port;
        this.ad_host = serv_name.substring(serv_name.indexOf("(") + 1, serv_name.indexOf(":"));
        this.ad_port = Integer.parseInt(serv_name.substring(serv_name.indexOf(":") + 1, serv_name.indexOf(")")));
    }

    public ServerInstance(String SOM_name, String serv_name, int serv_port) {
        this(SOM_name, serv_name, serv_port, "admin", "admin123");
    }

    public ServerInstance(String SOM_name, String serv_name) {
        this(SOM_name, serv_name, -1);
    }

    public static HostAndPort configurInstance(String host_name, int port_no) {
        HostAndPort hp = new HostAndPort(host_name, port_no);
        return hp;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        String oldValue = this.host;
        this.host = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("host", oldValue, this.host);
    }

    private void initPropertyChangeSupport() {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.initPropertyChangeSupport();
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.initPropertyChangeSupport();
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        String oldValue = this.name;
        this.name = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("name", oldValue, this.name);
    }

    public String getDisplayName() {
        return this.dispName;
    }

    public void setDisplayName(String value) {
        String oldValue = this.dispName;
        this.dispName = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("displayname", oldValue, this.dispName);
    }

    public String getPrivatePassword() {
        String pw = this.getPassword();
        String passw = "";
        int i = 0;
        while (i < pw.length()) {
            passw = passw + "*";
            ++i;
        }
        return passw;
    }

    public String getPassword() {
        pw_editor = this.password;
        return this.password;
    }

    public void setPassword(String value) {
        String oldValue = this.host;
        this.password = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("password", oldValue, this.password);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        Reporter.info("Setting Server Port to " + value);
        String oldValue = this.host;
        this.port = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("port", null, null);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String value) {
        String oldValue = this.host;
        this.userName = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("userName", oldValue, this.userName);
    }

    public String getAdminHost() {
        return this.ad_host;
    }

    public void setAdminHost(String value) {
        String oldValue = this.ad_host;
        this.ad_host = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("ad_host", oldValue, this.ad_host);
    }

    public int getAdminPort() {
        return this.ad_port;
    }

    public void setAdminPort(int value) {
        int oldValue = this.ad_port;
        this.ad_port = value;
        this.initPropertyChangeSupport();
        this.propertySupport.firePropertyChange("ad_port", oldValue, this.ad_port);
    }

    public String getConnectorUrl() {
        return "http://" + this.getName().substring(this.getName().indexOf("(") + 1, this.getName().indexOf(":") + 1) + this.getPort();
    }

    private synchronized AppServerInstance getSelectedInstance() throws DeploymentException, AFTargetNotFoundException {
        if (this.instance == null) {
            Reporter.info("Initializing instance");
            String host = this.getName().substring(this.getName().indexOf("(") + 1, this.getName().indexOf(":"));
            int port = Integer.parseInt(this.getName().substring(this.getName().indexOf(":") + 1, this.getName().indexOf(")")));
            HostAndPort hostPort = new HostAndPort(host, port);
            Reporter.info("getSelectedInstance " + this.getName().substring(0, this.getName().indexOf("(")));
            Reporter.info(hostPort);
            this.manager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(hostPort, this.userName, this.password);
            Reporter.assertIt(this.manager);
            this.instance = this.manager.getServerInstance(this.getName().substring(0, this.getName().indexOf("(")));
            Reporter.assertIt(this.instance);
        }
        return this.instance;
    }

    public void createResource(String fname) throws AFException, AFResourceException, AFTargetNotFoundException, DeploymentException {
        this.getSelectedInstance().createResource(fname);
        this.getSelectedInstance().applyChanges();
    }

    public boolean deployEarFile(String earPath, UIMessenger messenger) throws DeploymentException {
        String path = earPath;
        Reporter.info(earPath);
        ServerModelIterator it = null;
        InetAddress IP = null;
        boolean deploySuccess = true;
        try {
            IP = InetAddress.getByName(this.getAdminHost());
            Socket s = new Socket(IP, this.getAdminPort());
            s.close();
            try {
                Reporter.info("Getting App Name");
                String appName = path.substring(path.lastIndexOf(File.separator) + 1, path.lastIndexOf("."));
                boolean exists = false;
                Reporter.info(appName);
                try {
                    it = this.getSelectedInstance().getDeployedApplications();
                }
                catch (AFException e) {
                    throw new DeploymentException(e.getLocalizedMessage());
                }
                catch (AFRuntimeStoreException afre) {
                    throw new AFRuntimeStoreException(afre.getLocalizedMessage());
                }
                messenger.setProgressMessage(bundle.getString("ExsistingAppCheck"));
                messenger.setProgressLevel(30);
                while (it.hasNext()) {
                    this.depName = it.next().toString();
                    if (!this.depName.equalsIgnoreCase(appName)) continue;
                    exists = true;
                    break;
                }
                Reporter.info(this.getSelectedInstance().getDeployedApplication(appName));
                if (exists) {
                    Reporter.info("Calling Redeploy");
                    messenger.setProgressMessage(bundle.getString("RedeployMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().redeployApplication(path, appName);
                } else {
                    Reporter.info("Calling Deploy");
                    messenger.setProgressMessage(bundle.getString("DeployMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().deployApplication(path, appName, true, null, true, false, false);
                }
                messenger.setProgressLevel(90);
                messenger.setProgressLevel(100);
            }
            catch (AFTargetNotFoundException te) {
                throw new DeploymentException(te.getLocalizedMessage());
            }
            catch (DeploymentException de) {
                throw new DeploymentException(de.getLocalizedMessage());
            }
            catch (AFRuntimeStoreException afre) {
                messenger.ConfigXmlChanged(this.getName());
            }
        }
        catch (UnknownHostException e) {
            throw new DeploymentException(e.getLocalizedMessage());
        }
        catch (IOException con) {
            throw new DeploymentException(con.getLocalizedMessage());
        }
        return deploySuccess;
    }

    public boolean deployWarFile(String warPath, String waName, String contextRoot, UIMessenger messenger) throws DeploymentException {
        String path = warPath;
        Reporter.info("Context Root" + contextRoot + "War Path" + warPath);
        ServerModelIterator it = null;
        InetAddress IP = null;
        boolean deploySuccess = true;
        try {
            IP = InetAddress.getByName(this.getAdminHost());
            Socket s = new Socket(IP, this.getAdminPort());
            s.close();
            try {
                String webAppName = waName;
                Reporter.info("webAppName is : " + webAppName);
                boolean exists = false;
                try {
                    it = this.getSelectedInstance().getDeployedWebModules();
                }
                catch (AFException e) {
                    throw new DeploymentException(e.getLocalizedMessage());
                }
                catch (AFRuntimeStoreException afre) {
                    throw new AFRuntimeStoreException(afre.getLocalizedMessage());
                }
                messenger.setProgressMessage(bundle.getString("ExsistingModuleCheck"));
                messenger.setProgressLevel(30);
                while (it.hasNext()) {
                    this.depName = it.next().toString();
                    if (!this.depName.equalsIgnoreCase(webAppName)) continue;
                    exists = true;
                    break;
                }
                messenger.setProgressMessage(bundle.getString("DeployWar"));
                if (exists) {
                    Reporter.info("Calling Redeploy");
                    messenger.setProgressMessage(bundle.getString("RedeployModuleMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().redeployWarModule(path, webAppName, contextRoot);
                } else {
                    Reporter.info("Calling Deploy");
                    messenger.setProgressMessage(bundle.getString("DeployModuleMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().deployWarModule(path, webAppName, contextRoot, true, null, true, false, false);
                }
                messenger.setProgressLevel(90);
                messenger.setProgressLevel(100);
            }
            catch (AFTargetNotFoundException te) {
                throw new DeploymentException(te.getLocalizedMessage());
            }
            catch (DeploymentException de) {
                throw new DeploymentException(de.getLocalizedMessage());
            }
            catch (AFRuntimeStoreException afre) {
                messenger.ConfigXmlChanged(this.getName());
            }
        }
        catch (UnknownHostException e) {
            throw new DeploymentException(e.getLocalizedMessage());
        }
        catch (IOException con) {
            throw new DeploymentException(con.getLocalizedMessage());
        }
        return deploySuccess;
    }

    public boolean deployEjbJarFile(String ejbJarName, String ejbjarfilePath, UIMessenger messenger) throws DeploymentException {
        String path = ejbjarfilePath;
        ServerModelIterator it = null;
        Reporter.info(ejbjarfilePath);
        InetAddress IP = null;
        boolean deploySuccess = true;
        try {
            IP = InetAddress.getByName(this.getAdminHost());
            Socket s = new Socket(IP, this.getAdminPort());
            s.close();
            try {
                Reporter.info("EjbJar Name" + ejbJarName);
                boolean exists = false;
                try {
                    it = this.getSelectedInstance().getDeployedEJBModules();
                }
                catch (AFException e) {
                    throw new DeploymentException(e.getLocalizedMessage());
                }
                catch (AFRuntimeStoreException afre) {
                    throw new AFRuntimeStoreException(afre.getLocalizedMessage());
                }
                messenger.setProgressMessage(bundle.getString("ExsistingModuleCheck"));
                messenger.setProgressLevel(30);
                while (it.hasNext()) {
                    this.depName = it.next().toString();
                    if (!this.depName.equalsIgnoreCase(ejbJarName)) continue;
                    exists = true;
                    break;
                }
                messenger.setProgressMessage(bundle.getString("DeployEjbJar"));
                if (exists) {
                    Reporter.info("Calling Redeploy");
                    messenger.setProgressMessage(bundle.getString("RedeployModuleMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().redeployEJBJarModule(path, ejbJarName);
                } else {
                    Reporter.info("Calling Deploy");
                    messenger.setProgressMessage(bundle.getString("DeployModuleMessage"));
                    messenger.setProgressLevel(55);
                    deploySuccess = this.getSelectedInstance().deployEJBJarModule(path, ejbJarName);
                }
                messenger.setProgressLevel(90);
                messenger.setProgressLevel(100);
            }
            catch (AFTargetNotFoundException te) {
                throw new DeploymentException(te.getLocalizedMessage());
            }
            catch (DeploymentException de) {
                throw new DeploymentException(de.getLocalizedMessage());
            }
            catch (AFRuntimeStoreException afre) {
                messenger.ConfigXmlChanged(this.getName());
            }
        }
        catch (UnknownHostException e) {
            throw new DeploymentException(e.getLocalizedMessage());
        }
        catch (IOException con) {
            throw new DeploymentException(con.getLocalizedMessage());
        }
        return deploySuccess;
    }

    public boolean deployRARFile(String rarfilePath, UIMessenger messenger) throws DeploymentException {
        String path = rarfilePath;
        ServerModelIterator it = null;
        Reporter.info(rarfilePath);
        InetAddress IP = null;
        boolean deploySuccess = true;
        try {
            IP = InetAddress.getByName(this.getAdminHost());
            Socket s = new Socket(IP, this.getAdminPort());
            s.close();
            try {
                String rarName = path.substring(path.lastIndexOf(File.separator) + 1, path.lastIndexOf("."));
                Reporter.info("rar Name" + rarName);
                boolean exists = false;
                try {
                    it = this.getSelectedInstance().getDeployedConnectors();
                }
                catch (AFException e) {
                    throw new DeploymentException(e.getLocalizedMessage());
                }
                catch (AFRuntimeStoreException afre) {
                    throw new AFRuntimeStoreException(afre.getLocalizedMessage());
                }
                if (messenger != null) {
                    messenger.setProgressMessage(bundle.getString("ExsistingModuleCheck"));
                }
                if (messenger != null) {
                    messenger.setProgressLevel(30);
                }
                while (it.hasNext()) {
                    this.depName = it.next().toString();
                    if (!this.depName.equalsIgnoreCase(rarName)) continue;
                    exists = true;
                    break;
                }
                if (messenger != null) {
                    messenger.setProgressMessage(bundle.getString("DeployRar"));
                }
                if (exists) {
                    Reporter.info("Calling Redeploy");
                    if (messenger != null) {
                        messenger.setProgressMessage(bundle.getString("RedeployModuleMessage"));
                    }
                    deploySuccess = this.getSelectedInstance().redeployConnectorModule(path, rarName);
                } else {
                    Reporter.info("Calling Deploy");
                    if (messenger != null) {
                        messenger.setProgressMessage(bundle.getString("DeployModuleMessage"));
                    }
                    deploySuccess = this.getSelectedInstance().deployConnectorModule(path, rarName);
                }
                if (messenger != null) {
                    messenger.setProgressLevel(90);
                }
                if (messenger != null) {
                    messenger.setProgressLevel(100);
                }
            }
            catch (AFTargetNotFoundException te) {
                throw new DeploymentException(te.getLocalizedMessage());
            }
            catch (DeploymentException de) {
                throw new DeploymentException(de.getLocalizedMessage());
            }
            catch (AFRuntimeStoreException afre) {
                messenger.ConfigXmlChanged(this.getName());
            }
        }
        catch (UnknownHostException e) {
            throw new DeploymentException(e.getLocalizedMessage());
        }
        catch (IOException con) {
            throw new DeploymentException(con.getLocalizedMessage());
        }
        return deploySuccess;
    }

    public void registerDatasource(String xmlFile) throws DeploymentException {
    }

    private void initEngine() throws LoginFailureException {
    }

    public void removeEngineController() {
    }

    public void stopInstance(UIMessenger messenger) {
        try {
            Reporter.info("---------------------stopInstance");
            class StopThread
            extends Thread {
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ ServerInstance this$0;

                StopThread(ServerInstance this$0, UIMessenger val$messenger) {
                    this.this$0 = this$0;
                    this.val$messenger = val$messenger;
                }

                public void run() {
                    try {
                        if (ServerInstance.access$000(this.this$0).isRunning()) {
                            ServerInstance.access$000(this.this$0).stop();
                        }
                        Reporter.info("---------------------AFTER STOP-------------");
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (DeploymentException de) {
                        this.val$messenger.setNotify(de.getLocalizedMessage());
                    }
                    catch (InstanceNotRunningException inre) {
                        this.val$messenger.setNotify(inre.getLocalizedMessage());
                    }
                    catch (ControlException ce) {
                        this.val$messenger.setNotify(ce.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                }
            }
            StopThread stop_server = new StopThread(this, messenger);
            stop_server.start();
            Thread.sleep(500L);
            while (stop_server.isAlive()) {
                Thread.sleep(1000L);
            }
            Reporter.info("---------------------After stop server");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean stopInstance() throws AFTargetNotFoundException, InstanceNotRunningException, ControlException, AFException, DeploymentException {
        Reporter.info("---------------------STARTANYKJS");
        boolean status = false;
        if (this.getSelectedInstance().isRunning()) {
            status = this.getSelectedInstance().stop();
        }
        Reporter.info("---------------------AFTER START-------------");
        return status;
    }

    public void restart() {
        try {
            Reporter.info("---------------------RESTART");
            class RestartThread
            extends Thread {
                private final /* synthetic */ ServerInstance this$0;

                RestartThread(ServerInstance this$0) {
                    this.this$0 = this$0;
                }

                public void run() {
                    try {
                        ServerInstance.access$000(this.this$0).restart();
                        Reporter.info("---------------------AFTER RESTART-------------");
                    }
                    catch (AFTargetNotFoundException te) {
                        te.printStackTrace();
                    }
                    catch (DeploymentException de) {
                        de.printStackTrace();
                    }
                    catch (ControlException ce) {
                        ce.printStackTrace();
                    }
                    catch (AFException afe) {
                        afe.printStackTrace();
                    }
                }
            }
            RestartThread restart = new RestartThread(this);
            restart.start();
            Reporter.info("---------------------Ready after restart");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startInstance(UIMessenger messenger) {
        try {
            Reporter.info("---------------------STARTANYKJS");
            class StartThread
            extends Thread {
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ ServerInstance this$0;

                StartThread(ServerInstance this$0, UIMessenger val$messenger) {
                    this.this$0 = this$0;
                    this.val$messenger = val$messenger;
                }

                public void run() {
                    try {
                        if (!ServerInstance.access$000(this.this$0).isRunning()) {
                            ServerInstance.access$000(this.this$0).start();
                        }
                        Reporter.info("---------------------AFTER START-------------");
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (DeploymentException de) {
                        this.val$messenger.setNotify(de.getLocalizedMessage());
                    }
                    catch (InstanceAlreadyRunningException iare) {
                        this.val$messenger.setNotify(iare.getLocalizedMessage());
                    }
                    catch (ControlException ce) {
                        this.val$messenger.setNotify(ce.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                }
            }
            StartThread start_server = new StartThread(this, messenger);
            start_server.start();
            while (start_server.isAlive()) {
                Thread.sleep(1000L);
            }
            Reporter.info("---------------------Ready after start");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean startInstance() throws AFTargetNotFoundException, InstanceAlreadyRunningException, ControlException, AFException, DeploymentException {
        Reporter.info("---------------------STARTANYKJS");
        boolean status = false;
        if (!this.getSelectedInstance().isRunning()) {
            status = this.getSelectedInstance().start();
        }
        Reporter.info("---------------------AFTER START-------------");
        return status;
    }

    public boolean isRunning() throws AFException, AFTargetNotFoundException, DeploymentException, AFRuntimeStoreException {
        this.instRunning = false;
        this.instRunning = this.getSelectedInstance().isRunning();
        return this.instRunning;
    }

    public boolean isLocal() throws DeploymentException {
        try {
            String host = InetAddress.getLocalHost().getHostName();
            return host.equals(this.getHost());
        }
        catch (UnknownHostException e) {
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean isUp() {
        if (this.checkAlreadyDone) {
            return this.IAS_Running;
        }
        this.checkAlreadyDone = true;
        Timer aTimer = new Timer();
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ServerInstance.this.checkAlreadyDone = false;
                }
            }
        };
        aTimer.schedule(task, 2000L);
        return this.IAS_Running;
    }

    public static boolean ServName(String value, List serv, String nod_name, HostAndPort hostport, String uName, String passwd) {
        boolean exists = false;
        value = value + "(" + nod_name + ")";
        int i = 0;
        while (i < serv.size()) {
            IServerInstanceBean instance = (IServerInstanceBean)serv.get(i);
            String inst = instance.getName();
            if (inst.equals(value)) {
                exists = true;
            }
            ++i;
        }
        ServerModelIterator it = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(hostport, uName, passwd).getAllServerInstances();
        while (it.hasNext()) {
            String inst1 = ((AppServerInstance)it.next()).toString();
            if (!inst1.equals(value)) continue;
            exists = true;
        }
        return exists;
    }

    public void Undeploy(String resName, String resType, UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Before Undeploy ");
            class UndeployThread
            extends Thread {
                private final /* synthetic */ String val$resType;
                private final /* synthetic */ String val$resName;
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                UndeployThread(ServerInstance this$0, String val$resType, String val$resName, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$resType = val$resType;
                    this.val$resName = val$resName;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    try {
                        if (this.val$resType.trim().indexOf(".ear") != -1) {
                            ServerInstance.access$000(this.this$0).undeployApplication(this.val$resName);
                        } else if (this.val$resType.trim().indexOf(".war") != -1) {
                            ServerInstance.access$000(this.this$0).undeployModule(this.val$resName, 1002);
                        } else if (this.val$resType.trim().indexOf(".jar") != -1) {
                            ServerInstance.access$000(this.this$0).undeployModule(this.val$resName, 1003);
                        } else if (this.val$resType.trim().indexOf(".rar") != -1) {
                            ServerInstance.access$000(this.this$0).undeployModule(this.val$resName, 1004);
                        }
                        ServerInstance.access$000(this.this$0).applyChanges();
                        this.val$messenger.setStatusText(MessageFormat.format(bundle.getString("Msg_FinUndeploy"), this.val$server));
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                    catch (AFRuntimeStoreException afre) {
                        this.val$messenger.ConfigXmlChanged(this.val$server);
                    }
                }
            }
            UndeployThread undeploy = new UndeployThread(this, resType, resName, messenger, server);
            undeploy.start();
            Reporter.info("---------------------After Undeploy");
            while (undeploy.isAlive()) {
                Thread.sleep(500L);
            }
            Reporter.info("---------------------Finished Undeploy");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Apply(UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Applying changes to Server Instance");
            class ApplyThread
            extends Thread {
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                ApplyThread(ServerInstance this$0, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    try {
                        ServerInstance.access$000(this.this$0).applyChanges();
                        this.val$messenger.setStatusText(MessageFormat.format(bundle.getString("Msg_Applyed"), this.val$server));
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                    catch (AFRuntimeStoreException afre) {
                        this.val$messenger.ConfigXmlChanged(this.val$server);
                    }
                }
            }
            ApplyThread appl = new ApplyThread(this, messenger, server);
            appl.start();
            Reporter.info("---------------------After Applying changes to Server Instance");
            while (appl.isAlive()) {
                Thread.sleep(500L);
            }
            Reporter.info("---------------------Finished Applying changes to Server Instance");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Enable(String resName, String resType, UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Enabling Resource");
            class EnableThread
            extends Thread {
                private final /* synthetic */ String val$resType;
                private final /* synthetic */ String val$resName;
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                EnableThread(ServerInstance this$0, String val$resType, String val$resName, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$resType = val$resType;
                    this.val$resName = val$resName;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    try {
                        if (this.val$resType.trim().indexOf(".ear") != -1) {
                            DeployedApplicationComponentBean component = ServerInstance.access$000(this.this$0).getDeployedApplication(this.val$resName);
                            component.enable();
                        } else if (this.val$resType.trim().indexOf(".jar") != -1) {
                            DeployedEJBModuleComponentBean component = ServerInstance.access$000(this.this$0).getDeployedEJBModule(this.val$resName);
                            component.enable();
                        } else if (this.val$resType.trim().indexOf(".war") != -1) {
                            DeployedWebModuleComponentBean component = ServerInstance.access$000(this.this$0).getDeployedWebModule(this.val$resName);
                            component.enable();
                        } else {
                            Reporter.info("####### UNKNOWN Archive Type");
                        }
                        ServerInstance.access$000(this.this$0).applyChanges();
                        this.val$messenger.setStatusText(MessageFormat.format(bundle.getString("Msg_FinEnable"), this.val$server));
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                    catch (AFRuntimeStoreException afre) {
                        this.val$messenger.ConfigXmlChanged(this.val$server);
                    }
                }
            }
            EnableThread enThread = new EnableThread(this, resType, resName, messenger, server);
            enThread.start();
            Reporter.info("---------------------After Enabling Resource");
            while (enThread.isAlive()) {
                Thread.sleep(500L);
            }
            Reporter.info("---------------------Finished Enabling Resource");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Disable(String resName, String resType, UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Before Disabling Resource");
            class DisableThread
            extends Thread {
                private final /* synthetic */ String val$resType;
                private final /* synthetic */ String val$resName;
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                DisableThread(ServerInstance this$0, String val$resType, String val$resName, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$resType = val$resType;
                    this.val$resName = val$resName;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    try {
                        if (this.val$resType.trim().indexOf(".ear") != -1) {
                            DeployedApplicationComponentBean component = ServerInstance.access$000(this.this$0).getDeployedApplication(this.val$resName);
                            component.disable();
                        } else if (this.val$resType.trim().indexOf(".jar") != -1) {
                            DeployedEJBModuleComponentBean component = ServerInstance.access$000(this.this$0).getDeployedEJBModule(this.val$resName);
                            component.disable();
                        } else if (this.val$resType.trim().indexOf(".war") != -1) {
                            DeployedWebModuleComponentBean component = ServerInstance.access$000(this.this$0).getDeployedWebModule(this.val$resName);
                            component.disable();
                        } else {
                            Reporter.info("####### UNKNOWN Archive Type");
                        }
                        ServerInstance.access$000(this.this$0).applyChanges();
                        this.val$messenger.setStatusText(MessageFormat.format(bundle.getString("Msg_FinDisable"), this.val$server));
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                    catch (AFRuntimeStoreException afre) {
                        this.val$messenger.ConfigXmlChanged(this.val$server);
                    }
                }
            }
            DisableThread disThread = new DisableThread(this, resType, resName, messenger, server);
            disThread.start();
            Reporter.info("---------------------After Disabling Resource");
            while (disThread.isAlive()) {
                Thread.sleep(500L);
            }
            Reporter.info("---------------------Finished Disabling Resource");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled(String resName, String resType, UIMessenger messenger) {
        String server = this.getName();
        Reporter.info("---------------------Before checking if resource is enabled");
        try {
            if (resType.trim().indexOf(".ear") != -1) {
                DeployedApplicationComponentBean component = this.getSelectedInstance().getDeployedApplication(resName);
                this.isEnabled = component.isEnabled();
            } else if (resType.trim().indexOf(".war") != -1) {
                DeployedWebModuleComponentBean component = this.getSelectedInstance().getDeployedWebModule(resName);
                this.isEnabled = component.isEnabled();
            } else if (resType.trim().indexOf(".jar") != -1) {
                DeployedEJBModuleComponentBean component = this.getSelectedInstance().getDeployedEJBModule(resName);
                this.isEnabled = component.isEnabled();
            }
        }
        catch (AFTargetNotFoundException te) {
            messenger.setNotify(te.getLocalizedMessage());
        }
        catch (AFException afe) {
            messenger.setNotify(afe.getLocalizedMessage());
        }
        catch (AFRuntimeStoreException afre) {
            // empty catch block
        }
        Reporter.info("---------------------Finished checking if resource is enabled");
        return this.isEnabled;
    }

    public void deleteJdbc(String resourceName, UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Before deleting Jdbc");
            class DeleteJdbcThread
            extends Thread {
                private final /* synthetic */ String val$resourceName;
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                DeleteJdbcThread(ServerInstance this$0, String val$resourceName, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$resourceName = val$resourceName;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    try {
                        ServerInstance.access$000(this.this$0).deleteJDBCResource(this.val$resourceName);
                    }
                    catch (DeploymentException de) {
                        this.val$messenger.setNotify(de.getLocalizedMessage());
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                    catch (AFRuntimeStoreException afre) {
                        this.val$messenger.ConfigXmlChanged(this.val$server);
                    }
                }
            }
            DeleteJdbcThread delJdbc = new DeleteJdbcThread(this, resourceName, messenger, server);
            delJdbc.start();
            Reporter.info("---------------------After deleting Registered Jdbc ");
            while (delJdbc.isAlive()) {
            }
            this.getSelectedInstance().applyChanges();
            Reporter.info("---------------------Finished deleting Registered Jdbc");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteResource(String resourceName, String resType, UIMessenger messenger) {
        String server = this.getName();
        try {
            Reporter.info("---------------------Before deleting resource");
            class DeleteResourceThread
            extends Thread {
                private final /* synthetic */ String val$resType;
                private final /* synthetic */ String val$resourceName;
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ String val$server;
                private final /* synthetic */ ServerInstance this$0;

                DeleteResourceThread(ServerInstance this$0, String val$resType, String val$resourceName, UIMessenger val$messenger, String val$server) {
                    this.this$0 = this$0;
                    this.val$resType = val$resType;
                    this.val$resourceName = val$resourceName;
                    this.val$messenger = val$messenger;
                    this.val$server = val$server;
                }

                public void run() {
                    block10: {
                        try {
                            if (this.val$resType.equals("JDBC")) {
                                ServerInstance.access$000(this.this$0).deleteJDBCResource(this.val$resourceName);
                                break block10;
                            }
                            if (this.val$resType.equals("CP")) {
                                ServerInstance.access$000(this.this$0).deleteJDBCConnectionPool(this.val$resourceName);
                                break block10;
                            }
                            if (this.val$resType.equals("JMS")) {
                                ServerInstance.access$000(this.this$0).deleteJMSResource(this.val$resourceName);
                                break block10;
                            }
                            if (this.val$resType.equals("PMF")) {
                                ServerInstance.access$000(this.this$0).deletePersistenceManagerFactoryResource(this.val$resourceName);
                                break block10;
                            }
                            if (this.val$resType.equals("Mail")) {
                                ServerInstance.access$000(this.this$0).deleteJavaMailResource(this.val$resourceName);
                                break block10;
                            }
                            Reporter.error(bundle.getString("Err_NoResource"));
                        }
                        catch (DeploymentException de) {
                            this.val$messenger.setNotify(de.getLocalizedMessage());
                        }
                        catch (AFTargetNotFoundException te) {
                            this.val$messenger.setNotify(te.getLocalizedMessage());
                        }
                        catch (AFException afe) {
                            this.val$messenger.setNotify(afe.getLocalizedMessage());
                        }
                        catch (AFRuntimeStoreException afre) {
                            this.val$messenger.ConfigXmlChanged(this.val$server);
                        }
                    }
                }
            }
            DeleteResourceThread del = new DeleteResourceThread(this, resType, resourceName, messenger, server);
            del.start();
            Reporter.info("---------------------After deleting registered resource");
            while (del.isAlive()) {
            }
            this.getSelectedInstance().applyChanges();
            Reporter.info("---------------------Finished deleting Registered Resource");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int startInDebugMode(UIMessenger messenger) {
        this.debugPort = -1;
        try {
            Reporter.info("---------------------STARTANYKJS");
            class StartDebugThread
            extends Thread {
                private final /* synthetic */ UIMessenger val$messenger;
                private final /* synthetic */ ServerInstance this$0;

                StartDebugThread(ServerInstance this$0, UIMessenger val$messenger) {
                    this.this$0 = this$0;
                    this.val$messenger = val$messenger;
                }

                public void run() {
                    try {
                        if (!ServerInstance.access$000(this.this$0).isRunning()) {
                            ServerInstance.access$102(this.this$0, ServerInstance.access$000(this.this$0).startInDebugMode());
                        }
                        Reporter.info("---------------------AFTER START-------------");
                    }
                    catch (AFTargetNotFoundException te) {
                        this.val$messenger.setNotify(te.getLocalizedMessage());
                    }
                    catch (DeploymentException de) {
                        this.val$messenger.setNotify(de.getLocalizedMessage());
                    }
                    catch (InstanceAlreadyRunningException iare) {
                        this.val$messenger.setNotify(iare.getLocalizedMessage());
                    }
                    catch (ControlException ce) {
                        this.val$messenger.setNotify(ce.getLocalizedMessage());
                    }
                    catch (AFException afe) {
                        this.val$messenger.setNotify(afe.getLocalizedMessage());
                    }
                }
            }
            StartDebugThread debug_server = new StartDebugThread(this, messenger);
            debug_server.start();
            Thread.sleep(500L);
            while (debug_server.isAlive()) {
                Thread.sleep(1000L);
            }
            Reporter.info("---------------------Ready after start");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.debugPort;
    }

    public int startInDebugMode() throws AFTargetNotFoundException, DeploymentException, ControlException, InstanceAlreadyRunningException, AFException {
        this.debugPort = -1;
        Reporter.info("---------------------STARTANYKJS");
        if (!this.getSelectedInstance().isRunning()) {
            this.debugPort = this.getSelectedInstance().startInDebugMode();
        }
        Reporter.info("---------------------AFTER START-------------");
        return this.debugPort;
    }

    public void OverwriteConfig() throws AFException {
        this.getSelectedInstance().overwriteChanges();
    }

    public void useManualConfig() throws AFException {
        this.getSelectedInstance().useManualChanges();
    }

    public int getORBPort() throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException, DeploymentException, AFException {
        Integer portObj = (Integer)this.getSelectedInstance().getORBComponent().getIiopListener("orb-listener-1").getAttribute("port");
        int port = portObj;
        Reporter.verbose("getORBPort() returns " + port);
        return port;
    }

    public int getJPDAPortNumber() throws AFException {
        int p = this.getSelectedInstance().getServerStatus().getDebugPort();
        Reporter.verbose("getJPDAPortNumber() returns " + p);
        return p;
    }

    static /* synthetic */ AppServerInstance access$000(ServerInstance x0) throws DeploymentException, AFTargetNotFoundException {
        return x0.getSelectedInstance();
    }

    static /* synthetic */ int access$102(ServerInstance x0, int x1) {
        x0.debugPort = x1;
        return x0.debugPort;
    }

    static {
        bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.common.deploy.Bundle");
    }
}

