/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.BaseValidator;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.admin.util.ValidatorResult;

public class StringValidator
extends BaseValidator {
    private final int mMininumLength;
    private static final int kDefaultMinimumLength = 1;
    private static StringValidator sDefaultInstance = null;
    private static final String badArgMessage = "You can't call StringValidator.validate() with a non-String argument";

    public StringValidator(int minimumLength) {
        Assert.assertRange(minimumLength, 0, Integer.MAX_VALUE, (Object)"minimumLength");
        this.mMininumLength = minimumLength;
    }

    public static Validator getInstance() {
        if (sDefaultInstance == null) {
            sDefaultInstance = new StringValidator(1);
        }
        return sDefaultInstance;
    }

    public ValidatorResult validate(Object obj) {
        ValidatorResult result = super.validate(obj);
        if (result.isValid()) {
            Assert.assertit(obj instanceof String, badArgMessage);
            String str = (String)obj;
            int len = str.length();
            if (len < this.mMininumLength) {
                result = this.makeBadResult(len);
            }
        }
        return result;
    }

    private ValidatorResult makeBadResult(int len) {
        return new ValidatorResult(false, "The String argument is invalid.  The minimum required length is " + this.mMininumLength + " and the String's actual length is " + len);
    }
}

