/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyExistsException;
import com.iplanet.ias.admin.common.exception.NoSuchInstanceException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.context.AdminContext;
import com.iplanet.ias.admin.servermodel.context.AuthenticationContext;
import com.iplanet.ias.admin.servermodel.context.Context;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.AdminController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.AttributeList;

public class ServerInstanceManager
implements Controllable {
    public static final String HTTP = "http";
    private HostAndPort adminHostAndPort;
    private ContextHolder ctxHolder;
    private transient AdminController controller;

    ServerInstanceManager() {
        this.initialize();
        AdminContext adminCtx = new AdminContext();
        this.ctxHolder.put(adminCtx);
    }

    ServerInstanceManager(HostAndPort adminHostAndPort) {
        ArgChecker.checkValid(adminHostAndPort, "adminHostAndPort");
        this.initialize();
        this.adminHostAndPort = adminHostAndPort;
        AdminContext ctx = new AdminContext(adminHostAndPort);
        this.ctxHolder.put(ctx);
    }

    ServerInstanceManager(HostAndPort adminHostAndPort, String user, String password) {
        ArgChecker.checkValid(adminHostAndPort, "adminHostAndPort");
        ArgChecker.checkValid(user, "user", StringValidator.getInstance());
        ArgChecker.checkValid(password, "password", StringValidator.getInstance());
        this.initialize();
        this.adminHostAndPort = adminHostAndPort;
        AdminContext ctx = new AdminContext(adminHostAndPort);
        this.ctxHolder.put(ctx);
        AuthenticationContext authCtx = new AuthenticationContext(user, password);
        this.ctxHolder.put(authCtx);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        boolean isEqual = false;
        if (o instanceof ServerInstanceManager) {
            ServerInstanceManager that = (ServerInstanceManager)o;
            ContextHolder ch1 = that.getContextHolder();
            ContextHolder ch2 = this.getContextHolder();
            AdminContext admCtx2 = ch2.getAdminContext();
            AdminContext admCtx1 = ch1.getAdminContext();
            boolean isAdmCtxEqual = admCtx1 != null ? admCtx1.equals(admCtx2) : admCtx2 == null;
            AuthenticationContext authCtx2 = ch2.getAuthenticationContext();
            AuthenticationContext authCtx1 = ch1.getAuthenticationContext();
            boolean isAuthCtxEqual = authCtx2 != null ? authCtx2.equals(authCtx1) : authCtx1 == null;
            isEqual = isAuthCtxEqual && isAdmCtxEqual;
        }
        return isEqual;
    }

    public Controller getController() {
        return this.controller;
    }

    public synchronized void setContextHolder(ContextHolder ctxHolder) {
        ArgChecker.checkValid(ctxHolder, "ctxHolder");
        if (ctxHolder != null) {
            ctxHolder = new ContextHolder();
            Context ctx = ctxHolder.getAdminContext();
            ctxHolder.put(ctx);
            ctx = ctxHolder.getAuthenticationContext();
            ctxHolder.put(ctx);
        }
    }

    public synchronized ContextHolder getContextHolder() {
        return this.ctxHolder;
    }

    public HostAndPort getAdminHostAndPort() {
        return this.adminHostAndPort;
    }

    public String getProtocol() {
        return HTTP;
    }

    public boolean handlesURL(URL url) {
        HostAndPort hAndp = new HostAndPort(url.getHost(), url.getPort());
        return this.adminHostAndPort.equals(hAndp);
    }

    public boolean handlesURL(String urlString) throws MalformedURLException {
        return this.handlesURL(new URL(urlString));
    }

    public AppServerInstance getServerInstance(String name) throws AFTargetNotFoundException {
        return this.controller.getServerInstance(name);
    }

    public ServerModelIterator getAllServerInstances() {
        return this.controller.getAllServerInstances();
    }

    public AppServerInstance createServerInstance(HostAndPort hAndp, String name) throws InstanceAlreadyExistsException, ControlException {
        return this.createServerInstance(hAndp, name, null);
    }

    public AppServerInstance createServerInstance(HostAndPort hAndp, String name, String runAsUser) throws InstanceAlreadyExistsException, ControlException {
        return this.controller.createServerInstance(hAndp, name, runAsUser);
    }

    public AppServerInstance createServerInstance(HostAndPort hAndp, String name, String mailHost, String user, String docRoot, int jmsPort, String jmsUser, String jmsPasswd) throws InstanceAlreadyExistsException, ControlException {
        return this.controller.createServerInstance(hAndp, name, mailHost, user, docRoot, jmsPort, jmsUser, jmsPasswd);
    }

    public boolean deleteServerInstance(String name) throws NoSuchInstanceException, ControlException {
        return this.controller.deleteServerInstance(name);
    }

    public boolean deleteServerInstance(AppServerInstance serverInstance) throws NoSuchInstanceException, ControlException {
        return this.deleteServerInstance(serverInstance.getName());
    }

    public AttributeList getGenericAttributes(String[] attributeNames) throws AFTargetNotFoundException, AttributeNotFoundException {
        return this.controller.getGenericAttributes(attributeNames);
    }

    public AttributeList getGenericAttributeDefaultValues(String instanceName, String configMBeanType, String[] attributes) throws AFTargetNotFoundException {
        return this.controller.getGenericAttributeDefaultValues(instanceName, configMBeanType, attributes);
    }

    public String[] listGenericDottedNameContinuiations(String dottedNamePrefix) throws AFTargetNotFoundException {
        return this.controller.listGenericDottedNameContinuiations(dottedNamePrefix);
    }

    public AttributeList setGenericAttributes(AttributeList al) throws AFTargetNotFoundException {
        return this.controller.setGenericAttributes(al);
    }

    public String[] listMonitorableComponents(String parent) throws AFException {
        return this.controller.listMonitorableComponents(parent);
    }

    public AttributeList getMonitorAttributes(String[] attributes) throws AFException {
        return this.controller.getMonitorAttributes(attributes);
    }

    public AttributeList setMonitorAttributes(AttributeList attributes) throws AFException {
        return this.controller.setMonitorAttributes(attributes);
    }

    public AppServerInstance getDefaultServerInstance() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void setDefaultServerInstance(String name) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void setDefaultServerInstance(AppServerInstance serverInstance) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public String getVersion() throws AFException {
        return this.controller.getVersion();
    }

    public String getFullVersion() throws AFException {
        return this.controller.getFullVersion();
    }

    public void stopServer() throws AFException {
        this.controller.stopServer();
    }

    public String uploadFile(String filePath) throws Exception {
        return this.controller.uploadFile(filePath);
    }

    public void deployApplication(String filePath, AppServerInstance[] targets) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public AppServerInstance getAdminInstance() throws AFException {
        return this.controller.getAdminInstance();
    }

    public void setAuthenticationContext(String user, String password) {
        AuthenticationContext authCtx = new AuthenticationContext(user, password);
        this.ctxHolder.put(authCtx);
    }

    private void initialize() {
        this.controller = new AdminController(this);
        this.ctxHolder = new ContextHolder();
    }

    public DomainEntry[] listDomains() throws AFException {
        return this.controller.listDomains();
    }

    public void stopDomain(boolean stopAdmin) throws AFException {
        this.controller.stopDomain(stopAdmin);
    }

    public String getLicenseInfo() throws AFException {
        String licenseInfo = this.controller.getLicenseInfo();
        return licenseInfo;
    }
}

