/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.Util;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public abstract class Generator
implements sun.rmi.rmic.Generator,
Constants {
    protected boolean alwaysGenerate = false;
    protected BatchEnvironment env = null;
    protected ContextStack contextStack = null;
    private boolean trace = false;
    protected boolean idl = false;

    public boolean parseArgs(String[] stringArray, Main main) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                if (stringArray[n].equalsIgnoreCase("-always") || stringArray[n].equalsIgnoreCase("-alwaysGenerate")) {
                    this.alwaysGenerate = true;
                    stringArray[n] = null;
                } else if (stringArray[n].equalsIgnoreCase("-xtrace")) {
                    this.trace = true;
                    stringArray[n] = null;
                }
            }
            ++n;
        }
        return true;
    }

    protected abstract boolean parseNonConforming(ContextStack var1);

    protected abstract CompoundType getTopType(ClassDefinition var1, ContextStack var2);

    protected abstract OutputType[] getOutputTypesFor(CompoundType var1, HashSet var2);

    protected abstract String getFileNameExtensionFor(OutputType var1);

    protected abstract void writeOutputFor(OutputType var1, HashSet var2, IndentingWriter var3) throws IOException;

    protected abstract boolean requireNewInstance();

    public boolean requiresGeneration(File file, Type type) {
        boolean bl = this.alwaysGenerate;
        if (!bl) {
            String string;
            ClassPath classPath = this.env.getClassPath();
            ClassFile classFile = classPath.getFile((string = type.getQualifiedName().replace('.', File.separatorChar)) + ".source");
            if (classFile == null) {
                classFile = classPath.getFile(string + ".class");
            }
            if (classFile != null) {
                long l;
                long l2 = classFile.lastModified();
                String string2 = IDLNames.replace(file.getName(), ".java", ".class");
                String string3 = file.getParent();
                File file2 = new File(string3, string2);
                bl = file2.exists() ? (l = file2.lastModified()) < l2 : true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    protected Generator newInstance() {
        Generator generator = null;
        try {
            generator = (Generator)this.getClass().newInstance();
        }
        catch (Exception exception) {}
        return generator;
    }

    protected Generator() {
    }

    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        this.env = (BatchEnvironment)batchEnvironment;
        this.contextStack = new ContextStack(this.env);
        this.contextStack.setTrace(this.trace);
        this.env.setParseNonConforming(this.parseNonConforming(this.contextStack));
        CompoundType compoundType = this.getTopType(classDefinition, this.contextStack);
        if (compoundType != null) {
            Generator generator = this;
            if (this.requireNewInstance()) {
                generator = this.newInstance();
            }
            generator.generateOutputFiles(compoundType, this.env, file);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void generateOutputFiles(CompoundType var1_1, BatchEnvironment var2_2, File var3_3) {
        var4_4 = var2_2.alreadyChecked;
        var5_5 = this.getOutputTypesFor(var1_1, var4_4);
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            var7_7 = var5_5[var6_6];
            var8_8 = var7_7.getName();
            var9_9 = this.getFileFor(var7_7, var3_3);
            var10_10 = false;
            if (this.requiresGeneration(var9_9, var7_7.getType())) {
                if (var9_9.getName().endsWith(".java") && (var10_10 = this.compileJavaSourceFile(var7_7))) {
                    var2_2.addGeneratedFile(var9_9);
                }
                try {
                    var11_11 = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(var9_9)), 4, 0x7FFFFFFF);
                    var12_13 = 0L;
                    if (var2_2.verbose()) {
                        var12_13 = System.currentTimeMillis();
                    }
                    this.writeOutputFor(var5_5[var6_6], var4_4, var11_11);
                    var11_11.close();
                    if (var2_2.verbose()) {
                        var14_14 = System.currentTimeMillis() - var12_13;
                        var2_2.output(Main.getText("rmic.generated", var9_9.getPath(), Long.toString(var14_14)));
                    }
                    if (!var10_10) ** GOTO lbl30
                    var2_2.parseFile(new ClassFile(var9_9));
                }
                catch (IOException var11_12) {
                    var2_2.error(0L, "cant.write", var9_9.toString());
                    return;
                }
            } else if (var2_2.verbose()) {
                var2_2.output(Main.getText("rmic.previously.generated", var9_9.getPath()));
            }
lbl30:
            // 5 sources

            ++var6_6;
        }
    }

    protected File getFileFor(OutputType outputType, File file) {
        Identifier identifier = this.getOutputId(outputType);
        File file2 = null;
        file2 = this.idl ? Util.getOutputDirectoryForIDL(identifier, file, this.env) : Util.getOutputDirectoryForStub(identifier, file, this.env);
        String string = outputType.getName() + this.getFileNameExtensionFor(outputType);
        return new File(file2, string);
    }

    protected Identifier getOutputId(OutputType outputType) {
        return outputType.getType().getIdentifier();
    }

    protected boolean compileJavaSourceFile(OutputType outputType) {
        return true;
    }

    public class OutputType {
        private String name;
        private Type type;

        public OutputType(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

