/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import com.iplanet.ias.loader.JasperAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.loader.ContextNotifier;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;

public final class StandardLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
Runnable {
    private int checkInterval = 15;
    private Reloader classLoader = null;
    private Container container = null;
    private int debug = 0;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.StandardLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.StandardClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardLoader";

    public StandardLoader() {
        this(null);
    }

    public StandardLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", new Integer(n2), new Integer(this.checkInterval));
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)((Object)this.classLoader);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        boolean bl2 = this.delegate;
        this.delegate = bl;
        this.support.firePropertyChange("delegate", new Boolean(bl2), new Boolean(this.delegate));
    }

    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass() {
        this.loaderClass = this.loaderClass;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", new Boolean(bl2), new Boolean(this.reloadable));
        if (!this.started) {
            return;
        }
        if (!bl2 && this.reloadable) {
            this.threadStart();
        } else if (bl2 && !this.reloadable) {
            this.threadStop();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addRepository(String string) {
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.addRepository", string));
        }
        int n = 0;
        while (n < this.repositories.length) {
            if (string.equals(this.repositories[n])) {
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.repositories.length + 1];
        int n2 = 0;
        while (n2 < this.repositories.length) {
            stringArray[n2] = this.repositories[n2];
            ++n2;
        }
        stringArray[this.repositories.length] = string;
        this.repositories = stringArray;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(string);
            this.setClassPath();
        }
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public boolean modified() {
        return this.classLoader.modified();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardLoader[");
        if (this.container != null) {
            stringBuffer.append(this.container.getName());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardLoader.alreadyStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        DirContextURLStreamHandlerFactory dirContextURLStreamHandlerFactory = new DirContextURLStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory(dirContextURLStreamHandlerFactory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setRepositories();
        try {
            this.classLoader = this.parentClassLoader == null ? new StandardClassLoader() : new StandardClassLoader(this.parentClassLoader);
            ((StandardClassLoader)this.classLoader).setDebug(this.debug);
            int n = 0;
            while (n < this.repositories.length) {
                this.classLoader.addRepository(this.repositories[n]);
                ++n;
            }
            ((StandardClassLoader)this.classLoader).setDelegate(this.delegate);
            if (this.container instanceof Context) {
                ServletContext servletContext = ((Context)this.container).getServletContext();
                try {
                    String string;
                    URL uRL = servletContext.getResource("/");
                    if (uRL != null) {
                        ((StandardClassLoader)this.classLoader).setPermissions(uRL);
                        string = "jar:" + uRL.toString() + "WEB-INF/lib/";
                        ((StandardClassLoader)this.classLoader).setPermissions(string);
                    }
                    if ((string = servletContext.getRealPath("/")) != null) {
                        ((StandardClassLoader)this.classLoader).setPermissions(string);
                        String string2 = "file:" + string;
                        ((StandardClassLoader)this.classLoader).setPermissions(string2);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.classLoader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.classLoader)).start();
            }
            DirContextURLStreamHandler.bind((ClassLoader)((Object)this.classLoader), this.container.getResources());
        }
        catch (Throwable throwable) {
            throw new LifecycleException("start: ", throwable);
        }
        this.validatePackages();
        this.setJasperEnvironment();
        if (this.reloadable) {
            this.log(sm.getString("standardLoader.reloading"));
            try {
                this.threadStart();
            }
            catch (IllegalStateException illegalStateException) {
                throw new LifecycleException(illegalStateException);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardLoader.notStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.reloadable) {
            this.threadStop();
        }
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.classloader");
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.classLoader)).stop();
        }
        this.classLoader = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block3: {
            if (!(propertyChangeEvent.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)propertyChangeEvent.getSource();
            if (!propertyChangeEvent.getPropertyName().equals("reloadable")) break block3;
            try {
                this.setReloadable((Boolean)propertyChangeEvent.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("standardLoader.reloadable", propertyChangeEvent.getNewValue().toString()));
            }
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardLoader[" + this.container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("StandardLoader[" + string2 + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardLoader[" + this.container.getName() + "] " + string, throwable);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("StandardLoader[" + string2 + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void notifyContext() {
        ContextNotifier contextNotifier = new ContextNotifier((Context)this.container);
        new Thread(contextNotifier).start();
    }

    private void setJasperEnvironment() {
        this.setClassLoader();
        this.setClassPath();
        this.copyClassesRepository();
    }

    private void copyClassesRepository() {
        Object object;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        String string = (String)servletContext.getAttribute("org.apache.catalina.jsp_classpath");
        if (string == null) {
            string = "";
        }
        DirContext dirContext = this.container.getResources();
        String string2 = "/WEB-INF/classes";
        try {
            object = dirContext.lookup(string2);
            if (!(object instanceof DirContext)) {
                return;
            }
            dirContext = (DirContext)object;
        }
        catch (NamingException namingException) {
            return;
        }
        object = servletContext.getRealPath(string2);
        if (object != null) {
            if (!string.equals("")) {
                string = File.pathSeparator + string;
            }
            string = (String)object + string;
        } else {
            File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (file != null) {
                if (!string.equals("")) {
                    string = File.pathSeparator + string;
                }
                File file2 = new File(file, string2);
                file2.mkdirs();
                string = file2.getAbsolutePath() + string;
                this.copyDir(dirContext, file2);
            }
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)string);
        if (servletContext instanceof ApplicationContext) {
            ((ApplicationContext)servletContext).setAttributeReadOnly("org.apache.catalina.jsp_classpath");
        }
    }

    private boolean copyDir(DirContext dirContext, File file) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list("");
            while (namingEnumeration.hasMoreElements()) {
                Closeable closeable;
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string = nameClassPair.getName();
                Object object = dirContext.lookup(string);
                File file2 = new File(file, string);
                if (object instanceof Resource) {
                    FileOutputStream fileOutputStream;
                    closeable = ((Resource)object).streamContent();
                    if (this.copy((InputStream)closeable, fileOutputStream = new FileOutputStream(file2))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    closeable = new FileOutputStream(file2);
                    if (this.copy((InputStream)object, (OutputStream)closeable)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                file2.mkdir();
                this.copyDir((DirContext)object, file2);
            }
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void setClassLoader() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        servletContext.setAttribute("org.apache.catalina.classloader", (Object)this.getClassLoader());
        if (servletContext instanceof ApplicationContext) {
            ((ApplicationContext)servletContext).setAttributeReadOnly("org.apache.catalina.classloader");
        }
    }

    private void setClassPath() {
        String string;
        URL[] uRLArray;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ClassLoader classLoader = this.getClassLoader();
        int n = 0;
        int n2 = 0;
        while (n < 10 && classLoader != null) {
            uRLArray = null;
            if (classLoader instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)classLoader).getURLs();
            } else {
                if (!(classLoader instanceof JasperAdapter)) break;
                uRLArray = ((JasperAdapter)((Object)classLoader)).getURLs();
            }
            int n3 = 0;
            while (n3 < uRLArray.length) {
                block31: {
                    block29: {
                        block30: {
                            block28: {
                                string = uRLArray[n3].toString();
                                if (!string.startsWith("file://")) break block28;
                                string = string.substring(7);
                                break block29;
                            }
                            if (!string.startsWith("file:")) break block30;
                            string = string.substring(5);
                            break block29;
                        }
                        if (!string.startsWith("jndi:")) break block31;
                        string = servletContext.getRealPath(string.substring(5));
                    }
                    if (string != null && !string.endsWith("/")) {
                        if (n2 > 0) {
                            stringBuffer.append(File.pathSeparator);
                        }
                        stringBuffer.append(string);
                        ++n2;
                    }
                }
                ++n3;
            }
            classLoader = classLoader.getParent();
            ++n;
        }
        if ((uRLArray = (URL[])servletContext.getAttribute("javax.servlet.context.tempdir")) != null) {
            NamingEnumeration<NameClassPair> namingEnumeration;
            DirContext dirContext = this.container.getResources();
            string = "/WEB-INF/lib";
            File file = new File((File)uRLArray, string);
            if (servletContext.getRealPath(string) == null) {
                file.mkdirs();
            }
            DirContext dirContext2 = null;
            try {
                namingEnumeration = dirContext.lookup(string);
                if (namingEnumeration instanceof DirContext) {
                    dirContext2 = (DirContext)((Object)namingEnumeration);
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (dirContext2 != null) {
                try {
                    namingEnumeration = dirContext.list(string);
                    while (namingEnumeration.hasMoreElements()) {
                        NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                        String string2 = nameClassPair.getName();
                        if (!string2.endsWith(".jar")) continue;
                        String string3 = servletContext.getRealPath(string + "/" + string2);
                        if (string3 != null) {
                            if (n2 > 0) {
                                stringBuffer.append(File.pathSeparator);
                            }
                            ++n2;
                            stringBuffer.append(string3);
                            continue;
                        }
                        try {
                            URL uRL = servletContext.getResource(string + "/" + string2);
                            this.log(" Adding 'file: " + string + "/" + string2 + "'");
                            File file2 = new File(file, string2);
                            if (!this.copy(uRL.openStream(), new FileOutputStream(file2))) continue;
                            if (n2 > 0) {
                                stringBuffer.append(File.pathSeparator);
                            }
                            ++n2;
                            stringBuffer.append(file2.getAbsolutePath());
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)stringBuffer.toString());
    }

    private boolean copy(InputStream inputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void setRepositories() {
        Object object;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        URL uRL = null;
        try {
            uRL = servletContext.getResource("/WEB-INF/classes");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        if (uRL != null) {
            int n;
            object = uRL.toString();
            if (((String)object).indexOf(92) >= 0) {
                object = ((String)object).replace('\\', '/');
            }
            while ((n = ((String)object).indexOf("/./")) >= 0) {
                object = ((String)object).substring(0, n) + ((String)object).substring(n + 2);
            }
            while ((n = ((String)object).indexOf("/../")) > 0) {
                int n2 = ((String)object).lastIndexOf(47, n - 1);
                object = ((String)object).substring(0, n2) + ((String)object).substring(n + 3);
            }
            this.addRepository((String)object + "/");
        }
        object = this.container.getResources();
        String string = "/WEB-INF/lib";
        Object var5_8 = null;
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = object.list(string);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string2 = string + "/" + nameClassPair.getName();
                if (!string2.endsWith(".jar")) continue;
                try {
                    URL uRL2 = servletContext.getResource(string2);
                    uRL2 = new URL("jar:" + uRL2.toString() + "!/");
                    this.addRepository(uRL2.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (NamingException namingException) {}
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (!this.reloadable) {
            throw new IllegalStateException(sm.getString("standardLoader.notReloadable"));
        }
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException(sm.getString("standardLoader.notContext"));
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "StandardLoader[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private void validatePackages() throws LifecycleException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader instanceof StandardClassLoader) {
            Extension[] extensionArray = ((StandardClassLoader)classLoader).findAvailable();
            Extension[] extensionArray2 = ((StandardClassLoader)classLoader).findRequired();
            if (this.debug >= 1) {
                this.log("Optional Packages:  available=" + extensionArray.length + ", required=" + extensionArray2.length);
            }
            int n = 0;
            while (n < extensionArray2.length) {
                if (this.debug >= 1) {
                    this.log("Checking for required package " + extensionArray2[n]);
                }
                boolean bl = false;
                int n2 = 0;
                while (n2 < extensionArray.length) {
                    if (extensionArray[n2].isCompatibleWith(extensionArray2[n])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    throw new LifecycleException("Missing optional package " + extensionArray2[n]);
                }
                ++n;
            }
        }
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        DirContextURLStreamHandler.bindThread(this.container.getResources());
        while (!this.threadDone) {
            this.threadSleep();
            if (!this.classLoader.modified()) continue;
            this.notifyContext();
            break;
        }
        DirContextURLStreamHandler.unbindThread();
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }
}

