/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.util.Enumerator;

final class ApplicationFilterConfig
implements FilterConfig {
    private Context context = null;
    private Filter filter = null;
    private FilterDef filterDef = null;

    public ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getInitParameter(String string) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(string);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(new ArrayList(map.keySet()));
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ApplicationFilterConfig[");
        stringBuffer.append("name=");
        stringBuffer.append(this.filterDef.getFilterName());
        stringBuffer.append(", filterClass=");
        stringBuffer.append(this.filterDef.getFilterClass());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        if (this.filter != null) {
            return this.filter;
        }
        String string = this.filterDef.getFilterClass();
        ClassLoader classLoader = null;
        classLoader = string.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        this.filter = (Filter)clazz.newInstance();
        this.filter.init((FilterConfig)this);
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            this.filter.destroy();
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                this.filter.destroy();
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }
}

