/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;

public final class WebContainerListener
implements ContainerListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    public static final boolean debug = false;
    private static HashSet beforeEvents = new HashSet();
    private static HashSet afterEvents = new HashSet();
    private InvocationManager im;

    public void containerEvent(ContainerEvent containerEvent) {
        String string = containerEvent.getType();
        if (beforeEvents.contains(string)) {
            this.preInvoke((Context)containerEvent.getContainer());
        } else if (afterEvents.contains(string)) {
            this.postInvoke((Context)containerEvent.getContainer());
        }
    }

    private void preInvoke(Context context) {
        final ClassLoader classLoader = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
        ComponentInvocation componentInvocation = new ComponentInvocation();
        componentInvocation.instance = null;
        componentInvocation.container = context;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.preInvoke(componentInvocation);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web_server.excep_preinvoke_web_cont_listener", exception);
        }
    }

    private void postInvoke(Context context) {
        ComponentInvocation componentInvocation = new ComponentInvocation();
        componentInvocation.instance = null;
        componentInvocation.container = context;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.postInvoke(componentInvocation);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web_server.excep_postinvoke_web_cont_listener", exception);
        }
    }

    static {
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        beforeEvents.add("beforeSessionValueUnbound");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
        afterEvents.add("afterSessionValueUnbound");
    }
}

