/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class BeanMethodCalculator {
    private static final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private static final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private static final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private static final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private static Map disallowedMethodsPerInterface;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;

    public static String getMethodIntfFor(String string, ClassLoader classLoader, EjbDescriptor ejbDescriptor) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = classLoader.loadClass(string);
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            clazz2 = classLoader.loadClass(ejbDescriptor.getHomeClassName());
            clazz = classLoader.loadClass(ejbDescriptor.getRemoteClassName());
            if (clazz3.isAssignableFrom(clazz2)) {
                return MethodDescriptor.EJB_HOME;
            }
            if (clazz3.isAssignableFrom(clazz)) {
                return MethodDescriptor.EJB_REMOTE;
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            clazz2 = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
            clazz = classLoader.loadClass(ejbDescriptor.getLocalClassName());
            if (clazz3.isAssignableFrom(clazz2)) {
                return MethodDescriptor.EJB_LOCALHOME;
            }
            if (clazz3.isAssignableFrom(clazz)) {
                return MethodDescriptor.EJB_LOCAL;
            }
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor && clazz3.isAssignableFrom(clazz2 = classLoader.loadClass(ejbDescriptor.getEjbClassName()))) {
            return MethodDescriptor.EJB_BEAN;
        }
        return null;
    }

    public static Vector getMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector vector = new Vector();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        return vector;
    }

    private static void addAllInterfaceMethodsIn(Collection collection, Class clazz) {
        collection.addAll(Arrays.asList(clazz.getMethods()));
    }

    public static Collection getTransactionalMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector vector = new Vector();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Collection collection;
            if (ejbDescriptor.getHomeClassName() != null) {
                collection = BeanMethodCalculator.extractDisallowedMethodsFor(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, sessionBeanMethodsDisallowed);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(classLoader, ejbDescriptor.getRemoteClassName(), collection));
            }
            if (ejbDescriptor.getLocalHomeClassName() != null) {
                collection = BeanMethodCalculator.extractDisallowedMethodsFor(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, sessionLocalBeanMethodsDisallowed);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(classLoader, ejbDescriptor.getLocalClassName(), collection));
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            String string = ejbDescriptor.getHomeClassName();
            if (string != null) {
                object3 = classLoader.loadClass(string);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = BeanMethodCalculator.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome, (Class)object3));
                object2 = ejbDescriptor.getRemoteClassName();
                object = classLoader.loadClass((String)object2);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, (Class)object));
            }
            if ((object3 = ejbDescriptor.getLocalHomeClassName()) != null) {
                object2 = classLoader.loadClass((String)object3);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = BeanMethodCalculator.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome, object2));
                object = ejbDescriptor.getLocalClassName();
                Class<?> clazz = classLoader.loadClass((String)object);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, clazz));
            }
        }
        return vector;
    }

    private static Collection getTransactionMethodsFor(ClassLoader classLoader, String string, Collection collection) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(string);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz, collection);
    }

    private static Collection getTransactionMethodsFor(Class clazz, Collection collection) {
        Vector<Method> vector = new Vector<Method>(Arrays.asList(clazz.getMethods()));
        vector.removeAll(collection);
        return vector;
    }

    private static Collection getTransactionMethodsFor(Class clazz, Class clazz2) {
        Collection collection = BeanMethodCalculator.getDisallowedTransactionMethodsFor(clazz);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz2, collection);
    }

    private static Collection getDisallowedTransactionMethodsFor(Class clazz) {
        return BeanMethodCalculator.extractDisallowedMethodsFor(clazz, BeanMethodCalculator.getDisallowedMethodsNamesFor(clazz));
    }

    private static Collection extractDisallowedMethodsFor(Class clazz, String[] stringArray) {
        Vector<Method> vector = new Vector<Method>();
        if (stringArray.length == 0) {
            return vector;
        }
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (stringArray[0].equals("*")) {
                vector.addElement(methodArray[n]);
            } else if (Arrays.binarySearch(stringArray, methodArray[n].getName()) >= 0) {
                vector.addElement(methodArray[n]);
            }
            ++n;
        }
        return vector;
    }

    private static String[] getDisallowedMethodsNamesFor(Class clazz) {
        return (String[])BeanMethodCalculator.getDisallowedMethodsNames().get(clazz);
    }

    protected static Map getDisallowedMethodsNames() {
        if (disallowedMethodsPerInterface == null) {
            disallowedMethodsPerInterface = new Hashtable();
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = BeanMethodCalculator.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome, entityBeanHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, entityBeanRemoteMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = BeanMethodCalculator.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome, entityBeanLocalHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, entityBeanLocalInterfaceMethodsDisallowed);
        }
        return disallowedMethodsPerInterface;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

