/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.net.ssl.X509KeyManager;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public final class J2EEKeyManager
implements X509KeyManager {
    private static Logger _logger = null;
    private static boolean debug;
    public static final String SELECT_CERT = "com.sun.enterprise.selectCert";
    public static final String CERT_ALIAS = "com.sun.enterprise.certAlias";
    private static LocalStringManagerImpl localStrings;
    private X509KeyManager mgr = null;
    static /* synthetic */ Class class$com$sun$enterprise$security$J2EEKeyManager;

    public J2EEKeyManager(X509KeyManager x509KeyManager) {
        this.mgr = x509KeyManager;
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        String string2;
        if (debug) {
            _logger.log(Level.FINE, "Choose client Alias for keytype:" + string);
        }
        if ((string2 = System.getProperty(SELECT_CERT)) == null) {
            return this.mgr.chooseClientAlias(string, principalArray);
        }
        if (string2.equalsIgnoreCase("false")) {
            return this.mgr.chooseClientAlias(string, principalArray);
        }
        String string3 = System.getProperty(CERT_ALIAS);
        if (string3 != null) {
            return string3;
        }
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            return this.mgr.chooseClientAlias(string, principalArray);
        }
        ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        Object object = componentInvocation.getContainerContext();
        if (object != null && object instanceof AppContainer) {
            ClientSecurityContext clientSecurityContext = ClientSecurityContext.getCurrent();
            Subject subject = clientSecurityContext.getSubject();
            if (subject == null) {
                LoginContextDriver.doClientLogin(2, AppContainer.handler);
                subject = clientSecurityContext.getSubject();
            }
            Iterator<Object> iterator = subject.getPrivateCredentials().iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (!(object2 instanceof X509CertificateCredential)) continue;
                X509CertificateCredential x509CertificateCredential = (X509CertificateCredential)object2;
                String string4 = x509CertificateCredential.getAlias();
                return string4;
            }
        }
        return this.mgr.chooseClientAlias(string, principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        if (debug) {
            _logger.log(Level.FINE, "Choose server Alias for keytype:" + string);
        }
        return this.mgr.chooseServerAlias(string, principalArray);
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (debug) {
            _logger.log(Level.FINE, "Getting certificate chain");
        }
        return this.mgr.getCertificateChain(string);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (debug) {
            _logger.log(Level.FINE, "Getting client aliases");
        }
        return this.mgr.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (debug) {
            _logger.log(Level.FINE, "Getting server aliases");
        }
        return this.mgr.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        if (debug) {
            _logger.log(Level.FINE, "Getting private key for alias:" + string);
        }
        return this.mgr.getPrivateKey(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        debug = false;
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$J2EEKeyManager == null ? (class$com$sun$enterprise$security$J2EEKeyManager = J2EEKeyManager.class$("com.sun.enterprise.security.J2EEKeyManager")) : class$com$sun$enterprise$security$J2EEKeyManager);
    }
}

