/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private XAResource res;
    static Logger _logger = null;

    public XAResourceWrapper(XAResource xAResource) {
        this.res = xAResource;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.print("XAResource.commit: " + XAResourceWrapper.xidToString(xid) + "," + bl);
        this.res.commit(xid, bl);
    }

    public void end(Xid xid, int n) throws XAException {
        this.print("XAResource.end: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(n));
        this.res.end(xid, n);
    }

    public void forget(Xid xid) throws XAException {
        this.print("XAResource.forget: " + XAResourceWrapper.xidToString(xid));
        this.res.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.res.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource instanceof XAResourceWrapper) {
            XAResourceWrapper xAResourceWrapper = (XAResourceWrapper)xAResource;
            boolean bl = this.res.isSameRM(xAResourceWrapper.res);
            this.print("XAResource.isSameRM: " + this.res + "," + xAResourceWrapper.res + "," + bl);
            return bl;
        }
        boolean bl = this.res.isSameRM(xAResource);
        this.print("XAResource.isSameRM: " + this.res + "," + xAResource + "," + bl);
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        this.print("XAResource.prepare: " + XAResourceWrapper.xidToString(xid));
        int n = this.res.prepare(xid);
        this.print("prepare result = " + XAResourceWrapper.flagToString(n));
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        this.print("XAResource.recover: " + XAResourceWrapper.flagToString(n));
        return this.res.recover(n);
    }

    public void rollback(Xid xid) throws XAException {
        this.print("XAResource.rollback: " + XAResourceWrapper.xidToString(xid));
        this.res.rollback(xid);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return this.res.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        this.print("XAResource.start: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(n));
        this.res.start(xid, n);
    }

    private void print(String string) {
        _logger.log(Level.FINE, string);
    }

    public static String xidToString(Xid xid) {
        return String.valueOf((new String(xid.getGlobalTransactionId()) + new String(xid.getBranchQualifier())).hashCode());
    }

    public static String flagToString(int n) {
        switch (n) {
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
            case 3: {
                return "XA_RDONLY";
            }
        }
        return "" + Integer.toHexString(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof XAResourceWrapper) {
            XAResource xAResource = ((XAResourceWrapper)object).res;
            return this.res.equals(xAResource);
        }
        if (object instanceof XAResource) {
            XAResource xAResource = (XAResource)object;
            return this.res.equals(xAResource);
        }
        return false;
    }

    public int hashCode() {
        return this.res.hashCode();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

