/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.IASConfigPool;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolManagerConstants;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.IASPoolObjectWrapper;
import com.sun.enterprise.resource.PortabilityUtils;
import com.sun.enterprise.resource.ResourceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;

public class IASGenericPoolObjects {
    private IASConfigPool configPool = null;
    private int numObjectsInPool = 0;
    private Object numObjectsInPoolLock = new Object();
    private int numObjectsCreated = 0;
    private Object numObjectsCreatedLock = new Object();
    private int numObjectsWaitingCreate = 0;
    private int numObjectsDestroyed;
    private HashMap poolObjectWrapperTable = null;
    private HashMap poolWrapperTable;
    private HashMap poolObjectTable;
    private HashMap transactionTable = null;
    private HashMap commitOrRollbackSet = null;
    private IASPoolHelper poolHelper = null;
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();

    public IASGenericPoolObjects(IASPoolHelper iASPoolHelper, IASConfigPool iASConfigPool) {
        this.configPool = iASConfigPool;
        this.poolHelper = iASPoolHelper;
        int n = iASConfigPool.getMaxPoolSize();
        this.poolObjectWrapperTable = new HashMap(n * 2);
        this.transactionTable = new HashMap(11);
        this.commitOrRollbackSet = new HashMap(11);
        this.poolWrapperTable = new HashMap(n * 2);
        this.poolObjectTable = new HashMap(n * 2);
        this.numObjectsDestroyed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IASPoolObject getPoolObject(Object object, Subject subject, Transaction transaction, boolean bl) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.getPoolObject(...)");
        boolean bl2 = true;
        boolean bl3 = true;
        Object var7_7 = null;
        IASPoolObject iASPoolObject = null;
        long l = this.configPool.getMaxWait();
        while (bl2) {
            iASPoolObject = null;
            boolean bl4 = false;
            Object object2 = this.numObjectsInPoolLock;
            synchronized (object2) {
                if (this.numObjectsInPool > 0) {
                    bl4 = true;
                }
            }
            if ((bl4 || transaction != null) && (iASPoolObject = this.getSuitablePoolObject(subject, object, transaction, bl)) != null) {
                bl2 = false;
            }
            if (iASPoolObject != null) continue;
            Object object3 = this.numObjectsCreatedLock;
            synchronized (object3) {
                int n = this.configPool.getMaxPoolSize();
                if (this.numObjectsCreated + this.numObjectsWaitingCreate < n) {
                    bl4 = true;
                    ++this.numObjectsWaitingCreate;
                } else {
                    bl4 = false;
                }
            }
            if (bl4) {
                iASPoolObject = this.createPoolObject(object, subject);
                bl2 = false;
                continue;
            }
            if (l > 0L) {
                try {
                    long l2 = System.currentTimeMillis();
                    _logger.log(Level.FINE, "IASGenericPoolObjects waits for " + l);
                    IASGenericPoolObjects iASGenericPoolObjects = this;
                    synchronized (iASGenericPoolObjects) {
                        this.wait(l);
                    }
                    long l3 = System.currentTimeMillis();
                    l -= l3 - l2;
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            IASPoolManagerException iASPoolManagerException = new IASPoolManagerException(IASPoolManagerConstants.MAX_OBJECTS_IN_POOL, "1");
            throw iASPoolManagerException;
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.getPoolObject(...)");
        return iASPoolObject;
    }

    private IASPoolObject getSuitablePoolObject(Subject subject, Object object, Transaction transaction, boolean bl) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.getSuitablePoolObject(...)");
        Set set = null;
        IASPoolObject iASPoolObject = null;
        if (transaction != null && bl && (iASPoolObject = this.searchMatchedSharedConnectionCandidates(transaction)) != null) {
            return this.getSuitePoolObject(iASPoolObject, transaction);
        }
        if (iASPoolObject == null && !(set = this.searchMatchedCandidates()).isEmpty()) {
            iASPoolObject = this.matchPoolObject(object, set, subject);
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.getSuitablePoolObject(...)");
        return iASPoolObject;
    }

    private synchronized IASPoolObject getSuitePoolObject(IASPoolObject iASPoolObject, Transaction transaction) {
        Set set = (Set)this.transactionTable.get(transaction);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                IASPoolObject iASPoolObject2 = resourceHandle.getPoolObject();
                if (!iASPoolObject2.getPoolObject().equals(iASPoolObject.getPoolObject())) continue;
                iASPoolObject2.incrementCount();
                return iASPoolObject2;
            }
        }
        return iASPoolObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set searchMatchedCandidates() {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.searchMachedCandidates()");
        HashSet<Object> hashSet = new HashSet<Object>(11);
        HashMap hashMap = this.poolObjectWrapperTable;
        synchronized (hashMap) {
            Collection collection = this.poolObjectWrapperTable.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    IASPoolObjectWrapper iASPoolObjectWrapper = (IASPoolObjectWrapper)vector.elementAt(n2);
                    IASPoolObject iASPoolObject = iASPoolObjectWrapper.getPoolObject();
                    hashSet.add(iASPoolObject.getPoolObject());
                    ++n2;
                }
            }
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.searchMachedCandidates()");
        return hashSet;
    }

    private synchronized IASPoolObject searchMatchedSharedConnectionCandidates(Transaction transaction) {
        Set set = (Set)this.transactionTable.get(transaction);
        IASPoolObject iASPoolObject = null;
        if (set != null) {
            if (set.size() > 1) {
                _logger.log(Level.WARNING, "More than one mc instance found in transaction instance in IASGenericPoolObjects.searchMatchedSharedConnectionCandidates(...)");
            }
            Iterator iterator = set.iterator();
            ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
            iASPoolObject = resourceHandle.getPoolObject();
        }
        return iASPoolObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASPoolObject createPoolObject(Object object, Subject subject) throws IASPoolManagerException {
        Object object2;
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.createPoolObject(...)");
        IASPoolObject iASPoolObject = null;
        try {
            iASPoolObject = this.poolHelper.createPooledObject(subject, object);
            this.initEventListener(iASPoolObject);
            object2 = this.numObjectsCreatedLock;
            synchronized (object2) {
                this.poolObjectTable.put(iASPoolObject.getPoolObject(), iASPoolObject);
                _logger.log(Level.FINE, "IASGenericPoolObjects.createPoolObject(...) poolObjectTable.size()=" + this.poolObjectTable.size());
            }
        }
        catch (IASPoolManagerException iASPoolManagerException) {
            Object object3 = this.numObjectsCreatedLock;
            synchronized (object3) {
                --this.numObjectsWaitingCreate;
            }
            throw iASPoolManagerException;
        }
        object2 = this.numObjectsCreatedLock;
        synchronized (object2) {
            _logger.log(Level.FINE, "NumObjectsCreated before increment: " + this.numObjectsCreated);
            ++this.numObjectsCreated;
            --this.numObjectsWaitingCreate;
            _logger.log(Level.FINE, "NumObjectsCreated after increment: " + this.numObjectsCreated);
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.createPoolObject(...)");
        return iASPoolObject;
    }

    private IASPoolObject matchPoolObjectInTransaction(Object object, Set set, Subject subject) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.matchPoolObjectInTransaction(...)");
        Object object2 = null;
        IASPoolObject iASPoolObject = null;
        try {
            object2 = this.poolHelper.matchPooledObject(set, subject, object);
        }
        catch (NotSupportedException notSupportedException) {
            object2 = null;
            this.configPool.setSteadyPoolSize(0);
        }
        if (object2 != null) {
            iASPoolObject = (IASPoolObject)this.poolObjectTable.get(object2);
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.matchPoolObjectInTransaction(...)");
        return iASPoolObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASPoolObject matchPoolObject(Object object, Set set, Subject subject) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.matchPoolObject(...)");
        Object object2 = null;
        IASPoolObject iASPoolObject = null;
        boolean bl = false;
        while (!bl && !set.isEmpty()) {
            try {
                object2 = this.poolHelper.matchPooledObject(set, subject, object);
            }
            catch (NotSupportedException notSupportedException) {
                object2 = null;
                this.configPool.setSteadyPoolSize(0);
            }
            if (object2 != null) {
                iASPoolObject = (IASPoolObject)this.poolObjectTable.get(object2);
                if (iASPoolObject != null) {
                    IASPoolObjectWrapper iASPoolObjectWrapper = (IASPoolObjectWrapper)this.poolWrapperTable.get(iASPoolObject);
                    HashMap hashMap = this.poolObjectWrapperTable;
                    synchronized (hashMap) {
                        if (iASPoolObjectWrapper != null) {
                            if (iASPoolObjectWrapper.getIsMarked()) {
                                set.remove(object2);
                                iASPoolObject = null;
                            } else {
                                this.removePoolObjectFromPool(iASPoolObject);
                                iASPoolObjectWrapper.setIsMarked(true);
                                bl = true;
                            }
                        } else {
                            set.remove(object2);
                            iASPoolObject = null;
                        }
                        continue;
                    }
                }
                set.remove(object2);
                iASPoolObject = null;
                continue;
            }
            bl = true;
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.matchPoolObject(...)");
        return iASPoolObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePoolObjectFromPool(IASPoolObject iASPoolObject) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.removePoolObjectFromPool(...)");
        String string = iASPoolObject.getUserName();
        Vector vector = (Vector)this.poolObjectWrapperTable.get(string);
        IASPoolObjectWrapper iASPoolObjectWrapper = null;
        IASPoolObject iASPoolObject2 = null;
        _logger.log(Level.FINER, "vector size: " + vector.size());
        int n = 0;
        while (n < vector.size()) {
            iASPoolObjectWrapper = (IASPoolObjectWrapper)vector.get(n);
            if (iASPoolObjectWrapper != null && (iASPoolObject2 = iASPoolObjectWrapper.getPoolObject()) != null && iASPoolObject.equals(iASPoolObject2)) {
                vector.removeElementAt(n);
                if (vector.isEmpty()) {
                    this.poolObjectWrapperTable.remove(string);
                }
                Object object = this.numObjectsInPoolLock;
                synchronized (object) {
                    _logger.log(Level.FINE, "Before numObjectsInPool--: " + this.numObjectsInPool);
                    --this.numObjectsInPool;
                    _logger.log(Level.FINE, "After numObjectsInPool--: " + this.numObjectsInPool);
                    break;
                }
            }
            ++n;
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.removePoolObjectFromPool(...)");
    }

    private void initEventListener(IASPoolObject iASPoolObject) throws IASPoolManagerException {
        iASPoolObject.addEventListener(this);
    }

    private Object getPoolObjectHandle(IASPoolObject iASPoolObject, Subject subject, Object object) throws IASPoolManagerException {
        return iASPoolObject.getUnderlyingObject(subject, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void returnObjectToPool(IASPoolObject iASPoolObject) {
        block29: {
            IASGenericPoolObjects iASGenericPoolObjects;
            _logger.log(Level.FINE, "In start of IASGenericPoolObjects.returnObjectToPool(...)");
            try {
                block30: {
                    try {
                        Vector<IASPoolObjectWrapper> vector;
                        String string;
                        HashMap hashMap = this.commitOrRollbackSet;
                        synchronized (hashMap) {
                            boolean bl = false;
                            Collection collection = this.commitOrRollbackSet.values();
                            Object object = collection.iterator();
                            block18: while (true) {
                                if (!object.hasNext()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 8, 25] lbl11 : MonitorExitStatement: MONITOREXIT : hashMap
                                    HashMap hashMap2 = this.poolObjectWrapperTable;
                                    synchronized (hashMap2) {
                                        bl = false;
                                        object = this.numObjectsInPoolLock;
                                        synchronized (object) {
                                            if (this.numObjectsInPool < this.configPool.getSteadyPoolSize()) {
                                                bl = true;
                                            }
                                            if (!bl) break block26;
                                        }
                                        string = iASPoolObject.getUserName();
                                        vector = null;
                                        if (!this.poolObjectWrapperTable.containsKey(string)) break;
                                        vector = (Vector<IASPoolObjectWrapper>)this.poolObjectWrapperTable.get(string);
                                        break block27;
                                    }
                                }
                                Set set = (Set)object.next();
                                Iterator iterator = set.iterator();
                                do {
                                    if (!iterator.hasNext()) continue block18;
                                    IASPoolObject iASPoolObject2 = (IASPoolObject)iterator.next();
                                    if (!iASPoolObject.getPoolObject().equals(iASPoolObject2.getPoolObject())) continue;
                                    iterator.remove();
                                    bl = true;
                                    continue block18;
                                } while (!bl);
                                if (!set.isEmpty()) continue;
                                object.remove();
                            }
                        }
                        {
                            block26: {
                                block27: {
                                    vector = new Vector<IASPoolObjectWrapper>(10, 10);
                                    this.poolObjectWrapperTable.put(string, vector);
                                }
                                IASPoolObjectWrapper iASPoolObjectWrapper = null;
                                IASPoolObject iASPoolObject2 = (IASPoolObject)this.poolObjectTable.get(iASPoolObject.getPoolObject());
                                if (iASPoolObject2 != null) {
                                    iASPoolObject2.setIsClosed(false);
                                    iASPoolObjectWrapper = (IASPoolObjectWrapper)this.poolWrapperTable.get(iASPoolObject2);
                                    if (iASPoolObjectWrapper == null) {
                                        iASPoolObjectWrapper = new IASPoolObjectWrapper(iASPoolObject2, System.currentTimeMillis());
                                        this.poolWrapperTable.put(iASPoolObject2, iASPoolObjectWrapper);
                                    } else {
                                        iASPoolObjectWrapper.setTimeReturnToPool(System.currentTimeMillis());
                                        iASPoolObjectWrapper.setIsMarked(false);
                                    }
                                } else {
                                    iASPoolObject.setIsClosed(false);
                                    iASPoolObjectWrapper = new IASPoolObjectWrapper(iASPoolObject, System.currentTimeMillis());
                                    this.poolObjectTable.put(iASPoolObject.getPoolObject(), iASPoolObject);
                                    this.poolWrapperTable.put(iASPoolObject, iASPoolObjectWrapper);
                                }
                                vector.addElement(iASPoolObjectWrapper);
                                Object object = this.numObjectsInPoolLock;
                                synchronized (object) {
                                    ++this.numObjectsInPool;
                                    _logger.log(Level.FINE, "numObjectsInPool after increment: " + this.numObjectsInPool);
                                    break block30;
                                }
                            }
                            this.destroyPoolObject(iASPoolObject);
                            Object object = this.numObjectsCreatedLock;
                            synchronized (object) {
                                _logger.log(Level.FINE, "NumObjectsCreated after decrement: " + this.numObjectsCreated);
                            }
                        }
                    }
                    catch (IASPoolManagerException iASPoolManagerException) {
                        Object[] objectArray = new Object[]{iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode()};
                        _logger.log(Level.SEVERE, "IASPoolManagerConstants.return_object_error", objectArray);
                        Object var19_20 = null;
                        IASGenericPoolObjects iASGenericPoolObjects2 = this;
                        synchronized (iASGenericPoolObjects2) {
                            this.notifyAll();
                            break block29;
                        }
                    }
                }
                Object var19_19 = null;
                iASGenericPoolObjects = this;
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                IASGenericPoolObjects iASGenericPoolObjects3 = this;
                synchronized (iASGenericPoolObjects3) {
                    this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (iASGenericPoolObjects) {
                this.notifyAll();
            }
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.returnObjectToPool(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPoolObject(IASPoolObject iASPoolObject) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASGenericPoolObjects.destroyPoolObject(...)");
        Object object = this.numObjectsCreatedLock;
        synchronized (object) {
            this.poolObjectTable.remove(iASPoolObject.getPoolObject());
            this.poolWrapperTable.remove(iASPoolObject);
            iASPoolObject.destroy();
            --this.numObjectsCreated;
            ++this.numObjectsDestroyed;
        }
        _logger.log(Level.FINE, "In end of IASGenericPoolObjects.destroyPoolObject(...)");
        IASGenericPoolObjects iASGenericPoolObjects = this;
        synchronized (iASGenericPoolObjects) {
            this.notifyAll();
        }
    }

    public synchronized void resourceEnlisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException {
        HashSet<ResourceHandle> hashSet = (HashSet<ResourceHandle>)this.transactionTable.get(transaction);
        if (hashSet == null) {
            hashSet = new HashSet<ResourceHandle>();
            this.transactionTable.put(transaction, hashSet);
        }
        hashSet.add(resourceHandle);
    }

    public synchronized void resourceDelisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException {
        Set set = (Set)this.transactionTable.get(transaction);
        if (set != null) {
            set.remove(resourceHandle);
        }
    }

    public synchronized ResourceHandle getPoolObjectSuiteToResourceHandle(Object object, Transaction transaction) throws IllegalStateException {
        Set set;
        if (this.transactionTable.containsKey(transaction) && (set = (Set)this.transactionTable.get(transaction)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                if (!object.equals(resourceHandle.getPoolObject().getPoolObject())) continue;
                return resourceHandle;
            }
        }
        return null;
    }

    public synchronized void transactionCompleted(Transaction transaction) throws IllegalStateException, IASPoolManagerException {
        if (this.transactionTable.containsKey(transaction)) {
            Set set = (Set)this.transactionTable.get(transaction);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                    this.resourceDelisted(transaction, resourceHandle);
                    resourceHandle.getPoolObject().cleanup();
                    this.returnObjectToPool(resourceHandle.getPoolObject());
                }
            }
            this.commitOrRollbackSet.remove(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneCommitOrRollback(IASPoolObject iASPoolObject, Transaction transaction) throws IASPoolManagerException {
        if (iASPoolObject.getIsClosed()) {
            this.resourceDelisted(transaction, this.getPoolObjectSuiteToResourceHandle(iASPoolObject.getPoolObject(), transaction));
            iASPoolObject.cleanup();
            this.returnObjectToPool(iASPoolObject);
        } else {
            HashMap hashMap = this.commitOrRollbackSet;
            synchronized (hashMap) {
                Set<IASPoolObject> set = null;
                if (this.commitOrRollbackSet.containsKey(transaction)) {
                    set = (Set)this.commitOrRollbackSet.get(transaction);
                    set.add(iASPoolObject);
                } else {
                    set = new HashSet(11);
                    set.add(iASPoolObject);
                    this.commitOrRollbackSet.put(transaction, set);
                }
            }
        }
    }

    public boolean getCommitOrRollbackStatus(IASPoolObject iASPoolObject, Transaction transaction) throws IASPoolManagerException {
        Set set = (Set)this.commitOrRollbackSet.get(transaction);
        if (set == null) {
            return false;
        }
        return set.contains(iASPoolObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPoolSize() {
        HashMap hashMap = this.poolObjectWrapperTable;
        synchronized (hashMap) {
            if (!this.poolObjectWrapperTable.isEmpty()) {
                Collection collection = this.poolObjectWrapperTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Vector vector = (Vector)iterator.next();
                    Iterator iterator2 = vector.iterator();
                    long l = System.currentTimeMillis();
                    while (iterator2.hasNext()) {
                        IASPoolObjectWrapper iASPoolObjectWrapper = (IASPoolObjectWrapper)iterator2.next();
                        IASPoolObject iASPoolObject = iASPoolObjectWrapper.getPoolObject();
                        if (l - iASPoolObjectWrapper.getTimeReturnToPool() <= (long)this.configPool.getUnusedMaxLife()) continue;
                        try {
                            this.destroyPoolObject(iASPoolObject);
                            Object object = this.numObjectsInPoolLock;
                            synchronized (object) {
                                --this.numObjectsInPool;
                            }
                        }
                        catch (IASPoolManagerException iASPoolManagerException) {
                            Object[] objectArray = new Object[]{iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode()};
                            _logger.log(Level.SEVERE, "IASPoolManagerConstants.check_pool_size_error", objectArray);
                        }
                        iterator2.remove();
                    }
                    if (!vector.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }
    }

    int getTotalNumOfObjectsCreated() {
        return this.numObjectsCreated;
    }

    int getTotalNumOfObjectsNotInUse() {
        return this.numObjectsInPool;
    }

    int getTotalNumOfObjectsDestroyed() {
        return this.numObjectsDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getAgeObjectArray() {
        _logger.log(Level.FINE, "In IASGenericPoolObjects.getAgeObjectArray(). ");
        HashMap hashMap = this.poolObjectWrapperTable;
        synchronized (hashMap) {
            if (!this.poolObjectWrapperTable.isEmpty()) {
                _logger.log(Level.FINE, "poolObjectWrapperTable not empty.");
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                Collection collection = this.poolObjectWrapperTable.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Vector vector = (Vector)iterator.next();
                    Iterator iterator2 = vector.iterator();
                    long l = System.currentTimeMillis();
                    while (iterator2.hasNext()) {
                        IASPoolObjectWrapper iASPoolObjectWrapper = (IASPoolObjectWrapper)iterator2.next();
                        long l2 = l - iASPoolObjectWrapper.getTimeReturnToPool();
                        int n = (int)(l2 / 1000L);
                        Integer n2 = new Integer(n);
                        arrayList.add(n2);
                    }
                }
                _logger.log(Level.FINE, "Return array of objects's age for pool.");
                return arrayList;
            }
            _logger.log(Level.FINE, "Array of objects's age for pool is null.");
            return null;
        }
    }

    public IASPoolObject getCorrespondPoolObject(Object object) {
        return (IASPoolObject)this.poolObjectTable.get(object);
    }
}

